<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class GoogleAuthController extends Controller
{
    // Step 1: Redirect user to Google OAuth consent screen
    public function init()
    {
        $query = http_build_query([
            'client_id' => env('GOOGLE_CLIENT_ID'),
            'redirect_uri' => env('GOOGLE_REDIRECT_URI'),
            'response_type' => 'code',
            'scope' => 'https://www.googleapis.com/auth/calendar.events',
            'access_type' => 'offline',
            'prompt' => 'consent'
        ]);

        return redirect("https://accounts.google.com/o/oauth2/v2/auth?$query");
    }

    // Step 2: Handle callback and return tokens as JSON
    public function callback(Request $request)
    {
        if (!$request->has('code')) {
            return response()->json(['error' => 'Missing authorization code'], 400);
        }

        $response = Http::asForm()->post('https://oauth2.googleapis.com/token', [
            'code' => $request->input('code'),
            'client_id' => env('GOOGLE_CLIENT_ID'),
            'client_secret' => env('GOOGLE_CLIENT_SECRET'),
            'redirect_uri' => env('GOOGLE_REDIRECT_URI'),
            'grant_type' => 'authorization_code',
        ]);

        $data = $response->json();

        if (isset($data['error'])) {
            return response()->json([
                'status' => 'error',
                'message' => $data['error_description'] ?? $data['error']
            ], 400);
        }

        if (isset($data['refresh_token'])) {
            file_put_contents(storage_path('app/google_refresh_token.json'), json_encode($data, JSON_PRETTY_PRINT));
        }

        return response()->json([
            'status' => 'success',
            'message' => 'Refresh token created successfully',
            'data' => $data
        ]);
    }
}
