<?php

namespace App\Http\Controllers;

use Session;
use Pusher\Pusher;
use App\Helper\Helper;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use PDF;
use Illuminate\Support\Str;
use App\Http\Controllers\InheritApiController;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Log;
use Yajra\DataTables\Facades\DataTables;
use DateTime;
use Carbon\Carbon;

class LeadsController extends Controller
{

    public function indexSubLeads(Request $request)
    {
        $userdetails = InheritApiController::headerUserDetails();
        $timezone = $userdetails->data->timezone;
        // Initialize variables
        $group_ids = [];
        $associated_extensions = [];
        $map = [];
        $url = env('API_URL') . "extension-group-map";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $map = $response->data;
                //echo"<pre>";print_r($map);die;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("extension.extension-group", compact("errors", $errors));
        }

        /* close list */
        $title = "Group List | " . env('APP_NAME');
        $url = env('API_URL') . 'extension-group';
        $response = Helper::GetApi($url);
        if ($response->success) {
            $group = $response->data;
        }
        $crm_system = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-system-setting";
        try {
            $response = Helper::GetApi($url);
            // echo "<pre>";print_r($response);die;

            if ($response->success) {
                $crm_system = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.sub-lead-list", ["errors" => $errors]);
        }
        $lead_status = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "leadStatus";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $lead_status = (array) $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.sub-lead-list", ["errors" => $errors]);
        }

        // return view("leads.list", ['lead_status' => $lead_status]);

        $view_on_leads = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-view-on-leads";
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $view_on_leads = (array) $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.sub-lead-list", ["errors" => $errors]);
        }


        /* $inherit_list = new InheritApiController;
        $users = $inherit_list->getExtensionListCRM();

        echo "<pre>";print_r($users);die;*/

        $users = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "users";
        try {
            $response = Helper::GetApi($url);

            //echo "<pre>";print_r($response);die;

            if ($response->success) {
                $users = (array) $response->data;

                // echo "<pre>";print_r($users);die;

            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.sub-lead-list", ["errors" => $errors]);
        }

        /*$lead_status = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lead-status";
        try
        {
            $response = Helper::GetApi($url);
            if ($response->success)
            {
                $lead_status = (array) $response->data;
            }
            else
            {
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("leads.list", ["errors" => $errors]);
        }*/

        $arrLeadStatusRekeyed = Helper::rekeyArray($lead_status, 'lead_title_url');
        $arrUsersRekeyed = Helper::rekeyArray($users, 'id');

        //echo "<pre>";print_r($arrUsersRekeyed);die;

        $page = 0;
        $upper_limit = 10000;
        $urlpage = $request->page;
        if (!empty($urlpage) && $urlpage > 1) {
            $urlpage = $urlpage - 1;
            $lower_limit = $urlpage * 10;
        } else {
            $lower_limit = 0;
        }

        if ($request->isMethod('post')) {
            $lower_limit = 0;
            $page = 1;
        }

        if ($request->submit_download == 'excel') {

            $upper_limit = '';
        }


        $body = array(
            'level' => Session::get('userLevel'),
            'start_date' => $request->start_date,
            'end_date' =>  $request->end_date,
            'lower_limit' => $lower_limit,
            'upper_limit' => $upper_limit,
            'id' => Session::get('id'),
            'lead_status' => $request->lead_status,
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'company_name' => $request->company_name,
            'assigned_to' => $request->assigned_to,
            'lead_type' => $request->lead_type,
            'phone_number' => $request->phone_number,
            'crm_id' => $request->crm_id,


        );

        //  echo "<pre>";print_r($body);die;
        // Get the user role and extension from the session
        $userRole = Session::get('role');
        $userExtension = Session::get('extension');

        // Apply the logic if the user role is manager
        if ($userRole === 'manager' && !empty($userExtension)) {

            // Step 1: Find all group_ids for the manager's extension
            foreach ($map as $entry) {
                if ($entry->extension == $userExtension && $entry->is_deleted == 0) {
                    // Ensure no duplicate group_ids are added
                    if (!in_array($entry->group_id, $group_ids)) {
                        $group_ids[] = $entry->group_id;
                    }
                }
            }
            Log::info('Groups reached', ['group_ids' => $group_ids]);

            // Step 2: Collect all extensions associated with the found group_ids
            if (!empty($group_ids)) {
                foreach ($map as $entry) {
                    // Check that the entry is not deleted and belongs to one of the collected group_ids
                    if (in_array($entry->group_id, $group_ids) && $entry->is_deleted == 0) {
                        $associated_extensions[] = $entry->user_id;
                        Log::info('Added extension: ' . $entry->user_id);
                    }
                }

                // Debugging: Log the final list of associated extensions
                Log::info('Associated extensions: ' . json_encode($associated_extensions));
            }
        }


        $leads = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "leads";
        try {
            $response = Helper::PostApi($url, $body);
            /*  if ($request->submit_download == 'excel')
            {

           // echo "<pre>";print_r($response);die;
                
                header("Content-type: text/csv");
                header("Content-Disposition: attachment; filename=" . time() . ".csv");
                header("Pragma: no-cache");
                header("Expires: 0");
                $columns = array('first_name', 'last_name','email','phone','state','legal_company_name','lead_status','created_at');

                $file = fopen('php://output', 'w');
                fputcsv($file, $columns);
                if (!empty($response->data))
                {
                    foreach ($response->data as $key => $val)
                    {
                        fputcsv($file, array($val->first_name, $val->last_name , $val->email, $val->phone, $val->state, $val->legal_company_name, $val->lead_status, $val->created_at));
                    }
                }
                exit();
            }
            */

            if ($response->success) {
                $leads = $response->data;
                if ($userRole === 'manager' && !empty($associated_extensions)) {
                    $leads = array_filter($leads, function ($lead) use ($associated_extensions) {
                        return in_array($lead->assigned_to, $associated_extensions);
                    });
                } else {
                    $leads = $leads;
                }

                $record_count = $response->record_count;
                // echo "<pre>";print_r($response);die;

            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.sub-lead-list", ["errors" => $errors]);
        }
        $sortedUsers = $this->groupAndSortUsers($users);
        // echo "<pre>";print_r($leads);die;

        return view("leads.sub-lead-list", ["leads" => $leads, "record_count" => $record_count, "lower_limit" => $lower_limit, "lead_status" => $arrLeadStatusRekeyed, 'users' => $arrUsersRekeyed, 'page' => $page, 'view_on_leads' => $view_on_leads, 'user' => $users, 'sortedUsers' => $sortedUsers, 'crm_system' => $crm_system, 'timezone' => $timezone]);
    }

    public function indexSubLeadsNew(Request $request)
    {
        $userdetails = InheritApiController::headerUserDetails();
        $timezone = $userdetails->data->timezone;
        // Initialize variables
        $group_ids = [];
        $associated_extensions = [];
        $map = [];
        $url = env('API_URL') . "extension-group-map";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $map = $response->data;
                //echo"<pre>";print_r($map);die;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("extension.extension-group", compact("errors", $errors));
        }

        /* close list */
        $title = "Group List | " . env('APP_NAME');
        $url = env('API_URL') . 'extension-group';
        $response = Helper::GetApi($url);
        if ($response->success) {
            $group = $response->data;
        }
        $crm_system = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-system-setting";
        try {
            $response = Helper::GetApi($url);
            // echo "<pre>";print_r($response);die;

            if ($response->success) {
                $crm_system = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.sub-lead-list", ["errors" => $errors]);
        }
        $lead_status = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "leadStatus";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $lead_status = (array) $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.sub-lead-list", ["errors" => $errors]);
        }

        $view_on_leads = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-view-on-leads";
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $view_on_leads = (array) $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.sub-lead-list-new", ["errors" => $errors]);
        }

        $users = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "users";
        try {
            $response = Helper::GetApi($url);

            //echo "<pre>";print_r($response);die;

            if ($response->success) {
                $users = (array) $response->data;

                // echo "<pre>";print_r($users);die;

            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.sub-lead-list", ["errors" => $errors]);
        }

        $arrLeadStatusRekeyed = Helper::rekeyArray($lead_status, 'lead_title_url');
        $arrUsersRekeyed = Helper::rekeyArray($users, 'id');

        //echo "<pre>";print_r($arrUsersRekeyed);die;

        $upper_limit = 10;

        // Get selected value from filter
        $show = $request->input('show', 10);
        if ($show == 25 || $show == 50 || $show == 100) {
            $upper_limit = $show;
        }

        $urlpage = $request->page;

        $page = 0;
        $lower_limit = 0;

        if (!empty($urlpage) && $urlpage > 1) {
            $urlpage = $urlpage - 1;
            $lower_limit = $urlpage * $upper_limit;
        }

        if ($request->isMethod('post')) {
            $lower_limit = 0;
            $page = 1;
        }
        $searchTerm = $request->input('search');




        if ($request->submit_download == 'excel') {

            $upper_limit = '';
        }


        $body = array(
            'level' => Session::get('userLevel'),
            'start_date' => $request->start_date,
            'end_date' =>  $request->end_date,
            'lower_limit' => $lower_limit,
            'upper_limit' => $upper_limit,
            'id' => Session::get('id'),
            'lead_status' => $request->lead_status,
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'company_name' => $request->company_name,
            'assigned_to' => $request->assigned_to,
            'lead_type' => $request->lead_type,
            'phone_number' => $request->phone_number,
            'crm_id' => $request->crm_id,
            'search' => $searchTerm


        );

        //  echo "<pre>";print_r($body);die;
        // Get the user role and extension from the session
        $userRole = Session::get('role');
        $userExtension = Session::get('extension');

        // Apply the logic if the user role is manager
        if ($userRole === 'manager' && !empty($userExtension)) {

            // Step 1: Find all group_ids for the manager's extension
            foreach ($map as $entry) {
                if ($entry->extension == $userExtension && $entry->is_deleted == 0) {
                    // Ensure no duplicate group_ids are added
                    if (!in_array($entry->group_id, $group_ids)) {
                        $group_ids[] = $entry->group_id;
                    }
                }
            }
            Log::info('Groups reached', ['group_ids' => $group_ids]);

            // Step 2: Collect all extensions associated with the found group_ids
            if (!empty($group_ids)) {
                foreach ($map as $entry) {
                    // Check that the entry is not deleted and belongs to one of the collected group_ids
                    if (in_array($entry->group_id, $group_ids) && $entry->is_deleted == 0) {
                        $associated_extensions[] = $entry->user_id;
                        Log::info('Added extension: ' . $entry->user_id);
                    }
                }

                // Debugging: Log the final list of associated extensions
                Log::info('Associated extensions: ' . json_encode($associated_extensions));
            }
        }


        $leads = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "sub-lead-new";
        try {
            $response = Helper::PostApi($url, $body);
        //echo "<pre>";print_r($response);die;

            if ($response->success) {
                $leads = $response->data;

                $record_count = $response->record_count;

                    
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.sub-lead-list", ["errors" => $errors]);
        }
        $sortedUsers = $this->groupAndSortUsers($users);
        // echo "<pre>";print_r($record_count);die;
           if ($request->ajax()) {



            log::info("run ajax");
            $dataTable = DataTables::of($leads)


                ->addColumn('#', function ($lead) {
                    return $lead->id;
                })
                ->addColumn('lead_status', function ($lead) use ($arrLeadStatusRekeyed) {
                    if (isset($arrLeadStatusRekeyed[$lead->lead_status])) {
                        return '<span class="badge" style="background:' . $arrLeadStatusRekeyed[$lead->lead_status]->color_code . '; color:#fff">' .
                            $arrLeadStatusRekeyed[$lead->lead_status]->title .
                            '</span>';
                    }
                    return '';
                })
                ->addColumn('assigned_to_user', function ($lead) use ($arrUsersRekeyed) {
                    if (isset($arrUsersRekeyed[$lead->assigned_to])) {
                        $user = $arrUsersRekeyed[$lead->assigned_to];
                        return ucfirst($user->first_name) . ' ' . ucfirst($user->last_name);
                    }
                    return '';
                })
                ->addColumn('created_by_user', function ($lead) use ($arrUsersRekeyed) {
                    if (isset($arrUsersRekeyed[$lead->created_by])) {
                        $user = $arrUsersRekeyed[$lead->created_by];
                        return ucfirst($user->first_name) . ' ' . ucfirst($user->last_name);
                    }
                    return '';
                })
                ->addColumn('action', function ($lead) {
                    return
                        '<div class="list-icons d-inline-flex">
                    <a style="cursor:pointer;" type="button" href="/leads/' . $lead->id . '/edit" class="list-icons-item me-10"><i class="fa fa-edit"></i></a>
                 <a style="cursor:pointer;"  type="button" href="#" class="list-icons-item me-10 openLeadDelete" data-id="' . $lead->id . '"><i class="fa fa-trash-o"></i></a>
                 <a  style="cursor:pointer;" type="button" href="/leads/view?id=' . $lead->id . '" class="list-icons-item me-10"><i class="fa fa-eye"></i></a>
                 </div>';
                })



                ->rawColumns(['lead_status', 'action']);

            // Get the array response (not JSON yet)
            $response = $dataTable->toArray();
            // Add your dynamic columns info
            $response['lead_view'] = $view_on_leads;

            return response()->json($response);
        }

        return view("leads.sub-lead-list-new", ["leads" => $leads, "record_count" => $record_count, "lower_limit" => $lower_limit, "page" => $page, "show" => $show, "searchTerm" => $searchTerm, "lead_status" => $arrLeadStatusRekeyed, 'users' => $arrUsersRekeyed, 'page' => $page, 'view_on_leads' => $view_on_leads, 'user' => $users, 'sortedUsers' => $sortedUsers, 'crm_system' => $crm_system, 'timezone' => $timezone]);
    }

    public function index(Request $request)
    {
        $inherit_list = new InheritApiController;
        $extension_list = $inherit_list->getExtensionList();
        $userdetails = InheritApiController::headerUserDetails();
        $timezone = $userdetails->data->timezone;

        $errors = new MessageBag();
        /* list list */
        $map = [];
        $url = env('API_URL') . "extension-group-map";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $map = $response->data;
                //echo"<pre>";print_r($map);die;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("extension.extension-group", compact("errors", $errors));
        }

        /* close list */
        $title = "Group List | " . env('APP_NAME');
        $url = env('API_URL') . 'extension-group';
        $response = Helper::GetApi($url);
        if ($response->success) {
            $group = $response->data;
        }
        $crm_system = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-system-setting";
        try {
            $response = Helper::GetApi($url);
            // echo "<pre>";print_r($response);die;

            if ($response->success) {
                $crm_system = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }
        $lead_status = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "leadStatus";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $lead_status = (array) $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.list", ["errors" => $errors]);
        }

        // return view("leads.list", ['lead_status' => $lead_status]);

        $view_on_leads = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-view-on-leads";
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $view_on_leads = (array) $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.list", ["errors" => $errors]);
        }


        /* $inherit_list = new InheritApiController;
        $users = $inherit_list->getExtensionListCRM();

        echo "<pre>";print_r($users);die;*/

        $users = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "users";
        try {
            $response = Helper::GetApi($url);

            //echo "<pre>";print_r($response);die;

            if ($response->success) {
                $users = (array) $response->data;

                // echo "<pre>";print_r($users);die;

            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.list", ["errors" => $errors]);
        }

        /*$lead_status = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lead-status";
        try
        {
            $response = Helper::GetApi($url);
            if ($response->success)
            {
                $lead_status = (array) $response->data;
            }
            else
            {
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("leads.list", ["errors" => $errors]);
        }*/

        $arrLeadStatusRekeyed = Helper::rekeyArray($lead_status, 'lead_title_url');
        $arrUsersRekeyed = Helper::rekeyArray($users, 'id');

        //echo "<pre>";print_r($arrUsersRekeyed);die;

        $page = 0;
        $upper_limit = 10000;
        $urlpage = $request->page;
        if (!empty($urlpage) && $urlpage > 1) {
            $urlpage = $urlpage - 1;
            $lower_limit = $urlpage * 10;
        } else {
            $lower_limit = 0;
        }

        if ($request->isMethod('post')) {
            $lower_limit = 0;
            $page = 1;
        }

        if ($request->submit_download == 'excel') {

            $upper_limit = '';
        }


        $body = array(
            'level' => Session::get('userLevel'),
            'start_date' => $request->start_date,
            'end_date' =>  $request->end_date,
            'lower_limit' => $lower_limit,
            'upper_limit' => $upper_limit,
            'id' => Session::get('id'),
            'lead_status' => $request->lead_status,
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'company_name' => $request->company_name,
            'assigned_to' => $request->assigned_to,
            'lead_type' => $request->lead_type,
            'phone_number' => $request->phone_number,
            'crm_id' => $request->crm_id,
            'dba' => $request->dba,


        );

        //  echo "<pre>";print_r($body);die;


        // Initialize variables
        $group_ids = [];
        $associated_extensions = [];

        // Get the user role and extension from the session
        $userRole = Session::get('role');
        $userExtension = Session::get('extension');

        // Apply the logic if the user role is manager
        if ($userRole === 'manager' && !empty($userExtension)) {

            // Step 1: Find all group_ids for the manager's extension
            foreach ($map as $entry) {
                if ($entry->extension == $userExtension && $entry->is_deleted == 0) {
                    // Ensure no duplicate group_ids are added
                    if (!in_array($entry->group_id, $group_ids)) {
                        $group_ids[] = $entry->group_id;
                    }
                }
            }
            Log::info('Groups reached', ['group_ids' => $group_ids]);

            // Step 2: Collect all extensions associated with the found group_ids
            if (!empty($group_ids)) {
                foreach ($map as $entry) {
                    // Check that the entry is not deleted and belongs to one of the collected group_ids
                    if (in_array($entry->group_id, $group_ids) && $entry->is_deleted == 0) {
                        $associated_extensions[] = $entry->user_id;
                        Log::info('Added extension: ' . $entry->user_id);
                    }
                }

                // Debugging: Log the final list of associated extensions
                Log::info('Associated extensions: ' . json_encode($associated_extensions));
            }
        }


        $leads = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "leads";
        $currentUserId = Session::get('id'); // or whatever method you use to get the current user ID

        try {
            $response = Helper::PostApi($url, $body);

            if ($response->success) {
                $leads = $response->data;
                //echo "<pre>"; print_r($leads); die;
                // Apply filtering based on associated extensions
                if ($userRole === 'manager' && !empty($associated_extensions)) {
                    $leads = array_filter($leads, function ($lead) use ($associated_extensions) {
                        return in_array($lead->assigned_to, $associated_extensions);
                    });
                } else {
                    $leads = $leads;
                }

                $record_count = $response->record_count;
                // Assuming you have the current user's ID in $currentUserId
                //dd($currentUserId);
                $currentUserRole = Session::get('role');
                // Check if the current user's role is either admin, agent, or manager
                $rolesToFilter = ['agent', 'manager'];
                //        // Filter leads where the current user's ID matches either opener_id or closer_id
                // if (in_array($currentUserRole, $rolesToFilter)) {
                //    $filteredLeads1 = array_filter($leads, function ($lead) use ($currentUserId) {
                //     // Check if $lead is an object before accessing its properties
                //     if (is_object($lead)) {
                //       // Ensure closer_id is always treated as an array
                //       $closerIds = isset($lead->closer_id)
                //       ? (is_array($lead->closer_id) ? $lead->closer_id : json_decode($lead->closer_id, true))
                //       : [];
                //       //dd($closerIds);

                //   // Handle JSON decoding errors
                //   if (json_last_error() !== JSON_ERROR_NONE || $closerIds === null) {
                //       $closerIds = [];
                //   }
                // Check if current user ID is in closer_ids
                // Convert both current user ID and closer IDs to strings for comparison
                // $currentUserIdString = (string)$currentUserId; // Convert user ID to string
                // $closerIds = array_map('strval', $closerIds); // Convert closer IDs to strings
                // // Debugging output
                //  // dd($closerIds, $currentUserIdString, in_array($currentUserIdString, $closerIds));

                // // Include the lead if closer_id is empty or matches the current user ID
                // return empty($closerIds) || in_array($currentUserIdString, $closerIds);
                //         }
                //         return false; // If $lead is not an object, skip it
                //     });


                //dd($filteredLeads1);
                // if (!empty($filteredLeads1)) {
                //     // Override the leads with the filtered leads
                //     $leads = $filteredLeads1;
                // }

                // Debug output for checking

                //}
            } else {
                // Handle errors
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.list", ["errors" => $errors]);
        }


        $sortedUsers = $this->groupAndSortUsers($users);
        //echo "<pre>";print_r($leads);die;

        return view("leads.list", ["leads" => $leads, "merchants" => $this->getMerchants(), "record_count" => $record_count, "lower_limit" => $lower_limit, "lead_status" => $arrLeadStatusRekeyed, 'users' => $arrUsersRekeyed, 'page' => $page, 'view_on_leads' => $view_on_leads, 'user' => $users, 'sortedUsers' => $sortedUsers, 'crm_system' => $crm_system, 'map' => $map, 'group' => $group, 'title' => $title, 'extension_list' => $extension_list, 'timezone' => $timezone]);
    }



    /**
     * @param Request $request
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View
     * Returns add lead page
     */
    public function addShow(Request $request)
    {
        $uuid = Str::uuid();

        $inherit_list = new InheritApiController;
        $users = $inherit_list->getExtensionList();




        $lead_status = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "leadStatus";
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $lead_status = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        $domain_list = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "domain-list";
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $domain_list = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }


        $labels = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-labels";
        try {
            $response = Helper::GetApi($url);
            // echo "<pre>";print_r($response);die;
            if ($response->success) {
                $labels = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        //echo "<pre>";print_r($labels);die;


        $lead_source = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lead-source";
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $lead_source = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.add", ["errors" => $errors]);
        }

        $state_list = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "state-list";
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $state_list = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.add", ["errors" => $errors]);
        }

        //echo "<pre>";print_r($labels);die;
        $sortedUsers = $this->groupAndSortUsers($users);

        return view("leads.add")->with(["labels" => $labels, "lead_status" => $lead_status, 'users' => $users, 'lead_source' => $lead_source, 'domain_list' => $domain_list, 'uuid' => $uuid, 'state_list' => $state_list, 'sortedUsers' => $sortedUsers]);
    }


    /**
     * @param Request $request
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View
     * Returns edit lead page
     */
    public function editShow(Request $request, $intLeadId)
    {

        $uuid = Str::uuid();

        $inherit_list = new InheritApiController;
        $users = $inherit_list->getExtensionList();
        $group = [];
        $url = env('API_URL') . 'extension-group';
        $response = Helper::GetApi($url);
        if ($response->success) {
            $group = $response->data;
        }

        $map = [];
        $url = env('API_URL') . "extension-group-map";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $map = $response->data;
                //echo"<pre>";print_r($map);die;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("extension.extension-group", compact("errors", $errors));
        }

        $lead_status = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "leadStatus";
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $lead_status = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }


        $labels = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-labels";
        try {
            $response = Helper::GetApi($url);
            // echo "<pre>";print_r($response);die;
            if ($response->success) {
                $labels = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        //echo "<pre>";print_r($labels);die;


        $lead_source = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lead-source";
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $lead_source = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.add", ["errors" => $errors]);
        }

        //Lead
        $arrLead = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lead/" . $intLeadId;
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;

            if ($response->success) {
                $arrLead = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        $state_list = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "state-list";
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $state_list = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.add", ["errors" => $errors]);
        }


        //users
        $users = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "users";
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $users = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("users.list", ["errors" => $errors]);
        }
        $sortedUsers = $this->groupAndSortUsers($users);

        //echo "<pre>";print_r($arrLead);die;

        return view("leads.edit")->with(["labels" => $labels, "lead_status" => $lead_status, 'users' => $users, 'lead' => (array) $arrLead, 'lead_source' => $lead_source, 'state_list' => $state_list, 'sortedUsers' => $sortedUsers, 'map' => $map, 'group' => $group]);



        return view("leads.edit")->with(["labels" => $labels, "lead_status" => $lead_status, 'users' => $users, 'lead_source' => $lead_source, 'uuid' => $uuid, 'sortedUsers' => $sortedUsers, 'map' => $map, 'group' => $group]);



        //Lead status
        $lead_status = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lead-status";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $lead_status = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        //echo "<pre>";print_r($lead_status);die;

        //Labels
        $labels = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "labels";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $labels = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        //Lead
        $arrLead = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lead/" . $intLeadId;
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $arrLead = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        $lead_source = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lead-source";
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $lead_source = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.add", ["errors" => $errors]);
        }




        return view("leads.edit")->with(["labels" => $labels, "lead_status" => $lead_status, 'users' => $users, 'lead' => (array) $arrLead, 'lead_source' => $lead_source, 'sortedUsers' => $sortedUsers]);
    }
    //copy lead
    public function copy(Request $request, $id)
    {
        //dd($id);
        $errors = new MessageBag();

        try {
            // Fetch the document data by lead ID
            $documentUrl = env('API_URL') . "documents/lead/$id";
            $documentResponse = Helper::RequestApi($documentUrl, "GET", [], "json");
            //echo "<pre>";print_r($documentResponse);die;

            if ($documentResponse->success) {
                $documentData = (array) $documentResponse->data;

                // Fetch the lead data by ID
                $leadUrl = env('API_URL') . "/lead/$id";
                $leadResponse = Helper::RequestApi($leadUrl, "GET", [], "json");

                if ($leadResponse->success) {
                    $leadData = (array) $leadResponse->data;

                    // Remove the ID from the lead data so a new lead is created
                    unset($leadData['id']);

                    // Include the signature image if it exists
                    if (isset($leadData['signature_image'])) {
                        $leadData['signature_image'] = $leadResponse->data->signature_image;
                    }

                    // Optionally, you can add document data to the lead data if necessary
                    $leadData['documents'] = $documentData;
                    $leadData['copy_lead_id'] = $id;

                    // Create the new lead by sending a request to the API
                    $createLeadUrl = env('API_URL') . "lead/copy";
                    $addResponse = Helper::RequestApi($createLeadUrl, "PUT", $leadData, "json");

                    if ($addResponse->success) {
                        // Optionally, add a notification about the copied lead
                        $leadId = $addResponse->data->id;


                        $notifications = array('lead_id' => $leadId, 'message' => 'Copied lead <b>manually</b>.');
                        (new NotificationController)->add($notifications);

                        session()->flash("success", "Lead Copied Successfully");
                        return redirect("/leads");
                    } else {
                        foreach ($addResponse->errors as $key => $messages) {
                            if (is_array($messages)) {
                                foreach ($messages as $index => $message) {
                                    $errors->add("$key.$index", $message);
                                }
                            } else {
                                $errors->add($key, $messages);
                            }
                        }
                        return redirect()->back()->withErrors($errors);
                    }
                } else {
                    foreach ($leadResponse->errors as $key => $messages) {
                        if (is_array($messages)) {
                            foreach ($messages as $index => $message) {
                                $errors->add("$key.$index", $message);
                            }
                        } else {
                            $errors->add($key, $messages);
                        }
                    }
                    return redirect()->back()->withErrors($errors);
                }
            } else {
                foreach ($documentResponse->errors as $key => $messages) {
                    if (is_array($messages)) {
                        foreach ($messages as $index => $message) {
                            $errors->add("$key.$index", $message);
                        }
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return redirect()->back()->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withErrors($errors);
        }
    }



    public function add(Request $request)
    {


        $errors = new MessageBag();

        try {

            // echo "<pre>";print_r($this->getBuildBody($request));die;
            //echo "a";die;
            $url = env('API_URL') . "/lead/add";
            $response = Helper::RequestApi($url, "PUT", $this->getBuildBody($request), "json");

            //  echo "<pre>";print_r($response);die;

            if ($response->success) {

                //notes and updates
                $leadId = $response->data->id;
                $notifications = array('lead_id' => $leadId, 'message' => 'created lead <b">manually</b>.');
                $result = (new NotificationController)->add($notifications);


                session()->flash("success", "Lead Added");
                return redirect("/leads");
            } else {
                foreach ($response->errors as $key => $messages) {
                    if (is_array($messages)) {
                        foreach ($messages as $index => $message)
                            $errors->add("$key.$index", $message);
                    } else {
                        //$errors->add($key, $messages);
                    }
                }
                return redirect()->back()->withInput()->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput()->withErrors($errors);
        }
    }


    public function import(Request $request)
    {
        $file = $request->file('list_file');
        $list_title = $request->input('list_title');
        $extension = $file->getClientOriginalExtension();
        $filename = Session::get('id') . time() . '.' . $extension;
        $rootPath = env("FILE_UPLOAD_PATH", "/var/www/html/api/upload/");
        $file->move($rootPath, $filename);
        $body = array(
            'file' => $filename,
            'title' => $list_title
        );

        try {
            $url = env('API_URL') . 'lead/import';
            $response = Helper::PostApi($url, $body);

            //echo "<pre>";print_r($response);die;

            if ($response->success) {
                $listId = $response->list_id;
                return redirect("/list/$listId/edit");
            } else {
                foreach ($response->errors as $key => $messages) {
                    if (is_array($messages)) {
                        foreach ($messages as $index => $message)
                            $errors->add("$key.$index", $message);
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return redirect()->back()->withInput()->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput()->withErrors($errors);
        }
    }

    public function update(Request $request, $intLabelId)
    {
        //echo "S";die;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "/lead/$intLabelId/edit";

            //echo "<pre>";print_r($this->getBuildBody($request));die;

            $response = Helper::PostApi($url, array_filter($this->getBuildBody($request)));
            //echo "<pre>";print_r($response);die;
            if (!$response->success) {
                foreach ($response->errors as $key => $message) {
                    if (is_array($message)) {
                        foreach ($message as $index => $strInsideMessage)
                            $errors->add($index, $strInsideMessage);
                    } else {
                        $errors->add($key, $message);
                    }
                }
                return redirect()->back()->withInput($request->input())->withErrors($errors);
            } else {
                /* echo $response->data->lead_status;
                echo $response->data->old_lead_status;die;*/

                $leadId = $response->data->id;
                if ($response->data->lead_status != $response->data->old_lead_status)
                    $notifications = array('lead_id' => $leadId, 'message' => 'updated lead status from <b>' . ucwords(str_replace('_', ' ', $response->data->old_lead_status)) . '</b> to <b>' . ucwords(str_replace('_', ' ', $response->data->lead_status)) . '</b>.');
                else
                    $notifications = array('lead_id' => $leadId, 'message' => 'updated <b>lead</b> information.');
                $result = (new NotificationController)->add($notifications);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput($request->input())->withErrors($errors);
        }
        session()->flash("success", "Lead updated");
        return redirect()->back();
    }

    public function delete(Request $request, $id)
    {

        $url = env('API_URL') . "/lead/$id/delete";
        $response = Helper::RequestApi($url, "GET");

        if ($response) {
            session()->flash("success", "Lead Deleted Successfully");
        } else {
            session()->flash("success", "Lead Not Deleted");
        }
    }

    public function createMerchant(Request $request)
    {

        $url = env('API_URL') . "/merchant-add";
        $response = Helper::PostApi($url, [
            "email" => $request->email,
            "client_id" => $request->client_id,
            "lead_id" => $request->lead_id
        ]);

        return response()->json($response);
    }

    public function getMerchants()
    {
        $url = env('API_URL') . "/merchants";
        $response = Helper::PostApi($url, [
            "client_id" => Session::get('parentId')
        ]);

        if ($response->success) {
            return $response->data;
        }

        return [];
    }

    private function getBuildBody(Request $request)
    {
        //get labels
        $labels = $body = [];
        $url = env('API_URL') . "crm-labels";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $labels = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        //  echo "<pre>";print_r($labels);die;

        foreach ($labels as $key => $label) {
            if ($label->data_type == 'phone_number') {
                $number = str_replace(array('(', ')', '_', '-', ' '), '', $request->get($label->column_name));
                $body[$label->column_name] = $number;
            } elseif ($label->data_type == 'date') {
                $dateInput = $request->get($label->column_name);
                if ($dateInput) {
                    try {
                        // Convert the date to Y-m-d format
                        $formattedDate = Carbon::createFromFormat('m/d/Y', $dateInput)->format('Y-m-d');
                        // Debugging the formatted date
                        \Log::info("Formatted Date: " . $formattedDate);
                        $body[$label->column_name] = $formattedDate;
                    } catch (\Exception $e) {
                        // Handle the exception if date format is not correct
                        \Log::error("Date Parsing Error: " . $e->getMessage());
                        $body[$label->column_name] = null; // or handle it as you see fit
                    }
                } else {
                    $body[$label->column_name] = null;
                }
            } else {
                $body[$label->column_name] = $request->get($label->column_name);
            }
        }

        $body['lead_status'] = $request->get('lead_status');
        $body['assigned_to'] = $request->get('assigned_to');
        $body['lead_type'] = $request->get('lead_type');
        $body['lead_source_id'] = $request->get('lead_source_id');
        $body['group_id'] = $request->get('group_id');

        //echo "<pre>";print_r($body);die;

        return $body;
    }

    public function view(Request $request)
    {
    $path = resource_path('data/full-country-codes.json');
        $countries = json_decode(file_get_contents($path), true);
        // Get all session variables
        $inherit_list = new InheritApiController;
        $headerUserDetails = $inherit_list->headerUserDetails();
        // dd($headerUserDetails);

        $timezone = $headerUserDetails->data->timezone;
        //dd($timezone);

        // $allSessionData = Session::all();
        // dd($allSessionData);
        $name = Session::get("display_name");
        //    dd($name);

        //dd($previous_id);
        $user_id = Session::get('id');
        //dd($user_id);
        $intLeadId =  $request->query('id');


        $document_type = null;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "documents/$intLeadId";
            $response = Helper::GetApi($url, [], true);

            if ($response["success"]) {
                $document_type = $response["data"];
                //echo "<pre>";print_r($response);die;

            } else {
                foreach ($response->errors as $key => $messages) {
                    if (is_array($messages)) {
                        foreach ($messages as $index => $message)
                            $errors->add("$key.$index", $message);
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return view("documents.list")->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("documents.lead-wise-documents")->withErrors($errors);
        }


        $lenders = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lenders";
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $lenders = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("lenders.list", ["errors" => $errors]);
        }

        $SendlendersList = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "send-lead-to-lenders/$intLeadId";


        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $SendlendersList = $response->data;
                // $lender_id = $SendlendersList[0]->id;
                //echo "<pre>";print_r($SendlendersList);die;
                //echo "<pre>";print_r($SendlendersList->crm_send_lead_to_lender[0]->lead_status_id);die;

            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("lenders.list", ["errors" => $errors]);
        }
        $lender_status = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lender-status";
        try {
            $response = Helper::GetApi($url);
            // echo "<pre>";print_r($response);die;
            if ($response->success) {
                $lender_status = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("lenders.list", ["errors" => $errors]);
        }

        $errors = new MessageBag();

        //Labels
        $labels = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-labels";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $labels = $response->data;
                //echo "<pre>";print_r($labels);die;

            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        //Lead
        $arrLead = [];
        $is_copied = '';
        $previous_id = '';
        $errors = new MessageBag();
        $url = env('API_URL') . "lead/" . $intLeadId;
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;


            if ($response->success) {
                $arrLead = $response->data;
                $is_copied = $arrLead->is_copied;
                $previous_id = $arrLead->copy_lead_id;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }
        //prevuous Lead
        $preLead = [];
        $preLeadStatus = '';
        $preLeadUpdated = '';
        $errors = new MessageBag();
        $url = env('API_URL') . "lead/" . $previous_id;
        try {
            $response = Helper::GetApi($url);


            if ($response->success) {
                $preLead = $response->data;
                $preLeadStatus = $preLead->lead_status;
                $preLeadUpdated = $preLead->updated_at;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        $lead_status = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "leadStatus";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $lead_status = (array) $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        $arrLeadStatusRekeyed = Helper::rekeyArray($lead_status, 'lead_title_url');

        /*$arrUsersRekeyed = Helper::rekeyArray($users, 'id');
        echo "<pre>";print_r($arrUsersRekeyed);die;*/


        //"lead_status" => $arrLeadStatusRekeyed, 'users' => $arrUsersRekeyed

        /*$inherit_list = new InheritApiController;
        $users = $inherit_list->getExtensionList();*/

        $users = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "users";
        try {
            $response = Helper::GetApi($url);

            //echo "<pre>";print_r($response);die;

            if ($response->success) {
                $users = (array) $response->data;

                // echo "<pre>";print_r($users);die;

            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.list", ["errors" => $errors]);
        }
        $lead_source = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lead-source";
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $lead_source = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.add", ["errors" => $errors]);
        }
        $arrUsersRekeyed = Helper::rekeyArray($users, 'id');

        //echo "<pre>";print_r($arrUsersRekeyed);die;

        $map = [];
        $url = env('API_URL') . "extension-group-map";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $map = $response->data;
                //echo"<pre>";print_r($map);die;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("extension.extension-group", compact("errors", $errors));
        }

        /* close list */
        $title = "Group List | " . env('APP_NAME');
        $url = env('API_URL') . 'extension-group';
        $response = Helper::GetApi($url);
        if ($response->success) {
            $group = $response->data;
        }

        $crm_system = [];
        $company_domain = '';

        $errors = new MessageBag();
        $url = env('API_URL') . "crm-system-setting";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $crm_system = $response->data;
                if (empty($crm_system)) {
                    $errors->add('crm_system', 'No CRM system data found.');
                } else {
                    $company_domain = $crm_system[0]->company_domain;
                    // echo "<pre>"; print_r($company_domain); die;
                }
                //echo "<pre>";print_r($company_domain);die;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.add", ["errors" => $errors]);
        }

        //notes and updates
        $notification_notes = (new NotificationController)->notificationByLeadId($intLeadId, '1'); //notes 1

        $notification_updates = (new NotificationController)->notificationByLeadId($intLeadId, '0'); //updates 0

        $notification_submission = (new NotificationController)->notificationByLeadId($intLeadId, '2'); //submission 2
        $notification_api_logs = (new NotificationController)->notificationByLeadId($intLeadId,'3'); //submission 2
        $lender_notes = $this->notesByLender($intLeadId); //submission 2

        $sortedUsers = $this->groupAndSortUsers($users);
        //notes and updates
        $notification_notes_copy = (new NotificationController)->notificationByLeadId($previous_id, '1'); //notes 1

        $notification_updates_copy = (new NotificationController)->notificationByLeadId($previous_id, '0'); //updates 0

        $notification_submission_copy = (new NotificationController)->notificationByLeadId($previous_id, '2'); //submission 2

        //echo "<pre>";print_r($notification_updates);die;
        return view("leads.view")->with([
            'users' => $arrUsersRekeyed,
            'lead_id' => $intLeadId,
            "labels" => $labels,
            'lead' => (array) $arrLead,
            'notification' => (array) $notification_notes,
            'updates' => $notification_updates,
            'submission' => $notification_submission,
            'notification_copy' => (array) $notification_notes_copy,
            'updates_copy' => $notification_updates_copy,
            'submission_copy' => $notification_submission_copy,
            "lead_status" => $arrLeadStatusRekeyed,
            'lenders' => $lenders,
            'document_type' => $document_type,
            'sortedUsers' => $sortedUsers,
            'SendlendersList' => $SendlendersList,
            'lender_status' => $lender_status,
            'lender_notes' => $lender_notes,
            'user_id' => $user_id,
            'name' => $name,
            'lead_source' => $lead_source,
            'timezone' => $timezone,  // Existing data
            'is_copied' => $is_copied,
            'previous_id' => $previous_id,
            'map' => $map,
            'group' => $group,
            'company_domain' => $company_domain,
            'preLeadStatus' => $preLeadStatus,
            'preLeadUpdated' => $preLeadUpdated,
            'submission_logs' => $notification_api_logs,
            'countries'=>$countries
        ]);
    }

    public function docsInView(Request $request, $intLeadId)
    {
        $errors = new MessageBag();

        //Lead
        $arrLead = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lead/" . $intLeadId;
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $arrLead = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        return view("leads.docs")->with(['lead_id' => $intLeadId, 'lead' => (array) $arrLead]);
    }

    // Leads Come from another domain

    public function addLead(Request $request)
    {
        if (!empty($request->has('mobile'))) {
            $request['phone_number'] = $request->mobile;
        }
        //echo "<pre>";print_r($this->getBuildBodyLead($request));die;
        $get_url = $_SERVER['REQUEST_URI'];
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "/lead/addLead";
            $response = Helper::RequestApi($url, "PUT", $this->getBuildBodyLead($request), "json");
            //echo "<pre>";print_r($response);die;

            if ($response->success) {
                //lead source log
                $leadId = $response->data->id;
                $lead_source_log = array('lead_id' => $leadId, 'lead_source_url' => $get_url);

                $result = (new NotificationController)->addLogForLeadSource($lead_source_log);

                //notes and updates
                $notifications = array('lead_id' => $leadId, 'message' => 'created lead on <b>Call</b>.');
                $result = (new NotificationController)->add($notifications);
                session()->flash("success", "Lead Added");
                return redirect("/leads/view?id=" . $leadId);
            } else {
                $leadId = $response->errors['id'];

                session()->flash("error", "Lead already Added");
                return redirect("/leads/view?id=" . $leadId);
            }
            /*else
            {
                foreach ($response->errors as $key => $messages)
                {
                    if (is_array($messages))
                    {
                        foreach ($messages as $index => $message)
                            $errors->add("$key.$index", $message);
                    }
                    else
                    {
                        $errors->add($key, $messages);
                    }
                }
                //return redirect()->back()->withInput()->withErrors($errors);

                return redirect("/404");
            }*/
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput()->withErrors($errors);
        }
    }


    private function getBuildBodyLead(Request $request)
    {

        //dd($request);
        //get labels

        foreach ($request->except('_token') as $key => $part) {
            $keys[] = $key;
        }

        $labels = $body = [];
        $url = env('API_URL') . "crm-labels";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $labels = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        /* foreach($labels as $key => $label){
            $body[$label->column_name] = $request->get($label->label_title_url);
        }

        $body['lead_status'] = 'new_lead'; //$request->get('lead_status');
        $body['assigned_to'] = Session::get("userId");//$request->get('assigned_to');
        $body['lead_type'] = $request->get('lead_type');
        $body['lead_source_id'] = $request->get('lead_source_id');
        return $body;*/

        // echo "<pre>";print_r($labels);die;

        foreach ($labels as $key => $label) {

            if ($label->column_name == 'phone_number') {

                // echo $request->get($label->data_type);;die;

                // echo $label->data_type;die;

                // echo $request->get($label->column_name);die;
                //$number = str_replace(array('(',')', '_', '-',' '), array(''), $request->get($label->column_name));

                // $number = str_replace(array('(',')', '_', '-',' '), array(''), $request->get($label->column_name));


                $body[$label->column_name] = $request->get($label->column_name);
            }
            /*else
                if($label->column_name == 'assigned_to')
                {
                    $body[$label->column_name] = $request->get($label);

                }*/

            /*else
                if($label->data_type == 'date')
                {
                    if (in_array($label->label_title_url, $keys))
                    {
                        $body[$label->column_name] =  \Carbon\Carbon::parse($request->get($label->label_title_url))->format('Y-m-d');
                    }
                }*/ else if ($label->data_type == 'date') {
                if (in_array($label->label_title_url, $keys)) {
                    $dateInput = $request->get($label->label_title_url);
                    try {
                        $body[$label->column_name] = \Carbon\Carbon::createFromFormat('m-d-Y', $dateInput)->format('Y-m-d');
                    } catch (\Exception $e) {
                        // fallback or log error
                        $body[$label->column_name] = null; // or keep original input
                    }
                }
            } else {
                if (in_array($label->label_title_url, $keys)) {
                    $body[$label->column_name] = $request->get($label->label_title_url);
                } else {
                    $body[$label->column_name] = $request->get($label->column_name);
                }
            }
        }

        $body['lead_status'] = 'new_lead'; //$request->get('lead_status');
        $body['assigned_to'] = $request->get('user');
        $body['lead_type'] = $request->get('lead_type');
        $body['lead_source_id'] = $request->get('lead_source_id');

        //echo "<pre>";print_r($body);die;
        return $body;
    }


    public function errorPage(Request $request)
    {
        return view("errorpage.404");
    }

    public function createApplication(Request $request, $intLeadId)
    {


        //Lead
        $arrLead = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lead/" . $intLeadId;
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $arrLead = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        foreach (Session::get('permissions') as $list) {
            $arrLead->companyName =  $list->companyName;
            $arrLead->companyLogo =  $list->companyLogo;

            $arrLead->address_1 =  $list->address_1;
            $arrLead->domain =  $list->domain;
        }


        $user_id = $arrLead->assigned_to;


        $lead_phone = $arrLead->phone;

        $phone = preg_replace("/[^0-9]*/", '', $lead_phone);
        if (strlen($phone) != 10) return (false);
        $sArea = substr($phone, 0, 3);
        $sPrefix = substr($phone, 3, 3);
        $sNumber = substr($phone, 6, 4);
        $phone = "(" . $sArea . ") " . $sPrefix . "-" . $sNumber;

        $arrLead->phone =  $phone;


        $user = null;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "user/$user_id";
            $response = Helper::GetApi($url, [], true);
            //echo "<pre>";print_r($response);die;
            if ($response["success"]) {
                $user = $response["data"];
            } else {
                foreach ($response->errors as $key => $messages) {
                    if (is_array($messages)) {
                        foreach ($messages as $index => $message)
                            $errors->add("$key.$index", $message);
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return view("users.edit")->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("users.edit")->withErrors($errors);
        }

        $arrLead->assign_to_first_name = $user['first_name'];
        $arrLead->assign_to_last_name = $user['last_name'];
        $arrLead->assign_to_email = $user['email'];


        $phone = $user['mobile'];


        $phone = preg_replace("/[^0-9]*/", '', $phone);
        if (strlen($phone) != 10) return (false);
        $sArea = substr($phone, 0, 3);
        $sPrefix = substr($phone, 3, 3);
        $sNumber = substr($phone, 6, 4);
        $phone = "(" . $sArea . ") " . $sPrefix . "-" . $sNumber;


        $arrLead->assign_to_mobile = $phone;


        $lead_data = (array)$arrLead;



        //echo "<pre>";print_r($lead_data);die;
        $file_name = 'signed_application_' . $lead_data['id'] . '_' . $lead_data['first_name'] . '_' . $lead_data['last_name'] . '.pdf';
        if (\File::exists(public_path('uploads/' . $file_name))) {
            \File::delete(public_path('uploads/' . $file_name));
        }
        $pdf = PDF::loadView('myPDF', $lead_data)->save('uploads/' . $file_name);
        return redirect('/uploads/' . $file_name);
    }


    public function previewApplication(Request $request, $intLeadId)
    {


        //Lead
        $arrLead = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lead/" . $intLeadId;
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $arrLead = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        foreach (Session::get('permissions') as $list) {
            $arrLead->companyName =  $list->companyName;
            $arrLead->companyLogo =  $list->companyLogo;

            $arrLead->address_1 =  $list->address_1;
            $arrLead->domain =  $list->domain;
        }


        $user_id = $arrLead->assigned_to;


        $lead_phone = $arrLead->phone;

        $phone = preg_replace("/[^0-9]*/", '', $lead_phone);
        if (strlen($phone) != 10) return (false);
        $sArea = substr($phone, 0, 3);
        $sPrefix = substr($phone, 3, 3);
        $sNumber = substr($phone, 6, 4);
        $phone = "(" . $sArea . ") " . $sPrefix . "-" . $sNumber;

        $arrLead->phone =  $phone;


        $user = null;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "user/$user_id";
            $response = Helper::GetApi($url, [], true);
            //echo "<pre>";print_r($response);die;

            if ($response["success"]) {
                $user = $response["data"];
            } else {
                foreach ($response->errors as $key => $messages) {
                    if (is_array($messages)) {
                        foreach ($messages as $index => $message)
                            $errors->add("$key.$index", $message);
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return view("users.edit")->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("users.edit")->withErrors($errors);
        }

        $arrLead->assign_to_first_name = $user['first_name'];
        $arrLead->assign_to_last_name = $user['last_name'];
        $arrLead->assign_to_email = $user['email'];


        $phone = $user['mobile'];


        $phone = preg_replace("/[^0-9]*/", '', $phone);
        if (strlen($phone) != 10) return (false);
        $sArea = substr($phone, 0, 3);
        $sPrefix = substr($phone, 3, 3);
        $sNumber = substr($phone, 6, 4);
        $phone = "(" . $sArea . ") " . $sPrefix . "-" . $sNumber;


        $arrLead->assign_to_mobile = $phone;


        $lead_data = (array)$arrLead;



        //echo "<pre>";print_r($lead_data);die;

        return view('myPDF', $lead_data);
        //  $file_name = 'signed_application_'.$lead_data['id'].'_'.$lead_data['first_name'].'_'.$lead_data['last_name'].'.pdf';
        /*if(\File::exists(public_path('uploads/'.$file_name)))
                {
                    \File::delete(public_path('uploads/'.$file_name));
                }
        //$pdf = PDF::loadView('myPDF', $lead_data)->save('uploads/'.$file_name);
        return redirect('/uploads/'.$file_name);
*/
    }


    public function updateByLeadStatus(Request $request)
    {

        //dd(array_filter($this->getBuildBody($request)));

        $intLabelId = $request->lead_id;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "/lead-status/$intLabelId/edit";
            $response = Helper::PostApi($url, array_filter($this->getBuildBody($request)));
            if (!$response->success) {
                foreach ($response->errors as $key => $message) {
                    if (is_array($message)) {
                        foreach ($message as $index => $strInsideMessage)
                            $errors->add($index, $strInsideMessage);
                    } else {
                        $errors->add($key, $message);
                    }
                }
                return redirect()->back()->withInput($request->input())->withErrors($errors);
            } else {
                /* echo $response->data->lead_status;
                echo $response->data->old_lead_status;die;*/
                $leadId = $response->data->id;
                $leadCompanyName = $response->data->company_name;

                if ($response->data->lead_type != $response->data->old_lead_type) {

                    if (empty($response->data->old_lead_type)) {
                        $response->data->old_lead_type = 'NEW';
                    }

                    if (empty($response->data->old_lead_type)) {
                        $response->data->lead_type = 'NEW';
                    }
                    $notifications = array('lead_id' => $leadId, 'message' => 'has updated the lead type from <b>' . strtoupper(str_replace('_', ' ', $response->data->old_lead_type)) . '</b> to <b>' . strtoupper(str_replace('_', ' ', $response->data->lead_type)) . '</b> for <b>' . strtoupper($leadCompanyName) . '</b>.');
                } else
                if ($response->data->lead_status != $response->data->old_lead_status)
                    $notifications = array(
                        'lead_id' => $leadId,
                        'message' => 'has updated the lead status from <b>' . strtoupper(str_replace('_', ' ', $response->data->old_lead_status)) . '</b> to <b>' . strtoupper(str_replace('_', ' ', $response->data->lead_status)) . '</b> for <b>' . strtoupper($leadCompanyName) . '</b>.'
                    );

                else
                if ($response->data->assigned_to != $response->data->old_assigned_to)
                    $notifications = array(
                        'lead_id' => $leadId,
                        'message' => 'has assigned the lead from <b>' . strtoupper(str_replace('_', ' ', $response->data->old_assigned_to)) . '</b> to <b>' . strtoupper(str_replace('_', ' ', $response->data->assigned_to)) . '</b> for <b>' . strtoupper($leadCompanyName) . '</b>.'
                    );
                else
                    $notifications = array(
                        'lead_id' => $leadId,
                        'message' => 'has updated the <b>lead</b> information for <b>' . strtoupper($leadCompanyName) . '</b>.'
                    );
                $result = (new NotificationController)->add($notifications);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput($request->input())->withErrors($errors);
        }
        session()->flash("success", "Lead updated");
        return redirect()->back();
    }



    //signed application

    public function signedApplication(Request $request, $intLeadId)
    {


        $signed_application = null;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "signed-application/$intLeadId";
            $response = Helper::GetApi($url, [], true);
            //echo "<pre>";print_r($response);
            //die();
            if ($response["success"]) {
                $email_template = $response['data']['template_html'];
            } else {
                foreach ($response["errors"] as $key => $message) {
                    $errors->add($key, $message);
                }
                //return view("email-template.edit")->withErrors($errors);
            }
        } catch (RequestException $ex) {
            return $errors->add("error", $ex->getMessage());
            //view("email-template.edit")->withErrors($errors);
        }

        // echo "<pre>";print_r($email_template);die;


        //Lead
        $arrLead = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lead/" . $intLeadId;
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $arrLead = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        foreach (Session::get('permissions') as $list) {
            $arrLead->companyName =  $list->companyName;
            $arrLead->companyLogo =  $list->companyLogo;

            $arrLead->address_1 =  $list->address_1;
            $arrLead->domain =  $list->domain;
        }










        $lead_data = (array)$arrLead;




        //echo "<pre>";print_r($email_template);die;
        $file_name = 'signed_application_' . $lead_data['id'] . '_' . $lead_data['first_name'] . '_' . $lead_data['last_name'] . '.pdf';
        if (\File::exists(public_path('uploads/' . $file_name))) {
            \File::delete(public_path('uploads/' . $file_name));
        }
        //$pdf = PDF::loadView('myPDF', $lead_data)->save('uploads/'.$file_name);

        $email_template .= '<style>table {width: 100%;border-collapse: collapse !important;}</style>';

        $pdf = PDF::loadHTML($email_template);

        // download pdf file
        return $pdf->download('pdfview.pdf');


        return redirect('/uploads/' . $file_name);
    }
    private function groupAndSortUsers(array $users): Collection
    {
        $groupedUsers = collect($users)->groupBy(function ($user) {
            return strtoupper(substr($user->first_name, 0, 1));
        });

        $groupedUsers = $groupedUsers->map(function ($group) {
            return $group->sortBy('first_name');
        });

        $groupedUsers = $groupedUsers->sortKeys();

        return $groupedUsers->flatMap(function ($group) {
            return $group->values();
        });
    }
    public function submitLenderStatus(Request $request)
    {
        log::info('reached', [$request->all()]);
        $lender_id = $request->lender_id;
        $errors = new MessageBag();
        $url = env('API_URL') . "lender-status/$lender_id/edit";
        $body = [
            'id' => Session::get('id'),
            'lender_status' => $request->input('lender_status'),
            'lead_id' => $request->input('lead_id'),
        ];
        try {
            $response = Helper::PostApi($url, $body);


            // Return success response
            if ($response->success = "true") {
                return response()->json(['message' => 'Status Changed Successfully'], 200);
            } else {
                return response()->json(['message' => 'Failed to change status'], 500);
            }
        } catch (\Exception $e) {
            // Return error response
            return response()->json(['message' => 'Failed to change status', 'error' => $e->getMessage()], 500);
        }
    }
    public function addNotes(Request $request)
    {

        Log::info('response notes', [$request->all()]);
        $url = env('API_URL') . "lender/notes/add";
        $response = Helper::RequestApi($url, "PUT", $request->all(), "json");

        if ($response->success == true) {
            return response()->json(['success' => true]); // Return JSON response for success
        } else {
            return response()->json(['success' => false]); // Return JSON response for failure
        }
    }
    public function notesByLender($lead_id)
    {

        $lender_notes = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "showlenders/$lead_id";
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                return $lender_notes = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return $errors;
        }
    }
    public function editNotes(Request $request)
    {
        $url = env('API_URL') . "lender/notes/edit";
        $response = Helper::RequestApi($url, "POST", $request->all(), "json");
        Log::info('response', ['response' => $response]);

        if ($response->success == true) {
            return response()->json(['success' => true]); // Return JSON response for success
        } else {
            return response()->json(['success' => false]); // Return JSON response for failure
        }
    }
    public function addOpener(Request $request)
    {
        Log::info('response', ['request' => $request->all()]);

        $url = env('API_URL') . "leads/add/opener";
        $response = Helper::RequestApi($url, "POST", $request->all(), "json");

        if ($response->success == true) {
            return response()->json(['success' => true]); // Return JSON response for success
        } else {
            return response()->json(['success' => false]); // Return JSON response for failure
        }
    }
    public function addCloser(Request $request)
    {
        Log::info('response', ['request' => $request->all()]);

        $url = env('API_URL') . "leads/add/closer";
        $response = Helper::RequestApi($url, "POST", $request->all(), "json");

        if ($response->success == true) {
            return response()->json(['success' => true]); // Return JSON response for success
        } else {
            return response()->json(['success' => false]); // Return JSON response for failure
        }
    }
    public function addTask(Request $request)
    {

        Log::info('task', [$request->all()]);
        $url = env('API_URL') . "leadTask/add";
        $response = Helper::RequestApi($url, "POST", $request->all());
        Log::info('response notes', ["response" => $response]);

        if ($response->success == true) {
            // $notifications = array('lead_id' => $request->input('lead_id'), 'message' => 'added reminder for lead.');
            // (new NotificationController)->add($notifications);
            return response()->json(['success' => true]); // Return JSON response for success
        } else {
            return response()->json(['success' => false]); // Return JSON response for failure
        }
    }
    public function Reminder(Request $request, $id)
    {
        $users = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "users";
        try {
            $response = Helper::GetApi($url);

            //echo "<pre>";print_r($response);die;

            if ($response->success) {
                $users = (array) $response->data;

                // echo "<pre>";print_r($users);die;

            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.list", ["errors" => $errors]);
        }
        $tasks = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-scheduled-task/$id";

        try {
            $response = Helper::GetApi($url);
            if ($response) {
                $tasks = $response;
                //echo "<pre>";print_r($task);die;

            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        return view('leads.task', compact('tasks', 'id', 'users'));
    }
    public function deleteTask(Request $request, $lead_id, $id)
    {
        $url = env('API_URL') . "crm-scheduled-task/$lead_id/$id/delete";
        $response = Helper::RequestApi($url, "GET");
        //echo "<pre>";print_r($response);die;
        Log::info('reached', ['response' => $response]);
        if ($response) {
            session()->flash("success", "Reminder Deleted Successfully");
        } else {
            session()->flash("success", "Reminder Not Deleted");
        }
    }

    public function sendDataOnWebhook(Request $request)
    {

        $id = $request->lead_id;

        $url = env('API_URL') . "send-data-on-webhook/" . $id;
        $response = Helper::RequestApi($url, "GET");

        //echo "<pre>";print_r($response);die;
        if ($response->success) {
            session()->flash("success", $response->message);
            return redirect("/leads/view?id=" . $id);
        } else {
            session()->flash("message", $response->message);
            return redirect("/leads/view?id=" . $id);
        }
    }

    public function indexNew(Request $request)
    {
        $inherit_list = new InheritApiController;
        $extension_list = $inherit_list->getExtensionList();
        $userdetails = InheritApiController::headerUserDetails();
        $timezone = $userdetails->data->timezone;

        $errors = new MessageBag();
        /* list list */
        $map = [];
        $url = env('API_URL') . "extension-group-map";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $map = $response->data;
                //echo"<pre>";print_r($map);die;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("extension.extension-group", compact("errors", $errors));
        }

        /* close list */
        $title = "Group List | " . env('APP_NAME');
        $url = env('API_URL') . 'extension-group';
        $response = Helper::GetApi($url);
        if ($response->success) {
            $group = $response->data;
        }
        $crm_system = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-system-setting";
        try {
            $response = Helper::GetApi($url);
            // echo "<pre>";print_r($response);die;

            if ($response->success) {
                $crm_system = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }
        $lead_status = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "leadStatus";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $lead_status = (array) $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.list", ["errors" => $errors]);
        }

        // return view("leads.list", ['lead_status' => $lead_status]);

        $view_on_leads = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-view-on-leads";
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $view_on_leads = (array) $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.list", ["errors" => $errors]);
        }



        $users = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "users";
        try {
            $response = Helper::GetApi($url);


            if ($response->success) {
                $users = (array) $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.list", ["errors" => $errors]);
        }


        $arrLeadStatusRekeyed = Helper::rekeyArray($lead_status, 'lead_title_url');
        $arrUsersRekeyed = Helper::rekeyArray($users, 'id');





        $body = array(
            'level' => Session::get('userLevel'),
            'start_date' => $request->start_date,
            'end_date' =>  $request->end_date,
            // 'lower_limit' => $lower_limit,
            // 'upper_limit' => $upper_limit,
            'id' => Session::get('id'),
            'lead_status' => $request->lead_status,
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'company_name' => $request->company_name,
            'assigned_to' => $request->assigned_to,
            'lead_type' => $request->lead_type,
            'phone_number' => preg_replace('/\D/', '', $request->phone_number),
            'crm_id' => $request->crm_id,
            'dba' => $request->dba,
             'lead_id' => $request->lead_id,

            //  'search' => $searchTerm,

        );



        // Initialize variables
        $group_ids = [];
        $associated_extensions = [];

        // Get the user role and extension from the session
        $userRole = Session::get('role');
        $userExtension = Session::get('extension');

        // Apply the logic if the user role is manager
        if ($userRole === 'manager' && !empty($userExtension)) {

            // Step 1: Find all group_ids for the manager's extension
            foreach ($map as $entry) {
                if ($entry->extension == $userExtension && $entry->is_deleted == 0) {
                    // Ensure no duplicate group_ids are added
                    if (!in_array($entry->group_id, $group_ids)) {
                        $group_ids[] = $entry->group_id;
                    }
                }
            }
            Log::info('Groups reached', ['group_ids' => $group_ids]);

            // Step 2: Collect all extensions associated with the found group_ids
            if (!empty($group_ids)) {
                foreach ($map as $entry) {
                    // Check that the entry is not deleted and belongs to one of the collected group_ids
                    if (in_array($entry->group_id, $group_ids) && $entry->is_deleted == 0) {
                        $associated_extensions[] = $entry->user_id;
                        Log::info('Added extension: ' . $entry->user_id);
                    }
                }

                // Debugging: Log the final list of associated extensions
                Log::info('Associated extensions: ' . json_encode($associated_extensions));
            }
        }


        $leads = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lead-new";
        $currentUserId = Session::get('id'); // or whatever method you use to get the current user ID

        try {
            $response = Helper::PostApi($url, $body);
            //echo "<pre>"; print_r($response); die;

            if ($response->success) {
                $leads = $response->data;
                //   if ($userRole === 'manager' && !empty($associated_extensions)) {
                //                     $leads = array_filter($leads, function ($lead) use ($associated_extensions) {
                //                         return in_array($lead->assigned_to, $associated_extensions);
                //                     });
                //                 } else {
                //                     $leads = $leads;
                //                 }

                $record_count = $response->record_count;
            } else {
                // Handle errors
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("leads.list", ["errors" => $errors]);
        }


        $sortedUsers = $this->groupAndSortUsers($users);
        //echo "<pre>";print_r($leads);die;

        if ($request->ajax()) {



            log::info("run ajax");
            $dataTable = DataTables::of($leads)


                ->addColumn('#', function ($lead) {
                    return $lead->id;
                })
                ->addColumn('lead_status', function ($lead) use ($arrLeadStatusRekeyed) {
                    if (isset($arrLeadStatusRekeyed[$lead->lead_status])) {
                        return '<span class="badge" style="background:' . $arrLeadStatusRekeyed[$lead->lead_status]->color_code . '; color:#fff">' .
                            $arrLeadStatusRekeyed[$lead->lead_status]->title .
                            '</span>';
                    }
                    return '';
                })
                ->addColumn('assigned_to_user', function ($lead) use ($arrUsersRekeyed) {
                    if (isset($arrUsersRekeyed[$lead->assigned_to])) {
                        $user = $arrUsersRekeyed[$lead->assigned_to];
                        return ucfirst($user->first_name) . ' ' . ucfirst($user->last_name);
                    }
                    return '';
                })
                ->addColumn('created_by_user', function ($lead) use ($arrUsersRekeyed) {
                    if (isset($arrUsersRekeyed[$lead->created_by])) {
                        $user = $arrUsersRekeyed[$lead->created_by];
                        return ucfirst($user->first_name) . ' ' . ucfirst($user->last_name);
                    }
                    return '';
                })
                ->addColumn('action', function ($lead) {
                    return
                        '<div class="list-icons d-inline-flex">
                    <a style="cursor:pointer;" type="button" href="/leads/' . $lead->id . '/edit" class="list-icons-item me-10"><i class="fa fa-edit"></i></a>
                 <a style="cursor:pointer;"  type="button" href="#" class="list-icons-item me-10 openLeadDelete" data-id="' . $lead->id . '"><i class="fa fa-trash-o"></i></a>
                 <a  style="cursor:pointer;" type="button" href="/leads/view?id=' . $lead->id . '" class="list-icons-item me-10"><i class="fa fa-eye"></i></a>
                 </div>';
                })



                ->rawColumns(['lead_status', 'action']);

            // Get the array response (not JSON yet)
            $response = $dataTable->toArray();
            // Add your dynamic columns info
            $response['lead_view'] = $view_on_leads;

            return response()->json($response);
        }


        // Get selected value from filter
        $show = $request->input('show', 10);
        if ($show == 25 || $show == 50 || $show == 100) {
            $upper_limit = $show;
        }

        return view("leads.leads-new", ["leads" => $leads, "merchants" => $this->getMerchants(), "record_count" => $record_count, "lead_status" => $arrLeadStatusRekeyed, 'users' => $arrUsersRekeyed, 'view_on_leads' => $view_on_leads, 'user' => $users, 'sortedUsers' => $sortedUsers, 'crm_system' => $crm_system, 'map' => $map, 'group' => $group, 'title' => $title, 'extension_list' => $extension_list, 'timezone' => $timezone]);
    }



    // public function indexNew_old(Request $request)
    // {
    //     $inherit_list = new InheritApiController;
    //     $extension_list = $inherit_list->getExtensionList();
    //     $userdetails = InheritApiController::headerUserDetails();
    //     $timezone = $userdetails->data->timezone;

    //     $errors = new MessageBag();
    //     /* list list */
    //     $map = [];
    //     $url = env('API_URL') . "extension-group-map";
    //     try {
    //         $response = Helper::GetApi($url);
    //         if ($response->success) {
    //             $map = $response->data;
    //             //echo"<pre>";print_r($map);die;
    //         } else {
    //             foreach ($response->errors as $key => $message) {
    //                 $errors->add($key, $message);
    //             }
    //         }
    //     } catch (RequestException $ex) {
    //         $errors->add("error", $ex->getMessage());
    //         return view("extension.extension-group", compact("errors", $errors));
    //     }

    //     /* close list */
    //     $title = "Group List | " . env('APP_NAME');
    //     $url = env('API_URL') . 'extension-group';
    //     $response = Helper::GetApi($url);
    //     if ($response->success) {
    //         $group = $response->data;
    //     }
    //     $crm_system = [];
    //     $errors = new MessageBag();
    //     $url = env('API_URL') . "crm-system-setting";
    //     try {
    //         $response = Helper::GetApi($url);
    //         // echo "<pre>";print_r($response);die;

    //         if ($response->success) {
    //             $crm_system = $response->data;
    //         } else {
    //             foreach ($response->errors as $key => $message) {
    //                 $errors->add($key, $message);
    //             }
    //         }
    //     } catch (RequestException $ex) {
    //         $errors->add("error", $ex->getMessage());
    //         return view("labels.list", ["errors" => $errors]);
    //     }
    //     $lead_status = [];
    //     $errors = new MessageBag();
    //     $url = env('API_URL') . "leadStatus";
    //     try {
    //         $response = Helper::GetApi($url);
    //         if ($response->success) {
    //             $lead_status = (array) $response->data;
    //         } else {
    //             foreach ($response->errors as $key => $message) {
    //                 $errors->add($key, $message);
    //             }
    //         }
    //     } catch (RequestException $ex) {
    //         $errors->add("error", $ex->getMessage());
    //         return view("leads.list", ["errors" => $errors]);
    //     }

    //     // return view("leads.list", ['lead_status' => $lead_status]);

    //     $view_on_leads = [];
    //     $errors = new MessageBag();
    //     $url = env('API_URL') . "crm-view-on-leads";
    //     try {
    //         $response = Helper::GetApi($url);
    //         //echo "<pre>";print_r($response);die;
    //         if ($response->success) {
    //             $view_on_leads = (array) $response->data;
    //         } else {
    //             foreach ($response->errors as $key => $message) {
    //                 $errors->add($key, $message);
    //             }
    //         }
    //     } catch (RequestException $ex) {
    //         $errors->add("error", $ex->getMessage());
    //         return view("leads.list", ["errors" => $errors]);
    //     }



    //     $users = [];
    //     $errors = new MessageBag();
    //     $url = env('API_URL') . "users";
    //     try {
    //         $response = Helper::GetApi($url);


    //         if ($response->success) {
    //             $users = (array) $response->data;
    //         } else {
    //             foreach ($response->errors as $key => $message) {
    //                 $errors->add($key, $message);
    //             }
    //         }
    //     } catch (RequestException $ex) {
    //         $errors->add("error", $ex->getMessage());
    //         return view("leads.list", ["errors" => $errors]);
    //     }


    //     $arrLeadStatusRekeyed = Helper::rekeyArray($lead_status, 'lead_title_url');
    //     $arrUsersRekeyed = Helper::rekeyArray($users, 'id');


    //     // $page=0;
    //     // $upper_limit=10000;
    //     // $urlpage = $request->page;
    //     // if (!empty($urlpage) && $urlpage > 1)
    //     // {
    //     //     $urlpage = $urlpage - 1;
    //     //     $lower_limit = $urlpage * 10;
    //     // }
    //     // else
    //     // {
    //     //     $lower_limit = 0;
    //     // }

    //     // if ($request->isMethod('post')) {
    //     //    $lower_limit = 0;
    //     //    $page=1;
    //     // }
    //     // Default upper limit
    //     $upper_limit = 10;

    //     // Get selected value from filter
    //     $show = $request->input('show', 10);
    //     if ($show == 25 || $show == 50 || $show == 100) {
    //         $upper_limit = $show;
    //     }

    //     $urlpage = $request->page;

    //     $page = 0;
    //     $lower_limit = 0;

    //     if (!empty($urlpage) && $urlpage > 1) {
    //         $urlpage = $urlpage - 1;
    //         $lower_limit = $urlpage * $upper_limit;
    //     }

    //     if ($request->isMethod('post')) {
    //         $lower_limit = 0;
    //         $page = 1;
    //     }
    //     $searchTerm = $request->input('search');
    //     if ($request->submit_download == 'excel') {

    //         $upper_limit = '';
    //     }


    //     $body = array(
    //         'level' => Session::get('userLevel'),
    //         'start_date' => $request->start_date,
    //         'end_date' =>  $request->end_date,
    //         'lower_limit' => $lower_limit,
    //         'upper_limit' => $upper_limit,
    //         'id' => Session::get('id'),
    //         'lead_status' => $request->lead_status,
    //         'first_name' => $request->first_name,
    //         'last_name' => $request->last_name,
    //         'email' => $request->email,
    //         'company_name' => $request->company_name,
    //         'assigned_to' => $request->assigned_to,
    //         'lead_type' => $request->lead_type,
    //         'phone_number' => $request->phone_number,
    //         'crm_id' => $request->crm_id,
    //         'dba' => $request->dba,
    //         'search' => $searchTerm,

    //     );



    //     // Initialize variables
    //     $group_ids = [];
    //     $associated_extensions = [];

    //     // Get the user role and extension from the session
    //     $userRole = Session::get('role');
    //     $userExtension = Session::get('extension');

    //     // Apply the logic if the user role is manager
    //     if ($userRole === 'manager' && !empty($userExtension)) {

    //         // Step 1: Find all group_ids for the manager's extension
    //         foreach ($map as $entry) {
    //             if ($entry->extension == $userExtension && $entry->is_deleted == 0) {
    //                 // Ensure no duplicate group_ids are added
    //                 if (!in_array($entry->group_id, $group_ids)) {
    //                     $group_ids[] = $entry->group_id;
    //                 }
    //             }
    //         }
    //         Log::info('Groups reached', ['group_ids' => $group_ids]);

    //         // Step 2: Collect all extensions associated with the found group_ids
    //         if (!empty($group_ids)) {
    //             foreach ($map as $entry) {
    //                 // Check that the entry is not deleted and belongs to one of the collected group_ids
    //                 if (in_array($entry->group_id, $group_ids) && $entry->is_deleted == 0) {
    //                     $associated_extensions[] = $entry->user_id;
    //                     Log::info('Added extension: ' . $entry->user_id);
    //                 }
    //             }

    //             // Debugging: Log the final list of associated extensions
    //             Log::info('Associated extensions: ' . json_encode($associated_extensions));
    //         }
    //     }


    //     $leads = [];
    //     $errors = new MessageBag();
    //     $url = env('API_URL') . "lead-new";
    //     $currentUserId = Session::get('id'); // or whatever method you use to get the current user ID

    //     try {
    //         $response = Helper::PostApi($url, $body);
    //         //echo "<pre>"; print_r($response); die;

    //         if ($response->success) {
    //             $leads = $response->data;
    //             //   if ($userRole === 'manager' && !empty($associated_extensions)) {
    //             //                     $leads = array_filter($leads, function ($lead) use ($associated_extensions) {
    //             //                         return in_array($lead->assigned_to, $associated_extensions);
    //             //                     });
    //             //                 } else {
    //             //                     $leads = $leads;
    //             //                 }

    //             $record_count = $response->record_count;
    //         } else {
    //             // Handle errors
    //             foreach ($response->errors as $key => $message) {
    //                 $errors->add($key, $message);
    //             }
    //         }
    //     } catch (RequestException $ex) {
    //         $errors->add("error", $ex->getMessage());
    //         return view("leads.list", ["errors" => $errors]);
    //     }


    //     $sortedUsers = $this->groupAndSortUsers($users);
    //     //echo "<pre>";print_r($leads);die;

    //     return view("leads.leads-new", ["leads" => $leads, "merchants" => $this->getMerchants(), "record_count" => $record_count, "lower_limit" => $lower_limit, "page" => $page, "show" => $show, "searchTerm" => $searchTerm, "lead_status" => $arrLeadStatusRekeyed, 'users' => $arrUsersRekeyed, 'page' => $page, 'view_on_leads' => $view_on_leads, 'user' => $users, 'sortedUsers' => $sortedUsers, 'crm_system' => $crm_system, 'map' => $map, 'group' => $group, 'title' => $title, 'extension_list' => $extension_list, 'timezone' => $timezone]);
    // }
}
