<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Session;
use App\Helper\Helper;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Exception\BadResponseException;
use Illuminate\Support\MessageBag;

class LeadsStatusController extends Controller
{
    

    public function index(Request $request)
    {
        $lead_status = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "leadStatus";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success)
            {
                $lead_status = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("leadstatus.list", ["errors" => $errors]);
        }
        // dump($users);
        return view("leadstatus.list", ["lead_status" => $lead_status]);
    }

    public function add(Request $request)
    {
        $this->validate($request, ['title' => 'required|string|max:255']);
        $errors = new MessageBag();
        try
        {
            $url = env('API_URL') . "add-lead-status";
            $response = Helper::RequestApi($url, "PUT", $this->getBuildBody($request), "json");

            //echo "<pre>";print_r($response);die;
            if ($response->success)
            {
                session()->flash("success", "Lead Status Added");
                return redirect("/lead-status");
            }
            else
            {
                foreach ( $response->errors as $key => $messages )
                {
                    if (is_array($messages))
                    {
                        foreach ( $messages as $index => $message )
                            $errors->add("$key.$index", $message);
                    }
                    else
                    {
                        $errors->add($key, $messages);
                    }
                }
                return redirect()->back()->withInput()->withErrors($errors);
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput()->withErrors($errors);
        }
    }

    public function delete(Request $request, $id)
    {
        $url = env('API_URL') . "delete-lead-status/$id";
        $response = Helper::RequestApi($url, "GET");
        if ($response->success)
        {
            session()->flash("success", $response->message);
            return redirect("/lead-status");
        }
        else
        {
            session()->flash("message", $response->message);
            return redirect("/lead-status");

        }
    }

    public function update(Request $request)
    {
        
        $lead_status_id = $request->lead_status_id;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "update-lead-status/$lead_status_id";
            $response = Helper::PostApi($url, $this->getBuildBody($request));
            if (!$response->success) {
                foreach ( $response->errors as $key => $messages ) {
                    foreach ($messages as $message) {
                        $errors->add($key, $message);
                    }
                }
    
                // Check if the "title" error message is present and customize it
                if ($errors->has('title') && $errors->get('title')[0] === 'The title has already been taken.') {
                    // $errors->add('title', 'The title is already taken.');
                }
                return redirect()->back()->withInput($request->input())->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput($request->input())->withErrors($errors);
        }
        session()->flash("success", "Lead Status updated");
        return redirect()->back();

    }

    public function changeLeadStatus($lead_status_id = "",  $status = "")
    {
        $body = array('lead_status_id' => $lead_status_id,'status' => $status,);
        $url = env('API_URL') . 'change-lead-status';
        $response = Helper::PostApi($url, $body);
        //echo "<pre>";print_r($response);die;
        if ($response->success)
        {
            session()->flash("success", $response->message);
            echo json_encode(array('status' => "true", 'message' =>  $response->message));
        }
        else
        {
            session()->flash("message", $response->message);
            echo json_encode(array('status' => "false", 'message' =>  $response->message));
        }
    }

    public function updateDisplayOrder(Request $request)
    {



        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "/lead-status/updateDisplayOrder";
            $response = Helper::PostApi($url, array_filter($this->getBuildBody($request)));

            
            if (!$response->success) {
                foreach ($response->errors as $key => $message) {
                    if (is_array($message)) {
                        foreach ( $message as $index => $strInsideMessage )
                            $errors->add($index, $strInsideMessage);
                    } else {
                        $errors->add($key, $message);
                    }
                }
                return redirect()->back()->withInput($request->input())->withErrors($errors);
            }
            
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput($request->input())->withErrors($errors);
        }
        session()->flash("success", "Lead updated");
        return redirect()->back();

    }


    public function changeViewOnLeadStatus($lead_status_id = "", $view_on_dashboard = "")
    {
        $body = array('lead_status_id' => $lead_status_id, 'view_on_dashboard' => $view_on_dashboard);
        $url = env('API_URL') . 'change-view-on-dashboard-status';
        $response = Helper::PostApi($url, $body);
        //echo "<pre>";print_r($body);die;
        if ($response->success) {
            session()->flash("success", $response->message);
            echo json_encode(array('status' => "true", 'message' => $response->message));
        } else {
            session()->flash("message", $response->message);
            echo json_encode(array('status' => "false", 'message' => $response->message));
        }
    }

    private function getBuildBody(Request $request)
    {
        $body = ["title" => trim(ucwords($request->get("title"))),
        "color_code" => trim(ucwords($request->get("color_code"))),
        "image" => $request->get("image"),
        "display_order" => $request->get("display_order"),
        "webhook_status" => $request->get("webhook_status"),
        "webhook_url" => $request->get("webhook_url"),
        "webhook_token" => $request->get("webhook_token"),
        "webhook_method" => $request->get("webhook_method"),



    ];
        return $body;
    }
}
