<?php

namespace App\Http\Controllers;

use App\Helper\Helper;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Session;
use Illuminate\Support\Str;
use Illuminate\Support\Collection;



class LenderApiLabelSettingController extends Controller
{
    public function index(Request $request)
    {
        $labels = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-labels";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $labels = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("pdf_reader.settings", ["errors" => $errors]);
        }

        $lender_reader = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lender-label-api-setting";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $lender_reader = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("pdf_reader.settings", ["errors" => $errors]);
        }
        //echo "<pre>";print_r($lender_reader);die;
        return view("lender_api_setting.settings", ["label_list" => $labels,'lender_reader' => $lender_reader]);
    }


    public function save(Request $request)
    {

       $request->validate([
            'label' => 'required|array',
            'ondeck' => 'nullable|array',
            'credibly' => 'nullable|array',
            'bittyadvance' => 'nullable|array',
            'fox_partner' => 'nullable|array',
            'lendini' => 'nullable|array',
            'specialty' => 'nullable|array',
            'cancapital' => 'nullable|array',
            




        ]);


       foreach ($request->input('label') as $index => $labelId) {
                $updatedLabel['label_id'][$index] = $request->input('label')[$index] ?? null;

                $updatedLabel['ondeck'][$index] = $request->input('ondeck')[$index] ?? null;
                $updatedLabel['credibly'][$index] = $request->input('credibly')[$index] ?? null;
                $updatedLabel['bittyadvance'][$index] = $request->input('bittyadvance')[$index] ?? null;
                $updatedLabel['fox_partner'][$index] = $request->input('fox_partner')[$index] ?? null;
                $updatedLabel['lendini'][$index] = $request->input('lendini')[$index] ?? null;
                $updatedLabel['specialty'][$index] = $request->input('specialty')[$index] ?? null;
                $updatedLabel['forward_financing'][$index] = $request->input('forward_financing')[$index] ?? null;
                $updatedLabel['cancapital'][$index] = $request->input('cancapital')[$index] ?? null;
                $updatedLabel['rapid'][$index] = $request->input('rapid')[$index] ?? null;
                $updatedLabel['biz2credit'][$index] = $request->input('biz2credit')[$index] ?? null;


                
                
                
                
                

               
            }

        //echo "<pre>";print_r($updatedLabel);die;






       


        $body=array(
            "data" => $updatedLabel

        );


         $url = env('API_URL') . "lender-label-api-setting";
        $response = Helper::RequestApi($url, "POST", $body, "json");
        //echo "<pre>";print_r($response);die;

        if ($response->success)
        {
        return back()->with('success', 'Lender Api Label updated successfully!');
            
        }

       // echo "<pre>";print_r($updatedLabel);die;

        // Redirect back with a success message
    }


    


   

   
}

