<?php
namespace App\Http\Controllers;
use Session;
use Pusher\Pusher;
use App\Helper\Helper;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use App\Exports\LendersExport;
use App\Exports\MasterLendersExport;
use Maatwebsite\Excel\Facades\Excel;
use File;
use Illuminate\Support\Facades\Log;
use Yajra\DataTables\Facades\DataTables;

class LenderController extends Controller
{
    public function index(Request $request)
    {
        $lenders = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lenders";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success)
            {
                $lenders = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("lenders.list", ["errors" => $errors]);
        }
        // dump($users);
          // Check if download is requested
    if ($request->has('download') && $request->get('download') == 'excel') {
        return Excel::download(new LendersExport($lenders), 'lenders.xlsx');
    }
    if ($request->ajax()) {
    return DataTables::of(collect($lenders))
        ->addIndexColumn()
        ->addColumn('name', function($row) {
            return $row->lender_name;
        })
        ->addColumn('email', function($row) {
            return $row->email;
        })
        ->addColumn('secondary_email', function($row) {
            return $row->secondary_email;
        })
        ->addColumn('contact_person', function($row) {
            return $row->contact_person;
        })
        ->addColumn('status', function ($row) {
            $badgeClass = $row->status === '1' ? "right badge badge-success badge-sm" : "right badge badge-danger badge-sm";
            $statusText = $row->status === '1' ? 'Active' : 'Inactive';
            return '<span class="' . $badgeClass . '">' . strtoupper($statusText) . '</span>';
        })
        ->addColumn('action', function($row) {
            $html = '
                <div class="list-icons d-inline-flex">
                    <a href="'.url('/lender').'/'.$row->id.'/edit" style="margin-right:5px;" type="button" title="Edit">
                        <i class="fa fa-edit fa-lg"></i>
                    </a>
                        <a type="button"  data-id="'.$row->id.'" class="list-icons-item me-10 view-lender"><i class="fa fa-eye fa-lg"></i></a>

                    <button type="button" title="Status" data-id="'.$row->id.'" class="btn btn-sm btn-toggle '.($row->status == '1' ? 'active' : '').'" data-bs-toggle="button" aria-pressed="true" autocomplete="off">
                        <div class="handle"></div>
                    </button>
                
                </div>
            ';
            return $html;
        })
        ->rawColumns(['status', 'action'])
        ->make(true);
}

        return view("lenders.list", ["lenders" => $lenders]);
    }

    public function showNew(Request $request)
    {
        
        return view("lenders.add")->with([]);
    }

    public function add(Request $request)
    {
        $this->validate($request, [
            'lender_name' => 'required|string|max:255',
        ]);

        $errors = new MessageBag();
        if ($request->hasFile('guideline')) {
            $file = $request->file('guideline');
            $extension = $file->getClientOriginalExtension();
            $filename = time() . '.' . $extension;
            $rootPath = env("FILE_UPLOAD_URL");
            $file->move($rootPath, $filename);
            $mms_url = $rootPath . '/' . $filename;
        }
        //dd($this->getBuildBody($request));

        //echo "<pre>";print_r($this->getBuildBody($request));die;

        try {
            $url = env('API_URL') . "lender";
            $response = Helper::RequestApi($url, "PUT", $this->getBuildBody($request), "json");
        //echo "<pre>";print_r($response);die;
            if ($response->success) {
                session()->flash("success", "Lender Added");
                return redirect("/lenders");
            } else {
                foreach ( $response->errors as $key => $messages ) {
                    if (is_array($messages)) {
                        foreach ( $messages as $index => $message )
                            $errors->add("$key.$index", $message);
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return redirect()->back()->withInput()->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput()->withErrors($errors);
        }
    }

    public function show(Request $request, int $id)
    {
        $lender = null;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "lender/$id";
            $response = Helper::GetApi($url, [], true);
            //echo "<pre>";print_r($response);die;
            if ($response["success"]) {
                $lender = $response["data"];
            } else {
                foreach ($response->errors as $key => $messages) {
                    if (is_array($messages)) {
                        foreach ($messages as $index => $message)
                            $errors->add("$key.$index", $message);
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return view("lenders.edit")->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("lenders.edit")->withErrors($errors);
        }

       

        $crm_lender_api = null;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "crm-lender-apis/$id";
            $response = Helper::GetApi($url, [], true);
    
            if ($response["success"] ?? false) {
                $crm_lender_api = $response["data"];
            } else {
                if (isset($response["errors"])) {
                    foreach ($response["errors"] as $key => $messages) {
                        if (is_array($messages)) {
                            foreach ($messages as $index => $message) {
                                $errors->add("$key.$index", $message);
                            }
                        } else {
                            $errors->add($key, $messages);
                        }
                    }
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
        }

        return view("lenders.edit")->with(["lender" => $lender,"crm_lender_api"=>$crm_lender_api]);
    }

    public function update(Request $request, int $id)
    {
        $this->validate($request, [
            'lender_name' => 'required|string|max:255',
        ]);

        $errors = new MessageBag();
        if ($request->hasFile('guideline')) {
            $file = $request->file('guideline');
            $extension = $file->getClientOriginalExtension();
            $filename = time() . '.' . $extension;
            $rootPath = env("FILE_UPLOAD_URL");
            $file->move($rootPath, $filename);
            $mms_url = $rootPath . '/' . $filename;
        }
        //dd($this->getBuildBody($request));
        try {
            $url = env('API_URL') . "lender/$id";
            $response = Helper::PostApi($url, $this->getBuildBody($request));
            // echo "<pre>";print_r($response);die;
            if (!$response->success) {
                foreach ( $response->errors as $key => $message ) {
                    $errors->add($key, $message);
                }
                return redirect()->back()->withInput($request->input())->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput($request->input())->withErrors($errors);
        }
        session()->flash("success", "Lender Updated");
                return redirect("/lenders");
    }

    public function profile(Request $request)
    {
        return view("users.profile");
    }

    private function getBuildBody(Request $request)
    {

        $mobile = str_replace(array('(',')', '_', '-',' '), array(''), $request->get("phone"));
        $body = [
            "lender_name" => trim(ucwords($request->get("lender_name"))),
            "email" => trim($request->get("email")),
            "secondary_email" => trim($request->get("secondary_email")),
            "secondary_email2" => trim($request->get("secondary_email2")),

            "contact_person" => trim($request->get("contact_person")),
            "city" => trim($request->get("city")),
            "address" => trim($request->get("address")),
            "state" => trim($request->get("state")),
            "phone" => trim($mobile),
            "lender_type" => trim($request->get("lender_type")),
            "data_type" => trim($request->get("data_type")),
            "min_credit_score" => trim($request->get("min_credit_score")),
            "max_negative_days" => trim($request->get("max_negative_days")),
            "max_advance" => trim($request->get("max_advance")),
            "nsfs" => trim($request->get("nsfs")),
            "min_time_business" => trim($request->get("min_time_business")),
            "min_amount" => trim($request->get("min_amount")),
            "min_deposits" => trim($request->get("min_deposits")),
            "max_position" => $request->get("max_position"),
            "max_term" => trim($request->get("max_term")),
            "white_label" => trim($request->get("white_label")),
            "consolidation" => trim($request->get("consolidation")),
            "reverse_consolidation" => trim($request->get("reverse_consolidation")),

            "sole_prop" => trim($request->get("sole_prop")),
            "home_business" => trim($request->get("home_business")),
            "non_profit" => trim($request->get("non_profit")),
            "daily" => trim($request->get("daily")),
            "coj_req" => trim($request->get("coj_req")),
            "country" => trim($request->get("country")),
            "not_business_type" => trim($request->get("not_business_type")),
            "daily_balance" => trim($request->get("daily_balance")),
            "bank_verify" => trim($request->get("bank_verify")),
           'industry'=>$request->get("industry"),
           'guideline_state'=>$request->get("guideline_state"),
           'guideline_file'=>$request->get("guideline"),
           'notes'=>$request->get("notes"),
           'min_monthly_deposit'=>$request->get("min_monthly_deposit"),
           'min_avg_revenue'=>$request->get("min_avg_revenue"),
           'max_mca_payoff_amount'=>$request->get("max_mca_payoff_amount"),
           'min_avg_revenue'=>$request->get("min_avg_revenue"),
           'ownership_percentage'=>$request->get("ownership_percentage"),
           'factor_rate'=>$request->get("factor_rate"),
           'prohibited_industry'=>$request->get("prohibited_industry"),
           'restricted_industry_note'=>$request->get("restricted_industry_note"),
           'restricted_state_note'=>$request->get("restricted_state_note"),
           'secondary_email3'=>$request->get("secondary_email3"),
           'secondary_email4'=>$request->get("secondary_email4"),

        ];

        // Add API-related fields if api_status is "yes"
    if ($request->get("api_status") === "1") {
        $body['api_status'] = "1";
        $body['username'] = trim($request->get("username"));
        $body['password'] = trim($request->get("password"));
        $body['api_key'] = trim($request->get("api_key"));
        $body['url'] = trim($request->get("url"));
        $body['lender_api_type'] = trim($request->get("lender_api_type"));
        $body['salesRepEmailAddress']=trim($request->get("salesRepEmailAddress"));
        $body['partner_api_key']=trim($request->get("partner_api_key"));
        $body['client_id']=trim($request->get("client_id"));
        $body['auth_url']=trim($request->get("auth_url"));

    } else {
        $body['api_status'] = "0";
    }
        return $body;
    }

    public function delete(Request $request, $id)
    {
        $url = env('API_URL') . "delete-user/$id";
        $response = Helper::RequestApi($url, "DELETE");
        if ($response->success)
        {
            session()->flash("success", $response->message);
            return redirect("/users");
        }
        else
        {
            session()->flash("message", $response->message);
            return redirect("/users");

        }
    }


    public function changeLenderStatus($lender_id = "",  $status = "")
    {
        $body = array('lender_id' => $lender_id,'status' => $status);
        $url = env('API_URL') . 'change-lender-status';
        $response = Helper::PostApi($url, $body);
        //echo "<pre>";print_r($body);die;
        if ($response->success)
        {
            session()->flash("success", $response->message);
            echo json_encode(array('status' => "true", 'message' =>  $response->message));
        }
        else
        {
            session()->flash("message", $response->message);
            echo json_encode(array('status' => "false", 'message' =>  $response->message));
        }
    }
    public function MasterSheet(Request $request)
    {
        $lenders = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lenders";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success)
            {
                $lenders = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("lenders.master_sheet", ["errors" => $errors]);
        }
        // dump($users);
          // Check if download is requested
    if ($request->has('download') && $request->get('download') == 'excel') {
        return Excel::download(new MasterLendersExport($lenders), 'master-lenders.xlsx');
    }
        return view("lenders.master_sheet", ["lenders" => $lenders]);
    }
        public function showModal($id)
{
 $list = null;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "lender/$id";
            $response = Helper::GetApi($url, [], true);
            //echo "<pre>";print_r($response);die;
            if ($response["success"]) {
                $list = $response["data"];
            } else {
                foreach ($response->errors as $key => $messages) {
                    if (is_array($messages)) {
                        foreach ($messages as $index => $message)
                            $errors->add("$key.$index", $message);
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return view("lenders.lender-view'")->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("lenders.lender-view'")->withErrors($errors);
        }
    return view('lenders.lender-view', compact('list'));
}
}


