<?php
namespace App\Http\Controllers;
use App\Helper\Helper;
use App\User;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Session;
use PDF;
use Dompdf\Dompdf;
use Illuminate\Support\Facades\Log;


class MailController extends Controller
{
    public static $smtpTypes = [
        0 => "none",
        1 => "user",
        2 => "campaign",
        3 => "system"
    ];

    function email(Request $request)
    {
        try
        {
            $url = env('API_URL') . "send-email/generic";
            $response = Helper::PostApi($url, $this->getBuildBody($request));
            return response()->json($response);
        }
        catch (\Throwable $exception) {
            return [
                'success' => false,
                'message' => "Failed to send the email",
            ];
        }

    }

    private function getBuildBody(Request $request)
    {
        $name = strstr($request->get("from"), '@', true);
        $body = [
            "to" => trim($request->get("to")),
            "from" => array('address'=>trim($request->get("from")),'name'=>$name),
            "subject" => trim($request->get("subject")),
            "body" => trim($request->get("message")),
            "senderType" => self::$smtpTypes[$request->get("smtpType")],
            "user_id" => session("id")
        ];
        if ($request->has("campaign_id")) {
            $body["campaign_id"] = $request->get("campaign_id");
        }
        return $body;
    }


    function openMailModal(Request $request)
    {
        $errors = new MessageBag();
        $templates = [];
        $smtpType = self::$smtpTypes[$request->smtpType];
        $query = "";
        if ($smtpType==="none") {
            return response("Emailing is disabled", 400);
        }
        $message = "";
        if ($smtpType==="system") {
            if (session("level") < 7) {
                $message = "Please contact administrator to configure system email setting.";
            } else {
                $message = "Please add system email setting for sending emails. Click <a href='/smtp' target='_blank'>here</a> to add email setting.";
            }
        } elseif ($smtpType==="campaign") {
            $query = "?campaign_id=".$request->campaign_id;
            if (session("level") < 7) {
                $message = "Please contact administrator to configure campaign email setting.";
            } else {
                $message = "Please add campaign email setting for sending emails. Click <a href='/smtp' target='_blank'>here</a> to add email setting.";
            }
        }
        if ($smtpType==="user") {
            $query = "?user_id=".session("id");
            $message = "Please add email setting for sending emails. Click <a href='/smtp' target='_blank'>here</a> to add email setting.";
        }
        try {
            $url = env('API_URL') . "smtp/type/$smtpType".$query;
            $response = Helper::GetApi($url);
            if ($response->success) {
                if (count($response->data) == 0) {
                    return response($message, 400);
                }
                $templates['smtpSetting'] = $response->data[0];
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            return $errors->add("error", $ex->getMessage());
        }

        $inherit_list = new InheritApiController();
        $templates['labels'] = $inherit_list->getLabel();
        $users = new User();
        $templates['user_column'] = $users->getTableColumns();

        try {
            $url = env('API_URL') . "email-templates";
            $response = Helper::GetApi($url);
            if ($response->success) {
                $templates['email_templates'] = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            return $errors->add("error", $ex->getMessage());
        }

        try
        {
            $url = env('API_URL') . "custom-field-labels";
            $response = Helper::GetApi($url);
            if ($response->success)
            {
                $templates['custom_label_labels'] = $response->data;
            }
            else
            {
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            return $errors->add("error", $ex->getMessage());
        }
        
        return $templates;
    }

    public function getTemplate(Request $request, int $id, int $list_id, int $lead_id)
    {
        $email_template = null;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "email-template/$id/$list_id/$lead_id";
            $response = Helper::GetApi($url, [], true);
            /*echo "<pre>";
            print_r($response);
            die();*/
            if ($response["success"]) {
                $email_template = $response["data"];

            } else {
                foreach ($response["errors"] as $key => $message) {
                    $errors->add($key, $message);
                }
                //return view("email-template.edit")->withErrors($errors);
            }
        } catch (RequestException $ex) {
            return $errors->add("error", $ex->getMessage());
            //view("email-template.edit")->withErrors($errors);
        }

        //echo "<pre>";print_r($email_template[0]);die;


        return $email_template;
    }

    public function getLabelValue(Request $request, int $id, int $list_id, int $lead_id)
    {
        $email_template = null;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "label-data/$id/$list_id/$lead_id";
            $response = Helper::GetApi($url, [], true);
            // echo "<pre>";print_r($response);die;
        } catch (RequestException $ex) {
            return $errors->add("error", $ex->getMessage());
        }
        return $response[0];
    }

    public function getSenderValue(Request $request, string $id)
    {
        $user = User::findOrFail(Session::get('id'));
        $title = str_replace('[[', '', $id);
        $final_title = str_replace(']]', '', $title);
        // echo "<pre>";print_r($user);die;
        return $user[$final_title];
    }

    public function upload(Request $request)
    {
        if($request->hasFile('upload')) {
            $originName = $request->file('upload')->getClientOriginalName();
            $fileName = pathinfo($originName, PATHINFO_FILENAME);
            $extension = $request->file('upload')->getClientOriginalExtension();
            $fileName = $fileName.'_'.time().'.'.$extension;
        
            $request->file('upload')->move(public_path('email-image'), $fileName);
   
            $CKEditorFuncNum = $request->input('CKEditorFuncNum');
            $url = asset('email-image/'.$fileName); 
            $msg = 'Image uploaded successfully'; 
            $response = "<script>window.parent.CKEDITOR.tools.callFunction($CKEditorFuncNum, '$url', '$msg')</script>";  
            @header('Content-type: text/html; charset=utf-8'); 
            echo $response;
        }
    }


    //contact crm

    function openEmailModal(Request $request)
    {
        $errors = new MessageBag();
        $templates = [];
        try
        {
            $url = env('API_URL') . "crm-email-templates";
            $response = Helper::GetApi($url);
            if ($response->success)
            {
                $templates['email_templates'] = $response->data;
            } 
            else
            {
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            return $errors->add("error", $ex->getMessage());
        }


        $errors = new MessageBag();
        $url = env('API_URL') . "crm-labels";
        try
        {
            $response = Helper::GetApi($url);
            if ($response->success)
            {
                $templates['labels'] = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

       $users = new User();
       $templates['user_column'] = $users->getTableColumns();
        
        return $templates;
    }


    public function getTemplateCRM(Request $request, int $id, int $list_id, int $lead_id)
    {
        $email_template = null;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "crm-email-template/$id/$list_id/$lead_id";
            $response = Helper::GetApi($url, [], true);
            /*echo "<pre>";
            print_r($response);
            die();*/
            if ($response["success"]) {
                $email_template = $response["data"];

            } else {
                foreach ($response["errors"] as $key => $message) {
                    $errors->add($key, $message);
                }
                //return view("email-template.edit")->withErrors($errors);
            }
        } catch (RequestException $ex) {
            return $errors->add("error", $ex->getMessage());
            //view("email-template.edit")->withErrors($errors);
        }

        //echo "<pre>";print_r($email_template[0]);die;


        return $email_template;
    }


    public function getSignedApplicationCRMPDF(Request $request, int $id, int $list_id, int $lead_id)
    {
        $email_template = null;
        $errors = new MessageBag();

        try {

            $url = env('API_URL') . "crm-custom-template/$id/$list_id/$lead_id/pdf";
            $response = Helper::GetApi($url, [], true);
            /*echo "<pre>";print_r($response);die();*/
            
            if ($response["success"]) {
                $email_template = $response["data"];

            } else {
                foreach ($response["errors"] as $key => $message) {
                    $errors->add($key, $message);
                }
                //return view("email-template.edit")->withErrors($errors);
            }
        } catch (RequestException $ex) {
            return $errors->add("error", $ex->getMessage());
            //view("email-template.edit")->withErrors($errors);
        }

        $email_template = $response['data']['template_html'];



        //new code

        /*
        $crm_system = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-system-setting";
        try {
            $response_system = Helper::GetApi($url);

            if ($response_system->success) {
                $crm_system = $response_system->data;
              

            } else {
                foreach ($response_system->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        $logo = $response_system->data[0]->logo;
        $replace_key = '--logo--';
        $vl1 = $vl1 ='<img alt="" src="'.public_path("logo/".$logo).'" style="width:30%">';
        $email_content = str_replace($replace_key, $vl1, $email_template);
        */

        $email_content = $email_template;

        

        //close codes
        $email_content .= '<style>table {width: 100%;border-collapse: collapse !important;}</style>';

        $file_name = 'signed_application_'.time().'.pdf';
        if(\File::exists(public_path('uploads/'.$file_name)))
        {
            \File::delete(public_path('uploads/'.$file_name));
        }

        $data = [
            'email_template' => $email_content
        ];
        
       // $pdf = PDF::loadView('myPDF', $data)->setPaper('A4', 'portrait')->save('logo/'.$file_name);
       return  $pdf = PDF::loadView('myPDF', $data)->setPaper('A4', 'portrait')->download($file_name);

       

      // return view("myPDF", ["email_template" => $email_content]);

   }


    public function getSignedApplicationCRM(Request $request, int $id, int $list_id, int $lead_id)
    {
        $email_template = null;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "crm-custom-template/$id/$list_id/$lead_id/view";
            $response = Helper::GetApi($url, [], true);
            /*echo "<pre>";
            print_r($response);
            die();*/
            if ($response["success"]) {
                $email_template = $response["data"];

            } else {
                foreach ($response["errors"] as $key => $message) {
                    $errors->add($key, $message);
                }
                //return view("email-template.edit")->withErrors($errors);
            }
        } catch (RequestException $ex) {
            return $errors->add("error", $ex->getMessage());
            //view("email-template.edit")->withErrors($errors);
        }


        $email_template = $response['data']['template_html'];

   
          $file_name = 'signed_application_'.time().'.pdf';
        if(\File::exists(public_path('uploads/'.$file_name)))
                {
                    \File::delete(public_path('uploads/'.$file_name));
                }
        //$pdf = PDF::loadView('myPDF', $lead_data)->save('uploads/'.$file_name);

                $email_template .= '<style>table {width: 100%;border-collapse: collapse !important;}</style>';

           

    /*    $dompdf = new Dompdf();
$dompdf->loadHtml($email_template);

$dompdf->setPaper('A4', 'landscape');

$dompdf->render();

$dompdf->stream();
*/
       // return $dompdf->download('pdfview.pdf');


       // return redirect('/uploads/'.$file_name);


        return view("myPDF", ["email_template" => $email_template]);
        //return $email_template;
    }


    public function getLabelValueCRM(Request $request, int $id, int $list_id, int $lead_id)
    {
        $email_template = null;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "label-data-crm/$id/$list_id/$lead_id";
            $response = Helper::GetApi($url, [], true);
            // echo "<pre>";print_r($response);die;
        } catch (RequestException $ex) {
            return $errors->add("error", $ex->getMessage());
        }
        return $response[0];
    }


     function sendEmailGenericCRM(Request $request)
    {

       /* $url = env('API_URL') . "send-email-crm/generic";
            $response = Helper::PostApi($url, $this->getBuildBodyGeneric($request));

            echo "<pre>";print_r($response);die;

*/
        try
        {
            $url = env('API_URL') . "send-email-crm/generic";
            $response = Helper::PostApi($url, $this->getBuildBodyGeneric($request));

            //echo "<pre>";print_r($response);die;

            if ($response->success)
            {

            $notifications = array('lead_id'=> $request->lead_id,'message'=>'online application Subject (<b>'.$request->subject.'</b>) email sent to <b>'.$request->toEmailId.'</b>');
                $result = (new NotificationController)->add($notifications);
            }
            else
            {
                $notifications = array('lead_id'=> $request->lead_id,'message'=>'online application Subject (<b>'.$request->subject.'</b>) email not sent to <b>'.$request->toEmailId.'</b>');
                $result = (new NotificationController)->add($notifications);
            }

            return response()->json($response);
        }
        catch (\Throwable $exception)
        {
            
            return 
            [
                'success' => false,
                'message' => "Failed to send the email",
            ];
        }
    }


    private function getBuildBodyGeneric(Request $request)
    {
        $body =
        [
            "toEmailId" => trim(($request->get("toEmailId"))),
            "subject" => trim(($request->get("subject"))),
            "editor1" => trim(($request->get("editor1")))
        ];
        return $body;
    }



    function sendEmailGenericAttachment(Request $request)
    {
        Log::info('reached',[$request->all()]);
        //dd($request);

        try
        {
            $emails = [];
            $url = env('API_URL') . "send-email/generic-attachment";

            //dd($this->getBuildBodyGeneric($request));
            $response = Helper::PostApi($url, $request->all());

           // echo "<pr>";print_r($response);die;

            $emails = implode(',',$request->name);
            $file_rr_name = $request->file_rr_name;  // Assuming this is an array from the request

            // Retrieve fileName as a single file name from the request
            $fileName = $request->fileUpload;          // Assuming this is a string
        
            // Convert file_rr_name array to a comma-separated string
            $file_rr_name_string = implode(',', $file_rr_name);
        
            // Concatenate the string from file_rr_name with fileName
            // If file_rr_name is not empty, add a comma before the fileName
            $file_names = $file_rr_name_string;
            if (!empty($fileName)) {
                $file_names .= ',' . $fileName;
            }
        
            if ($response->success)
            {
                if($request->share_lead == 1)
                {
                     $notifications = array('lead_id'=> $request->lead_id,'message'=>'shared documents <b>'.$file_names.'</b> to <b>'.$emails.'</b>','type' => '0');
                }
                else
                {
                     $notifications = array('lead_id'=> $request->lead_id,'message'=>'sent documents <b>'.$file_names.'</b> to lender <b>'.$emails.'</b>','type' => '2');
                }

           
                $result = (new NotificationController)->add($notifications);
            }
            else
            {
                if($request->share_lead == 1)
                {
                    $notifications = array('lead_id'=> $request->lead_id,'message'=>'(error) not shared documents <b>'.$file_names.'</b> to <b>'.$emails.'</b>','type' => '0');

                }
                else
                {

                $notifications = array('lead_id'=> $request->lead_id,'message'=>'(error) not sent documents <b>'.$file_names.'</b> to lender <b>'.$emails.'</b>','type' => '2');
                }
                $result = (new NotificationController)->add($notifications);
            }

            return response()->json($response);
        }
        catch (\Throwable $exception)
        {
            
            return 
            [
                'success' => false,
                'message' => "Failed to send the email",
            ];
        }
    }



       public function getSignedApplicationCRMMerchant(Request $request, int $id, int $list_id, int $lead_id, int $parent_id)
    {
        $email_template = null;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "crm-custom-template-merchant/$id/$list_id/$lead_id/$parent_id/view";
            $response = Helper::GetApi($url, [], true);
           /* echo "<pre>";
            print_r($response);
            die();*/
            if ($response["success"]) {
                $email_template = $response["data"];

            } else {
                foreach ($response["errors"] as $key => $message) {
                    $errors->add($key, $message);
                }
                //return view("email-template.edit")->withErrors($errors);
            }
        } catch (RequestException $ex) {
            return $errors->add("error", $ex->getMessage());
            //view("email-template.edit")->withErrors($errors);
        }


        $email_template = $response['data']['template_html'];

   
          $file_name = 'signed_application_'.time().'.pdf';
        if(\File::exists(public_path('uploads/'.$file_name)))
                {
                    \File::delete(public_path('uploads/'.$file_name));
                }
        //$pdf = PDF::loadView('myPDF', $lead_data)->save('uploads/'.$file_name);

                $email_template .= '<style>table {width: 100%;border-collapse: collapse !important;}</style>';

           

    /*    $dompdf = new Dompdf();
$dompdf->loadHtml($email_template);

$dompdf->setPaper('A4', 'landscape');

$dompdf->render();

$dompdf->stream();
*/
       // return $dompdf->download('pdfview.pdf');


       // return redirect('/uploads/'.$file_name);


        return view("myPDF", ["email_template" => $email_template]);
        //return $email_template;
    }


      public function getSignedApplicationCRMPDFMerchant(Request $request, int $id, int $list_id, int $lead_id, int $parent_id)
    {
        $email_template = null;
        $errors = new MessageBag();

        try {

            $url = env('API_URL') . "crm-custom-template-merchant/$id/$list_id/$lead_id/$parent_id/pdf";
            $response = Helper::GetApi($url, [], true);
           /* echo "<pre>";print_r($response);die();*/
            
            if ($response["success"]) {
                $email_template = $response["data"];

            } else {
                foreach ($response["errors"] as $key => $message) {
                    $errors->add($key, $message);
                }
                //return view("email-template.edit")->withErrors($errors);
            }
        } catch (RequestException $ex) {
            return $errors->add("error", $ex->getMessage());
            //view("email-template.edit")->withErrors($errors);
        }

        $email_template = $response['data']['template_html'];



        //new code

        /*
        $crm_system = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-system-setting";
        try {
            $response_system = Helper::GetApi($url);

            if ($response_system->success) {
                $crm_system = $response_system->data;
              

            } else {
                foreach ($response_system->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        $logo = $response_system->data[0]->logo;
        $replace_key = '--logo--';
        $vl1 = $vl1 ='<img alt="" src="'.public_path("logo/".$logo).'" style="width:30%">';
        $email_content = str_replace($replace_key, $vl1, $email_template);
        */

        $email_content = $email_template;

        

        //close codes
        $email_content .= '<style>table {width: 100%;border-collapse: collapse !important;}</style>';

        $file_name = 'signed_application_'.time().'.pdf';
        if(\File::exists(public_path('uploads/'.$file_name)))
        {
            \File::delete(public_path('uploads/'.$file_name));
        }

        $data = [
            'email_template' => $email_content
        ];
        
       // $pdf = PDF::loadView('myPDF', $data)->setPaper('A4', 'portrait')->save('logo/'.$file_name);
       return  $pdf = PDF::loadView('myPDF', $data)->setPaper('A4', 'portrait')->download($file_name);

       

      // return view("myPDF", ["email_template" => $email_content]);

   }



    //end contact crm






}

