<?php
namespace App\Http\Controllers;
use Session;
use Pusher\Pusher;
use App\Helper\Helper;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use App\Classes\ApiClass;
use File;
use Redirect;
use \App\Http\Controllers\InheritApiController;

class MerchantDocumentController extends Controller
{
    protected $request;

    public function __construct(Request $request)
    {        
        $this->active = request()->segment(4);        
        $this->token = request()->segment(8);

        if (Session::get("role") == "MERCHANT") {
            $this->clientId = Session::get('clientId');
            $this->leadId = Session::get('leadId');
            $this->indexView = "merchant_new.index";
        } else {
            $this->clientId = request()->segment(6);
            $this->leadId = request()->segment(7);
            $this->indexView = "merchant.index";
        }
    }
    
   

    public function indexDocument(Request $request)
    {
        $userdetails = InheritApiController::headerUserDetails();
        //$timezone = $userdetails->data->timezone;
        $timezone = 'America/New_York';//$userdetails->data->timezone;

        $active_status = '';
        $intLeadId = $this->leadId;
        $unique_token = $this->token;
        $intClientId = $this->clientId;
        $active = $this->active;

        $company_details = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-system-settings/$intClientId";
        try {
            $response = Helper::GetApi($url);
            // echo "<pre>";print_r($response);die;

            if ($response->success) {
                $company_details = $response->data;
              

            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view($this->indexView, ["errors" => $errors]);
        }

        $document_types = null;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "document-types-list/$intClientId";
            $response = Helper::GetApi($url, [], true);
            //echo "<pre>";print_r($response);die;
            if ($response["success"]) {
                $document_types = $response["data"];
            } else {
                foreach ($response->errors as $key => $messages) {
                    if (is_array($messages)) {
                        foreach ($messages as $index => $message)
                            $errors->add("$key.$index", $message);
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return view("users.edit")->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("users.edit")->withErrors($errors);
        }
        $lead_id = $this->leadId;//last(request()->segments());
        if ($request->isMethod('post'))
        {

             for($i=0;$i<count($request->document_type);$i++)
                {
                    if(!empty($request->type_value[$i]))
                    {
                        $type_value = $request->type_value[$i];
                        $document_type[] = $request->document_type[$i].'-'.$type_value;
                    }
                    else
                    {
                        $document_type[] = $request->document_type[$i];
                    }

                    $document_name[] = $request->document_name[$i];
                }

              
             $this->validate($request,
                    [
                        'file_name' => 'required',
                        //'file_name' => 'mimes:pdf,jpg,jpeg,png,gif'
                        
                        //'file_name.*' => 'mimes:gif,jpeg,png,txt,doc,docx,xlsx,xls,pdf,wav,mp3'
                    ]);

            if($request->hasfile('file_name'))
            {
                foreach($request->file('file_name') as $key => $file)
                {
                    $size = $file->getSize();

                    $units = array( 'B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB');
                    $power = $size > 0 ? floor(log($size, 1024)) : 0;
                    $file_size =  number_format($size / pow(1024, $power), 2, '.', ',') . ' ' . $units[$power];
                    $rand =rand(1111,9999);
                    $extension = $file->getClientOriginalExtension(); // getting image extension
                    // $filename =  $rand. time() . '.' . $extension;
                        $filename =  $document_type[$key].'_'. time() . '.' . $extension;

                    $rootPath = public_path('uploads');

                    $file->move($rootPath, $filename);
                    $request['file_name'] = $filename;
                    $request['lead_id'] = $lead_id;
                    $request['file_size'] = $file_size;
                    $request['document_name'] = $document_name[$key];
                    $request['document_type'] = $document_type[$key];
                    $request['parent_id'] = $intClientId;
                    
                    //dd($request);
                    //echo "<pre>";print_r($request);die;
                    //echo "s";die;
                     $this->add($request);
                  

                    $lead = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lead-details-by-token/" . $unique_token."/".$intClientId;
        try {
            $response = Helper::GetApi($url);
            //llllecho "<pre>";print_r($response);die;
            if ($response->success) {
                $lead = $response->data;
                $unique_token = $lead->unique_token;
                $intLeadId = $lead->id;
                if($unique_token != $this->token)
                {
            return view("errorpage.401", ["errors" => $errors]);

                }
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view($this->indexView, ["errors" => $errors]);
        }

                    $notifications = array('lead_id'=> $request->lead_id,'message'=>'<b>'.$lead->first_name.' '.$lead->last_name.'</b>'.' has added the  document <b> '.str_replace('_',' ',ucwords($document_type[$key])).' </b>successfully.');

             //$notifications = array('lead_id'=> $request->lead_id,'message'=>'added document <b>'.ucwords(str_replace('_',' ',$request->document_type)).'</b> successfully');
                    $errors = new MessageBag();
                    try
                    {
                        $url = env('API_URL') . "add-notification/add/$request->lead_id/$intClientId";
                        $response = Helper::RequestApi($url, "PUT", $notifications, "json");
                        //echo "<pre>";print_r($response);die;
                        if ($response->success)
                        {
                            //session()->flash("success", "Updated Personal Information");
                        } 
                        else 
                        {
                            foreach ($response->errors as $key => $messages)
                            {
                                if (is_array($messages))
                                {
                                    foreach ($messages as $index => $message)
                                        $errors->add("$key.$index", $message);
                                }
                                else
                                {
                                    $errors->add($key, $messages);
                                }
                            }
                            return redirect()->back()->withInput()->withErrors($errors);
                        }
                    }
                    catch (RequestException $ex)
                    {
                        $errors->add("error", $ex->getMessage());
                        return redirect()->back()->withInput()->withErrors($errors);
                    }
                }
                return Redirect::back()->with("success", "Document Added");

            }
        }

        $document_type = null;
        $errors = new MessageBag();
        try {
            //$url = env('API_URL') . "documents/$this->leadId";
            $url = env('API_URL') . "document-list/$intLeadId/$intClientId";

            $response = Helper::GetApi($url, [], true);
          // echo "<pre>";print_r($response);die;

            if ($response["success"]) {
                $document_type = $response["data"];
            } else {
                foreach ($response->errors as $key => $messages) {
                    if (is_array($messages)) {
                        foreach ($messages as $index => $message)
                            $errors->add("$key.$index", $message);
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return view("documents.list")->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("documents.lead-wise-documents")->withErrors($errors);
        }



            //echo "<pre>";print_r($lead);die;
        return view($this->indexView."-documents")->with([  'document_types'=>$document_types, 'document_type' => $document_type, 'clientId' => $intClientId,'active_status' => $active_status,'lead_id' => $lead_id,'token_url'=>$unique_token,'parent_id' => $intClientId,'active' => $active,'company_details' => $company_details,'timezone'=>$timezone]);

    }


    public function store(Request $request)
    {
        $intClientId = $request->clientId;
        $type = $request->type;
        $url = env('API_URL') . "type-value/$type/$intClientId";
        $response = Helper::GetApi($url, [], true);
        $values =  json_decode($response['data'][0]['values']);
        return response()->json(['success'=>'Data is successfully added','values'=>$values]);
    }


   public function add(Request $request)
    {

       // dd($request);
        $this->validate($request, ['document_name' => 'required|string|max:255', 'document_type' => 'required|string', 'lead_id' => 'required|int']);

       // echo "S";die;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "document/$request->parent_id";
            $response = Helper::RequestApi($url, "PUT", $this->getBuildBody($request), "json");



             



            /*$notifications = array('lead_id'=> $request->lead_id,'message'=>'added document <b>'.ucwords(str_replace('_',' ',$request->document_type)).'</b> successfully');
                $result = (new NotificationController)->add($notifications);*/
            
            

          if ($response->success) {
                session()->flash("success", "Document Added");
                return back();
            } else {
                foreach ($response->errors as $key => $messages) {
                    if (is_array($messages)) {
                        foreach ($messages as $index => $message)
                            $errors->add("$key.$index", $message);
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return redirect()->back()->withInput()->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput()->withErrors($errors);
        }
    }


    private function getBuildBody(Request $request)
    {
        $body = ["document_name" => trim(ucwords($request->get("document_name"))),
            "document_type" => $request->get("document_type"),
            "file_name" => $request->get("file_name"),
            "lead_id" => $request->get("lead_id"),
            "file_size" => $request->get("file_size")

            ];
        return $body;
    }


    private function getBuildBodyLead(Request $request, $intClientId)
    {

        
        //get labels
        $labels = $body = [];
        $url = env('API_URL') . "label-list/$intClientId";
        try
        {
            $response = Helper::GetApi($url);
            if ($response->success)
            {
                $labels = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        foreach($labels as $key => $label){
            $body[$label->column_name] = $request->get($label->column_name);
        }


        if(!empty($request->signed))
        {

        $folderPath = env("SIGNATURE_FILE_UPLOAD_PATH");

        
        $image_parts = explode(";base64,", $request->signed);
              
        $image_type_aux = explode("image/", $image_parts[0]);
           
        $image_type = $image_type_aux[1];
           
        $image_base64 = base64_decode($image_parts[1]);

        $file_name = uniqid() . '.'.$image_type;
           
        $file = $folderPath . $file_name;
        file_put_contents($file, $image_base64);
            
        $body['signature_image'] = $file_name;
        }


        $body['lead_status'] = $request->get('lead_status');
        $body['assigned_to'] = $request->get('assigned_to');
        $body['lead_type'] = $request->get('lead_type');
        $body['lead_source_id'] = $request->get('lead_source_id');
        $body['lead_unique_url'] = $request->get('lead_unique_url');




        return $body;
    }
    
}


