<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Log;
use Session;
use App\Helper\Helper;
use Illuminate\Http\Request;

use Illuminate\Support\MessageBag;

class MerchantLoginController extends Controller
{
    public function index(Request $request)
    {
        return view('merchant_new.login');
    }

    function apilogin(Request $request)
    {
        $username = $request->email;
        $password = $request->password;
        $url = env('API_URL') . 'merchant-auth';

        $body = array(
            'email' => $username,
            'password' => $password,
            'userAgent' => $request->userAgent(),
            'clientIp' => $request->ip(),
            'device'   => 'desktop_app'
        );

        try {
            $result = Helper::PostApi($url, $body);
            // echo "<pre>";print_r($result);die;
            if ($result->success)
            {                
                Session::put('emailId', $result->data->email);
                Session::put('clientId', $result->data->client_id);
                Session::put('leadId', $result->data->lead_id);
                Session::put('status', $result->data->status);
                Session::put('tokenId', $result->data->token);
                Session::put('level', $result->data->level);
                Session::put('role', "MERCHANT");
                Session::put('leadToken', $result->data->lead_data->unique_token);
                Session::put('timezone_session', 0);

                return redirect()->route('merchant.index',[
                    'client_id'=> $result->data->client_id,
                    'lead_id'=> $result->data->lead_id,
                    'unique_url'=> $result->data->lead_data->unique_token
                ]);
            } else {
                $message = $result->message;
                if (isset($result->errors)) {
                    foreach ($result->errors as $error) {
                        $message .= " $error";
                    }
                }
                return redirect()->route('merchant.login')->with('message', $message);
            }
        } catch (\Exception $exception) {
            Log::error($exception->getMessage(), [
                "url" => $url,
                "email" => $username
            ]);
            return redirect()->route('merchant.login')->with('message', 'Error code - (authentication): Oops something went wrong :( Please contact your administrator.)');
        }
    }

    function dashboard()
    {
        return view('dashboard.dashboard');
    }

    public function logout()
    {
        Session::flush();
        return redirect('/merchant-login');
    }
}

