<?php

namespace App\Http\Controllers;
use Session;
use App\Helper\Helper;
use Illuminate\Http\Request;
use GuzzleHttp\Exception\RequestException;
use App\Http\Controllers\InheritApiController;
use Illuminate\Support\Facades\Storage;
use GuzzleHttp\Exception\BadResponseException;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\MessageBag;
use Exception;
use InvalidArgumentException;
use File;
use Illuminate\Support\Facades\View;

class OpenAiController extends Controller 
{
    public function sendSms(Request $request)
    {
        $open_ai_setting = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "open-ai-setting";

        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $open_ai_setting = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("open-ai.update-setting", ["errors" => $errors]);
        }

        $access_token = $open_ai_setting[0]->access_token;
        //$cli = '+1'.$open_ai_setting[0]->cli;
        $cli = '+'.$open_ai_setting[0]->cli;
        
        $introduction = $open_ai_setting[0]->introduction;
        $description = $open_ai_setting[0]->description;
        $api_url = $open_ai_setting[0]->sms_ai_api_url;
        $webhook_url = $open_ai_setting[0]->webhook_url;

        $number = str_replace(array('(',')', '_', '-',' '), array(''), $request->to);
        $merchant = str_replace('+','',$number);

        $did = str_replace('+','',$cli); //cli


        $sms_ai_history = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "sms-ai-history";

        $body=array('number'=>$merchant,'cli' => $did);


        try
        {
            $response = Helper::PostApi($url,$body);
            //echo "<pre>";print_r($response->data->count);die;
            if ($response->success) {
                $sms_ai_history = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("open-ai.update-setting", ["errors" => $errors]);
        }

        $count_sms_history =$sms_ai_history->count;

        if($count_sms_history == 0)
        {
            $TELNYX_SMS_AI_URL   = env('TELNYX_SMS_AI_URL');
                        $sendSms = $TELNYX_SMS_AI_URL.'sms/send';


        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $sendSms);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'accept: application/json',
            'x-api-key: '.$access_token,
            'Content-Type: application/json',
        ]);

        $array = ['cli' => $cli,'number' => '+'.$merchant, 'introduction' => $introduction,'description' => $description];
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($array));
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }

    return $count_sms_history;
    }

    public function demo()
    {
        $open_ai_setting = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "open-ai-setting";

        try
        {
            $response = Helper::GetApi($url);
            // echo "<pre>";print_r($response);die;
            if ($response->success) {
                $open_ai_setting = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("open-ai.update-setting", ["errors" => $errors]);
        }

        return view('open-ai.list',['open_ai_setting'=>$open_ai_setting]);
    }

    public function openAISetting(Request $request)
    {
        $this->validate($request, [
            'cli'      => 'required',
            "introduction"    => "required",
            "description"          => "required",
            "access_token"          => "required",

        ]);

        $errors = new MessageBag();

        try
        {
            $url = env('API_URL') . "add-open-ai-setting";
            $response = Helper::RequestApi($url, "PUT", $this->getBuildBody($request), "json");
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                session()->flash("success", "Tariff Label Values created");
                return redirect("tariff-label-values");
            } else {
                foreach ( $response->errors as $key => $messages ) {
                    if (is_array($messages)) {
                        foreach ( $messages as $index => $message )
                            $errors->add("$key.$index", $message);
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return redirect()->back()->withInput()->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput()->withErrors($errors);
        }
    }


    public function add(Request $request)
    {
        $errors = new MessageBag();    
        if((!empty($request->open_ai_id)))
        {
            try
            {

                // /dd($this->getBuildBody($request));
                $url = env('API_URL') . "update-open-ai-setting/$request->open_ai_id";
                $response = Helper::PostApi($url, $this->getBuildBody($request));
                //echo "<pre>";print_r($response);die;

                if (!$response->success) {
                    foreach ( $response->errors as $key => $messages )
                    {
                        if (is_array($messages))
                        {
                            foreach ( $messages as $index => $message )
                                $errors->add("$key.$index", $message);
                        }
                        else
                        {
                            $errors->add($key, $messages);
                        }
                    }

                    return redirect()->back()->withInput($request->input())->withErrors($errors);
                }
            } catch (RequestException $ex) {
                $errors->add("error", $ex->getMessage());
                return redirect()->back()->withInput($request->input())->withErrors($errors);
            }
            session()->flash("success", "SMS AI System Setting updated");
            return redirect()->back();
        }

        try
        {
            $url = env('API_URL') . "add-open-ai-setting";
            $response = Helper::RequestApi($url, "POST", $this->getBuildBody($request), "json");
            //echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                session()->flash("success", "SMS AI Setting Added");
                return redirect("/sms-ai-setting");
            }
            else
            {
                foreach ( $response->errors as $key => $messages )
                {
                    if (is_array($messages))
                    {
                        foreach ( $messages as $index => $message )
                            $errors->add("$key.$index", $message);
                    }
                    else
                    {
                        $errors->add($key, $messages);
                    }
                }
                return redirect()->back()->withInput()->withErrors($errors);
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput()->withErrors($errors);
        }
    }

    public function index(Request $request)
    {
        $inherit_list = new InheritApiController;
        $did_list = $inherit_list->getDidList();

        //echo "<pre>";print_r($did_list);die;
        $open_ai_setting = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "open-ai-setting";

        try {

            $response = Helper::GetApi($url);
            // echo "<pre>";print_r($response);die;
            if ($response->success) {
                $open_ai_setting = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("open-ai.update-setting", ["errors" => $errors]);
        }
        return view('open-ai.update-setting',['open_ai_setting' => $open_ai_setting, 'did_list' => $did_list]);
    }

    private function getBuildBody(Request $request)
    {

        $number = str_replace(array('(',')', '_', '-',' '), array(''), $request->cli);

        $body = [
            "cli" => $number,
            'introduction'=> $request->get("introduction"),
            'webhook_url'=> $request->get("webhook_url"),
            'sms_ai_api_url'=> $request->get("sms_ai_api_url"),
            'description'=>$request->get('description'),
            'access_token'=>$request->get('access_token')];
            return $body;
    }

    public function getSmsCountsunreadOld(Request $request)
    {

        $merchant = $request->merchant_number;
        $open_ai_setting = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "open-ai-setting";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $open_ai_setting = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("open-ai.update-setting", ["errors" => $errors]);
        }

        $access_token = $open_ai_setting[0]->access_token;
        $cli = '1'.$open_ai_setting[0]->cli;
        

        $TELNYX_SMS_AI_URL   = env('TELNYX_SMS_AI_URL');
        $smsList = $TELNYX_SMS_AI_URL.'sms/list?cli='.$cli.'&number='.$merchant;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $smsList);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
       curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'accept: application/json',
            'x-api-key: '.$access_token,
            'Content-Type: application/json',
        ]);
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }


    public function getSmsCountsunread(Request $request)
    {
        $merchant = $request->merchant_number;

        $open_ai_setting = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "open-ai-setting";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $open_ai_setting = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("open-ai.update-setting", ["errors" => $errors]);
        }

        $access_token = $open_ai_setting[0]->access_token;
       // $cli = '1'.$open_ai_setting[0]->cli;
        $cli = $open_ai_setting[0]->cli;

        $introduction = $open_ai_setting[0]->introduction;
        $description = $open_ai_setting[0]->description;
        $api_url = $open_ai_setting[0]->sms_ai_api_url;
        $webhook_url = $open_ai_setting[0]->webhook_url;



        


        $sms_ai_history = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "sms-ai-history";

        $body=array('number'=>$merchant,'cli' => $cli);

           



        try
        {
          $response_data = Helper::PostApi($url,$body);
            //echo "<pre>";print_r($body);die;
            if ($response_data->success) {
                $sms_ai_history = $response_data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("open-ai.update-setting", ["errors" => $errors]);
        }

        return json_encode($sms_ai_history);
/*
        //$count_sms_history =$sms_ai_history->count;

        //$merchant = $request->merchant_number;
        
        return $sms_ai_history;*/
        

    }


    public function delete(Request $request)
    {

        $number = '1'.str_replace(array('(',')', '_', '-',' '), array(''), $request->to);


        $open_ai_setting = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "open-ai-setting";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $open_ai_setting = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("open-ai.update-setting", ["errors" => $errors]);
        }

        $access_token = $open_ai_setting[0]->access_token;
        //$cli = '1'.$open_ai_setting[0]->cli;
        $cli = $open_ai_setting[0]->cli;

        $introduction = $open_ai_setting[0]->introduction;
        $description = $open_ai_setting[0]->description;
        $api_url = $open_ai_setting[0]->sms_ai_api_url;
        $webhook_url = $open_ai_setting[0]->webhook_url;


        //sms ai delete data

        $TELNYX_SMS_AI_URL   = env('TELNYX_SMS_AI_URL');
        $deleteSms = $TELNYX_SMS_AI_URL.'sms/delete?cli='.$cli.'&number='.$number;
         $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $deleteSms);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
       curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'accept: application/json',
            'x-api-key: '.$access_token,
            'Content-Type: application/json',
        ]);
        $response = curl_exec($ch);
        curl_close($ch);

        //flush cache api
        $TELNYX_SMS_AI_URL   = env('TELNYX_SMS_AI_URL');
        $flushCache = $TELNYX_SMS_AI_URL.'sms/flush-cache';
         $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $flushCache);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
       curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'accept: application/json',
            'x-api-key: '.$access_token,
            'Content-Type: application/json',
        ]);
        $response = curl_exec($ch);
        curl_close($ch);


        $delete_ai_history = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "delete-message-ai";

        $body=array('number'=>$number,'cli' => $cli);


        try
        {
            $response = Helper::PostApi($url,$body);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $delete_ai_history = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("open-ai.update-setting", ["errors" => $errors]);
        }

        return 1;

    }

    public function flushCache()
    {
        $open_ai_setting = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "open-ai-setting";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $open_ai_setting = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("open-ai.update-setting", ["errors" => $errors]);
        }

        $access_token = $open_ai_setting[0]->access_token;


        //flush cache api
        $TELNYX_SMS_AI_URL   = env('TELNYX_SMS_AI_URL');
        $flushCache = $TELNYX_SMS_AI_URL.'sms/flush-cache';
         $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $flushCache);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
       curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'accept: application/json',
            'x-api-key: '.$access_token,
            'Content-Type: application/json',
        ]);
        $response = curl_exec($ch);
        curl_close($ch);

       // echo "<pre>";print_r($response);die;

        session()->flash("success", "All cache erased For SMS AI");
                return redirect("/sms-ai-setting");

    }
}
