<?php

namespace App\Http\Controllers;

use App\Helper\Helper;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Session;
use Illuminate\Support\Str;
use Illuminate\Support\Collection;



class PdfReaderSettingController extends Controller
{
    public function index(Request $request)
    {
        $labels = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-labels";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $labels = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("pdf_reader.settings", ["errors" => $errors]);
        }

        $pdf_reader = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "pdf-reader-setting";
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $pdf_reader = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("pdf_reader.settings", ["errors" => $errors]);
        }
        //echo "<pre>";print_r($response);die;
        return view("pdf_reader.settings", ["label_list" => $labels, "pdf_reader" => $pdf_reader]);
    }


    public function update(Request $request)
    {

       // dd($request);
        // Validate the incoming data
        $request->validate([
            'para_label' => 'required|array',
            'label' => 'required|array',
        ]);


        // Process the data (e.g., save the updated labels to the database)
        foreach ($request->para_label_id as $index => $label) {
           // echo $label;die;
            $updatedLabel[$label] = $request->label[$index];
            
            // Example: Update the labels in the database or perform other actions
            // Assuming you have a model like PdfLabel
            /*PdfLabel::where('pdf_label', $label)
                    ->update(['label_title_url' => $updatedLabel]);*/
        }

        $body=array(
            "data" => $updatedLabel

        );


         $url = env('API_URL') . "update-pdf-reader";
        $response = Helper::RequestApi($url, "POST", $body, "json");
        //echo "<pre>";print_r($response);die;

        if ($response->success)
        {
        return back()->with('success', 'Pdf Label updated successfully!');
            
        }

       // echo "<pre>";print_r($updatedLabel);die;

        // Redirect back with a success message
    }


    function upload(Request $request)
    {
        if(!empty($request->file('did_file')))
        {        
            $file = $request->file('did_file');

            $extension = $file->getClientOriginalExtension(); // getting image extension
            $filename =time().'.'.$extension;
            $rootPath = env("FILE_UPLOAD_PATH");
            // $rootPath='C:\xampp\htdocs\subscription\backend\public\api/';
            $file->move($rootPath, $filename);
            
            $body=array(
                'id' => Session::get('id'),
                'token' => Session::get('tokenId'),
                'file' => $filename,
                'upload_title' => 'Did List',
            );
                            //echo "<pre>";print_r($did_upload);die;

            $url = env('API_URL').'upload-pdf-reader';
            //echo $url;
      

            try
            {
                $did_upload = Helper::PostApi($url,$body);
                //echo "<pre>";print_r($did_upload);die;

                if ($did_upload && !empty($did_upload->success)) {

                    $pdf_data = $did_upload->data;
               // echo "<pre>";print_r($pdf_data);die;


                    $uuid = Str::uuid();

        $inherit_list = new InheritApiController;
        $users = $inherit_list->getExtensionList();

        


        $lead_status = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "leadStatus";
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $lead_status = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        $domain_list = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "domain-list";
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $domain_list = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }


        $labels = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-labels";
        try {
            $response = Helper::GetApi($url);
           // echo "<pre>";print_r($response);die;
            if ($response->success) {
                $labels = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        //echo "<pre>";print_r($labels);die;


        $lead_source = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lead-source";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success)
            {
                $lead_source = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("leads.add", ["errors" => $errors]);
        }

        $state_list = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "state-list";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success)
            {
                $state_list = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("leads.add", ["errors" => $errors]);
        }

        //echo "<pre>";print_r($pdf_data);die;
        $sortedUsers = $this->groupAndSortUsers($users);

        return view("pdf_reader.add")->with(["labels" => $labels, "lead_status" => $lead_status, 'users' => $users, 'lead_source' => $lead_source, 'domain_list' => $domain_list, 'uuid' => $uuid,'state_list' => $state_list,'sortedUsers'=>$sortedUsers,"pdf_data" => $pdf_data]);




















                    //unlink($rootPath . $filename); // Clean up file after success
                    return back()->withSuccess('Pdf  added successfully');
                } else {
                    return back()->with('error', 'Failed to add DID. Please try again.');
                }
        }

        catch (BadResponseException $e) 
        {
            return back()->with('message',"Error code - (upload-did): Oops something went wrong :( Please contact your administrator.)");
        }

        catch (RequestException $ex) 
        {
        return back()->with('message',"Error code - (upload-did): Oops something went wrong :( Please contact your administrator.)");
        }
        }

    }

    private function groupAndSortUsers(array $users): Collection
    {
        $groupedUsers = collect($users)->groupBy(function ($user) {
            return strtoupper(substr($user->first_name, 0, 1));
        });

        $groupedUsers = $groupedUsers->map(function ($group) {
            return $group->sortBy('first_name');
        });

        $groupedUsers = $groupedUsers->sortKeys();

        return $groupedUsers->flatMap(function ($group) {
            return $group->values();
        });
    }
}

