<?php

namespace App\Http\Controllers;

use App\Helper\Helper;
use Illuminate\Support\MessageBag;
use Session;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;
use Yajra\DataTables\Facades\DataTables;
use Carbon\Carbon; // import at top of your controller
class ProspectsController extends Controller
{
public function index(Request $request)
{
    $url = env('API_URL') . '/prospects';

    $body = [
        'client_id' => Session::get('parentId'),
        'id'        => Session::get('id'),   // safer to take from session
        'token'     => Session::get('tokenId'),
    ];

    try {
        $response = Helper::PostApi($url, $body);
        //echo "<pre>";print_r($response);die;

        if (isset($response->success) && $response->success) {
            // Pass data to the view
            $prospects = $response->data ?? [];
               // if AJAX request, return JSON
    if ($request->ajax()) {
        return DataTables::of(collect($prospects))
            ->addIndexColumn()
            ->addColumn('name', function($row) {
                return $row->first_name . ' ' . $row->last_name;
            })
            ->addColumn('email', function($row) {
             return $row->email;

            })
            ->addColumn('phone', function($row) {
                if (empty($row->mobile)) {
                    return 'Not Configured';
                }

                $formatted = preg_replace('/(\d{3})(\d{3})(\d{4})/', '($1) $2-$3', $row->mobile);
                   if (!empty($row->country_code)) {
                        return '+' . $row->country_code . ' ' . $formatted;
                    } else {
                        return $formatted; // country code not present, just show number
                    }
            })

            ->addColumn('company_name', function($row) {
                return $row->company_name ?? '-';
            })
               ->addColumn('status', function($row) {
                return $row->status ?? '-';
            })
                 ->addColumn('created_at', function($row) {
     return $row->created_at 
        ? Carbon::parse($row->created_at)->format('d/m/Y') 
        : '-';
          })
        
            ->make(true);
    }
            return view('prospects.index', compact('prospects'));
        } else {
            return view('prospects.index')->with([
                'prospects' => [],
                'error'     => $response->message ?? 'Failed to load data.',
            ]);
        }
    } catch (\Throwable $ex) {
        return view('prospects.index')->with([
            'prospects' => [],
            'error'     => $ex->getMessage(),
        ]);
    }
}


public function ProspectsInitialData(Request $request)
{
    $url = env('API_URL') . '/prospects-initial-data';

    $body = [
        'client_id' => Session::get('parentId'),
        'id'        => Session::get('id'),   // safer to take from session
        'token'     => Session::get('tokenId'),
    ];

    try {
        $response = Helper::PostApi($url, $body);
        //echo "<pre>";print_r($response);die;

        if (isset($response->success) && $response->success) {
            // Pass data to the view
            $prospects = $response->data ?? [];
               // if AJAX request, return JSON
    if ($request->ajax()) {
        return DataTables::of(collect($prospects))
            ->addIndexColumn()
            ->addColumn('name', function($row) {
                return $row->name;
            })
            ->addColumn('email', function($row) {
             return $row->email;

            })
            ->addColumn('phone_number', function($row) {
            if (empty($row->phone_number)) {
                return 'Not Configured';
            }

    $formatted = preg_replace('/(\d{3})(\d{3})(\d{4})/', '($1) $2-$3', $row->phone_number);

    if (!empty($row->country_code)) {
        return '+' . $row->country_code . ' ' . $formatted;
    } else {
        return $formatted; // country code not present, just show number
    }
})


            ->addColumn('company_name', function($row) {
                return $row->company_name ?? '-';
            })
              ->addColumn('created_at', function($row) {
     return $row->created_at 
        ? Carbon::parse($row->created_at)->format('d/m/Y') 
        : '-';
          })
            ->make(true);
    }
            return view('prospects.initial-data', compact('prospects'));
        } else {
            return view('prospects.initial-data')->with([
                'prospects' => [],
                'error'     => $response->message ?? 'Failed to load data.',
            ]);
        }
    } catch (\Throwable $ex) {
        return view('prospects.initial-data')->with([
            'prospects' => [],
            'error'     => $ex->getMessage(),
        ]);
    }
}



 

}
