<?php

namespace App\Http\Controllers\Ringless;
use Session;
use App\Helper\Helper;
use GuzzleHttp\Exception\BadResponseException;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\MessageBag;
use Illuminate\Support\Facades\Config;
use App\Http\Controllers\Controller;

class RinglessCallReportController extends Controller
{

    public function index()
    {
         //areacode list
         $area_codes=[];
         $url = env('API_URL') . "area-code-list";
         try {
         $response = Helper::GetApi($url);
         if ($response->success) {
            $area_codes = $response->data;
                } else {
                    foreach ( $response->errors as $key => $message ) {
                        $errors->add($key, $message);
                    }
                }
            } catch (RequestException $ex) {
                $errors->add("error", $ex->getMessage());
                return view("ringless-voicemail.reports.call-data-report", compact("errors", $errors));
            }
        $campaign_list = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "ringless/campaign";
        try {
            $response = Helper::GetApi($url);

            if ($response->success) {
                $campaign_list = $response->data;
            } else {
                foreach ( $response->errors as $key => $message ) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("ringless-voicemail.reports.call-data-report", compact("errors", $errors));
        }
        $url = env('API_URL') . 'ringless/reports/call-data';
   
        try 
        {

            $cdr_report = Helper::GetApi($url);
            //echo'<pre>';print_r($cdr_report); exit;
            if ($cdr_report->success == 'true') {
                $report = $cdr_report->data;
                session()->flash("success", $cdr_report->message);
                return view('ringless-voicemail.reports.call-data-report',compact('report','campaign_list','area_codes'));
            }
            if ($cdr_report->success == 'false') {
                return redirect('/');
            }
        } catch (BadResponseException $e)
        {
            return back()->with('message', "Error code - (report): Oops something went wrong :( Please contact your administrator.)");
        } catch (RequestException $ex) 
        {
            $message = "Page Not Found";
            return redirect('/');
        }

       return view('ringless-voicemail.reports.call-data-report',compact('campaign_list','area_codes','cdr_report'));
    }
    public function getReport(Request $request) 
    {
           //areacode list
           $area_codes=[];
           $url = env('API_URL') . "area-code-list";
           try {
           $response = Helper::GetApi($url);
           if ($response->success) {
              $area_codes = $response->data;
                  } else {
                      foreach ($response->errors as $key => $message ) {
                          $errors->add($key, $message);
                      }
                  }
              } catch (RequestException $ex) {
                  $errors->add("error", $ex->getMessage());
                  return view("ringless-voicemail.reports.call-data-report", compact("errors", $errors));
              }
        $campaign_list = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "ringless/campaign";
        try {
            $response = Helper::GetApi($url);

            if ($response->success) {
                $campaign_list = $response->data;
            } else {
                foreach ( $response->errors as $key => $message ) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("ringless-voicemail.reports.call-data-report", compact("errors", $errors));
        }

            $number = str_replace(array('(',')', '_', '-',' '), array(''), $request->number); 
                
                $url = env('API_URL') . 'ringless/reports/call-data';
                $body = array
                (
                    'id' => Session::get('id'),
                    'level' => Session::get('level'),
                    'token' => Session::get('tokenId'),
                    'number' => $number, 
                    'campaign'=>$request->campaign,                 
                    'start_date' => $request->start_date,
                    'end_date' => $request->end_date,
               
                );
                try 
                {

                    $cdr_report = Helper::PostApi($url, $body);
                    //echo'<pre>';print_r($cdr_report); exit;
                    if ($cdr_report->success == 'true') {
                        $report = $cdr_report->data;
                        session()->flash("success", $cdr_report->message);
                        return view('ringless-voicemail.reports.call-data-report',compact('report','campaign_list','area_codes'));
                    }
                    if ($cdr_report->success == 'false') {
                        return redirect('/');
                    }
                } catch (BadResponseException $e)
                {
                    return back()->with('message', "Error code - (report): Oops something went wrong :( Please contact your administrator.)");
                } catch (RequestException $ex) 
                {
                    $message = "Page Not Found";
                    return redirect('/');
                }
         
    }

 }