<?php

namespace App\Http\Controllers\Ringless;
use Session;
use App\Helper\Helper;
use GuzzleHttp\Exception\BadResponseException;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\MessageBag;
use Illuminate\Support\Facades\Config;
use App\Http\Controllers\Controller;

class RinglessCampaignController extends Controller
{

    public function index()
    {
    $campaign_list = [];
    $errors = new MessageBag();
    $url = env('API_URL') . "ringless/campaign";
    try
    {
      $response = Helper::GetApi($url);
        //echo "<pre>";print_r($response);die;

                  // echo $url ; print_r($body); exit;

      if($response->success)
      {
        $campaign_list = $response->data;
      }
      else
      {
        foreach ($response->errors as $key => $message)
        {
          $errors->add($key, $message);
        }
      }
    }

    catch(RequestException $ex)
    {
      $errors->add("error", $ex->getMessage());
      return view("ringless-voicemail.ringless-campaign.list", compact("errors", $errors));
    }
        
       return view('ringless-voicemail.ringless-campaign.list', compact('campaign_list'));
    }
  
    public function storeCampaign(Request $request)
    {


        $templete_list = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "ringless-ivr";
        try
        {
            $response = Helper::PostApi($url);

           //echo "<pre>";print_r($response);die;
            if($response->success)
            {
                $templete_list = $response->data;
            }
            else
            {
                $templete_list = [];
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch(RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("voice-templete.list", compact("errors", $errors));
        }

        $gateway_list = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "sip-gateways";
        try
        {
            $response = Helper::GetApi($url);

         //  echo "<pre>";print_r($response);die;
            if($response->success)
            {
                $gateway_list = $response->data;
            }
            else
            {
                $gateway_list = [];
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch(RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("voice-templete.list", compact("errors", $errors));
        }


        /* Phone Country list */
        $list = [];
        $url = env('API_URL').'country-list';
        try
        {
            $response = Helper::PostApi($url);
            if ($response->success)
            {
                $phone_country = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }

        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
        }
        $extension_list = [];
            $did_list = []; // checking empty record
            $url = env('API_URL') . 'active-extension-group-list';
            try
            {
                $response = Helper::PostApi($url);
                $extension_list= $response;
            }
            catch (RequestException $ex)
            {
                $errors->add("error", $ex->getMessage());
            }
            $url = env('API_URL') . 'did';
            $body = array(
                'id' => Session::get('id'),
                'token' => Session::get('tokenId'),
            );
            // echo $url ; print_r($body); exit;
            try {
                $did = Helper::PostApi($url, $body);
                if($did->success)
                    {
                        $did_list = $did->data;
                    }
                    else
                    {
                        foreach ($did->errors as $key => $message)
                        {
                        $errors->add($key, $message);
                        }
                    }
                    }

                    catch(RequestException $ex)
                    {
                    $errors->add("error", $ex->getMessage());
                    return view("ringless-voicemail.ringless-campaign.list", compact("errors", $errors));
                    }
        
        return view('ringless-voicemail.ringless-campaign.add', compact('extension_list', 'did_list','phone_country','templete_list','gateway_list'));
    }
    
    public function postStoreCampaign(Request $request)
    {
        $body = array(
          
            'title' => $request->title,
            'description' => $request->description,
            'status' => $request->status,
            'caller_id' => $request->caller_id,
            'custom_caller_id' => $request->custom_caller_id,
            'time_based_calling' => $request->time_based_calling,
            'call_time_start' => $request->call_time_start,
            'call_time_end' => $request->call_time_end,
            'call_ratio'=>$request->call_ratio,
            'call_duration'=>$request->call_duration,
            'country_code'=>$request->country_code,
            'voice_template_id'=>$request->voice_template_id,
            'sip_gateway_id'=>$request->sip_gateway_id
            
        );
    
        $url = env('API_URL') . 'ringless/campaign/add';
        
        try {
            $addcampaign = Helper::PostApi($url, $body);
            //echo "<pre>";print_r($addcampaign);die;
            if ($addcampaign->success == 'true') {
                return redirect('ringless-campaigns')->withSuccess($addcampaign->message);
            }
            
            if ($addcampaign->success == 'false') {
                return back()->withSuccess($addcampaign->message);
            }
        } catch (BadResponseException $e) {
            return back()->with('message', "Error code - (add-campaign): Oops something went wrong :( Please contact your administrator.)");
        } catch (RequestException $ex) {
            return back()->with('message', "Error code - (add-campaign): Oops something went wrong :( Please contact your administrator.)");
        }
    }
    
    
    public function showEditCampaign(int $campaignId)
    {
        $did_list = []; // checking empty record
        $campaign_list=[];
        $extension_list = [];
        $url = env('API_URL') . 'active-extension-group-list';
            try
            {
                $response = Helper::PostApi($url);
                $extension_list= $response;
            }
            catch (RequestException $ex)
            {
                $errors->add("error", $ex->getMessage());
            }
        $url = env('API_URL') . 'did';
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
        );
        // echo $url ; print_r($body); exit;
        try {
            $did = Helper::PostApi($url, $body);
            if($did->success)
                {
                    $did_list = $did->data;
                }
                else
                {
                    foreach ($did->errors as $key => $message)
                    {
                    $errors->add($key, $message);
                    }
                }
                }

                catch(RequestException $ex)
                {
                $errors->add("error", $ex->getMessage());
                return view("ringless-voicemail.ringless-campaign.list", compact("errors", $errors));
                }
        try {
            $url = env('API_URL') . 'ringless/campaign/show';
            $body = array(
                'campaign_id' => $campaignId
            );
            $response = Helper::PostApi($url, $body);
			//echo "<pre>";print_r($response);die;

            //if ($response->success == 'true') {
			if(!empty($response)){	
                $campaign_list = $response;
            } else {
               // foreach ($response->errors as $key => $message) {
                 //   $errors->add($key, $message);
               // }
                return redirect()->back()->withErrors($errors);
            }
        } catch (\Throwable $e) {
            $errors->add("error", $e->getMessage());
            return redirect()->back()->withErrors($errors);
        }
       
       
        
        $no_of_campaign_list = [];
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'campaign_id' => $campaignId,
            'is_deleted' => '0'
        );

        $errors = new MessageBag();
        $url = env('API_URL') . "ringless/campaign-list";

        try
        {

                    $response = Helper::PostApi($url, $body);

           // echo "<pre>";print_r($response);die;
            if($response)
            {
                $no_of_campaign_list = $response;
            }
            else
            {
                $no_of_campaign_list = [];
                if (is_object($response)) {
                    foreach ($response->errors as $key => $message) {
                        $errors->add($key, $message);
                    }
                } else {
                    // Handle other cases where $response is not an object (e.g., empty response)
                    $errors->add("error", "Unexpected response format");
                }
            }
        }
        catch(RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("ringless-voicemail.ringless-campaign.edit", compact("errors", $errors));
        }

           /* Phone Country list */
           $list = [];
           $url = env('API_URL').'country-list';
           try
           {
               $response = Helper::PostApi($url);
               if ($response->success)
               {
                   $phone_country = $response->data;
               }
               else
               {
                   foreach ( $response->errors as $key => $message )
                   {
                       $errors->add($key, $message);
                   }
               }
           }
   
           catch (RequestException $ex)
           {
               $errors->add("error", $ex->getMessage());
           }


        $templete_list = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "ringless-ivr";
        try
        {
            $response = Helper::PostApi($url);

           // echo "<pre>";print_r($response);die;
            if($response->success)
            {
                $templete_list = $response->data;
            }
            else
            {
                $templete_list = [];
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch(RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("voice-templete.list", compact("errors", $errors));
        }

        $gateway_list = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "sip-gateways";
        try
        {
            $response = Helper::GetApi($url);

         //  echo "<pre>";print_r($response);die;
            if($response->success)
            {
                $gateway_list = $response->data;
            }
            else
            {
                $gateway_list = [];
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch(RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("voice-templete.list", compact("errors", $errors));
        }




        return view('ringless-voicemail.ringless-campaign.edit', compact('extension_list','did_list','campaign_list','no_of_campaign_list','phone_country','templete_list','gateway_list'));
    }
    function editCampaign(Request $request)
    {

        $call_time_start = explode(":", $request->call_time_start);

        $start_time = $call_time_start[0] . ':' . $call_time_start[1];

        $call_time_end = explode(":", $request->call_time_end);

        $end_time = $call_time_end[0] . ':' . $call_time_end[1];

        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'campaign_id' => $request->campaign_id,
            'title' => $request->title,
            'description' => $request->description,
            'status' => $request->status,
            'caller_id' => $request->caller_id,
            'custom_caller_id' => $request->custom_caller_id,
            'time_based_calling' => $request->time_based_calling,
            'call_time_start' => $start_time,//'09:30',//$request->call_time_start,
            'call_time_end' => $end_time,//'09:30', //$request->call_time_end,
                  'call_ratio'=>$request->call_ratio,
            'call_duration'=>$request->call_duration,
            'country_code'=>$request->country_code,
             'voice_template_id'=>$request->voice_template_id,
            'sip_gateway_id'=>$request->sip_gateway_id
            
            
        );
            //echo "<pre>";print_r($body);die;

        $url = env('API_URL') . 'ringless/campaign/edit';

        
        
        try {
            $addcampaign = Helper::PostApi($url, $body);
            //echo "<pre>";print_r($addcampaign);die;
            if ($addcampaign->success == 'true') {
                return back()->withSuccess($addcampaign->message);
            }

            if ($addcampaign->success == 'false') {
                return back()->withSuccess($addcampaign->message);
            }
        } catch (BadResponseException   $e) {
            return back()->with('message', "Error code - (edit-campaign-disposition): Oops something went wrong :( Please contact your administrator.)");
        } catch (RequestException $ex) {
            return back()->with('message', "Error code - (edit-campaign-disposition): Oops something went wrong :( Please contact your administrator.)");
        }
    }
    function deleteCampaign($campaign_id)
    {
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'campaign_id' => $campaign_id,
            'is_deleted' => '1'
        );

        // echo "<pre>";print_r($body);die;

        $url = env('API_URL') . 'ringless/campaign/delete';
        // echo "<pre>";print_r($body);die;

        try {
            $ringless_campaign = Helper::PostApi($url, $body);
            //echo "<pre>";print_r($ringless_campaign);die;

            if ($ringless_campaign->success == 'true') {
        
                return back()->withSuccess($ringless_campaign->message);
            }

            if ($ringless_campaign->success == 'false') {
                return back()->withError($ringless_campaign->message);
            }
        } catch (BadResponseException   $e) {
            return back()->with('message', "Error code - (edit-campaign): Oops something went wrong :( Please contact your administrator.)");
        } catch (RequestException $ex) {
            return back()->with('message', "Error code - (edit-campaign): Oops something went wrong :( Please contact your administrator.)");
        }
    }
    public function updateCampaignStatus($id = "", $status = "")
    {
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'listId' => $id,
            'status' => $status,
        );

        $url = env('API_URL') . 'ringless/campaign/update-status';
        try
        {
            $update_list = Helper::PostApi($url, $body);
            Log::debug('API Response', ['response' => $update_list]);
            if ($update_list->success == 'true')
            {
                //return redirect('/list')->withSuccess($delete_list->message);
                echo json_encode(array('status' => "true", 'message' => $update_list->message));
            }
            if ($update_list->success == 'false') {
                //return redirect('/list')->withSuccess($delete_list->message);
                echo json_encode(array('status' => "false", 'message' => $update_list->message));
            }
        } catch (BadResponseException $e) {
            return back()->with('message', "Error code - (edit-list): Oops something went wrong :( Please contact your administrator.)");
        }
    }
    public function copyCampaign(Request $request)
    {
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'c_id' => $request->id
        );
        $url = env('API_URL') . 'ringless/campaign/copy';

        try {
            $copyCampaign = Helper::PostApi($url, $body);
            //echo "<pre>";print_r($copyCampaign);die;

            if ($copyCampaign->success == 'true') {
                return redirect('ringless-campaigns')->withSuccess($copyCampaign->message);
            }

            if ($addcampaign->success == 'false') {
                return back()->withSuccess($copyCampaign->message);
            }
        } catch (BadResponseException   $e) {
            return back()->with('message', "Error code - (copy-campaign): Oops something went wrong :( Please contact your administrator.)");
        } catch (RequestException $ex) {

            return back()->with('message', "Error code - (copy-campaign): Oops something went wrong :( Please contact your administrator.)");
        }

    }
 }