<?php

namespace App\Http\Controllers\Ringless;
use Session;
use App\Helper\Helper;
use GuzzleHttp\Exception\BadResponseException;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\MessageBag;
use Illuminate\Support\Facades\Config;
use App\Http\Controllers\Controller;
use App\Http\Controllers\InheritApiController;

class RinglessListController extends Controller
{
    public function list()
    {

        $campaign_list = [];
        $url = env('API_URL').'ringless/campaign';
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                $campaign_list = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }

        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
        }
        $list_data = [];
        $url = env('API_URL').'ringless/lists';
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success)
            {
                $list_data = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }

        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
        }
        return view('ringless-voicemail.lists.list', compact('list_data','campaign_list'));

    }

    private function getBuildBody(Request $request)
    {
        $body = [
            "title" => trim(ucwords($request->get("title"))),
            'campaign_id'=> $request->get("campaign_id"),
            'file_name'=> $request->get("file_name")
        ];

        return $body;
    }

    public function create(Request $request)
    {

        $file = $request->file('list_file');
        $extension = $file->getClientOriginalExtension(); // getting image extension
        $filename = Session::get('id') . time() . '.' . $extension;
        $rootPath = env("RINGLESS_LIST_FILE_UPLOAD_PATH", "/var/www/html/api/upload/");
        $file->move($rootPath, $filename);


            $request['file_name'] = $filename;
            try {
            $url = env('API_URL') . 'ringless/list/add';
            $response = Helper::RequestApi($url, "PUT", $this->getBuildBody($request), "json");
           // echo "<pre>";print_r($response);die;
            if ($response->success) {

                $list_id = $response->list_id;
                    $campaign_id = $response->campaign_id;
                session()->flash("success", "Ringless List created");
                return redirect('ringless/list/edit/' . $list_id . '/' . $campaign_id);
            } else {
                foreach ( $response->errors as $key => $messages ) {
                    if (is_array($messages)) {
                        foreach ( $messages as $index => $message )
                            $errors->add("$key.$index", $message);
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return redirect()->back()->withInput()->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput()->withErrors($errors);
        }
       
       

      
    }

    public function show(Request $request, int $id)
    {
        $inherit_label = new InheritApiController;
        $label = $inherit_label->getLabel();
        usort($label, function ($a, $b) {
            return strcasecmp($a->title, $b->title);
        });
        $campaign_list = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "ringless/campaign";
        try
        {
          $response = Helper::GetApi($url);
           // echo "<pre>";print_r($response);die;

          if($response->success)
          {
            $campaign_list = $response->data;
          }
          else
          {
            foreach ($response->errors as $key => $message)
            {
              $errors->add($key, $message);
            }
          }
        }
    
        catch(RequestException $ex)
        {
          $errors->add("error", $ex->getMessage());
          return view("ringless-voicemail.lists.list", compact("errors", $errors));
        }

        $lists = null;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "ringless/list/view/$id";
            $response = Helper::GetApi($url, [], true);
            //echo "<pre>";print_r($response);die;
            if ($response["success"]) {
                $lists = $response["data"];

           // echo "<pre>";print_r($lists);die;

            } else {
                foreach ( $response["errors"] as $key => $message ) {
                    $errors->add($key, $message);
                }
                return view("tariff_plans.edit-tariff-values")->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("ringless-voicemail.campaign.add")->withErrors($errors);
        }



       
    
                    return view('ringless-voicemail.lists.edit-list', compact('lists', 'label', 'campaign_list'));
    }

    public function update(Request $request, int $list_id)
    {
        $is_dialing ='1';
        $size = sizeof($request->id);

        if (!empty($request->id)) {
                $id = $request->id;
                if (!empty(sizeof($id))) {
                    for ($i = 0; $i < $size; $i++) {
                        if (!empty($request->is_dialing)) {
                            $is_dialing = $request->is_dialing;
                            if ($is_dialing == $id[$i]) {
                                $edit_list[$i]['is_dialing'] = 1;
                            } else {
                                $edit_list[$i]['is_dialing'] = 0;
                            }
                            $edit_list[$i]['column_name'] = $request->column_name[$i];
                        }
                        $edit_list[$i]['id'] = $id[$i];
                    }
                }
            }
            
            if (!empty($request->label_id)) {
                $label_id = $request->label_id;
                //echo sizeof($is_search);die;
                for ($i = 0; $i < $size; $i++) {

                    if (empty($label_id[$i])) {
                        $edit_list[$i]['label_id'] = 0;
                    } else {
                        $edit_list[$i]['label_id'] = $label_id[$i];
                    }
                }
            }
            
          

           

            $body = array(
                'title' => $request->title,
                'list_id' => $list_id,
                'campaign_id' => $request->campaign_id,
                'list_header' => $edit_list,

            );


      //echo "<pre>";print_r($body);die;


             $errors = new MessageBag();
    try
    {
     $url = env('API_URL') . "ringless/list/update/$list_id";

                $response = Helper::PostApi($url, $body);


      //echo "<pre>";print_r($response);die;
      
      if ($response->success)
      {
        session()->flash("success", "Ringless List Updated");
                return redirect("ringless-lists");

        
      }
      else
      {
        foreach ($response->errors as $key => $messages)
        {
          if (is_array($messages))
          {
            foreach ($messages as $index => $message)
              $errors->add("$key.$index", $message);
          }
          else
          {
            $errors->add($key, $messages);
          }
        }
        return redirect()->back()->withInput($request->input())->withErrors($errors);
      }
    }
    catch (RequestException $ex)
    {
      $errors->add("error", $ex->getMessage());
      return redirect()->back()->withInput($request->input())->withErrors($errors);
    }
        session()->flash("success", "Ringless List Updated");
    
    return redirect()->back();



   
  }






   public function updateStatus($id = "", $status = "")
    {
        $body = array(
            
            'listId' => $id,
            'status' => $status,
        );

        $url = env('API_URL') . 'ringless/list/update-status';
        try
        {
            $delete_list = Helper::PostApi($url, $body);
            if ($delete_list->success == 'true')
            {
                //return redirect('/list')->withSuccess($delete_list->message);
                echo json_encode(array('status' => "true", 'message' => $delete_list->message));
            }
            if ($delete_list->success == 'false') {
                //return redirect('/list')->withSuccess($delete_list->message);
                echo json_encode(array('status' => "false", 'message' => $delete_list->message));
            }
        } catch (RequestException $ex)
    {
      $errors->add("error", $ex->getMessage());
      return redirect()->back()->withInput($request->input())->withErrors($errors);
    }
    }


     public function delete(Request $request, int $id)
  {
        $custom_field_labels = null;
        $errors = new MessageBag();
        try
        {
            $url = env('API_URL') . "ringless/list/delete/$id";
            $response = Helper::GetApi($url, [], true);
          //  echo "<pre>";print_r($response);die;
            if ($response["success"])
            {
                $custom_field_labels = $response["data"];
            }
            else
            {
                foreach ($response->errors as $key => $messages)
                {
                    if (is_array($messages))
                    {
                        foreach ($messages as $index => $message)
                            $errors->add("$key.$index", $message);
                    }
                    else
                    {
                        $errors->add($key, $messages);
                    }
                }
                return view("tariff_plans.edit-tariff-values")->withErrors($errors);
                
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("tariff_plans.edit-tariff-values")->withErrors($errors);
        }
        return $response;
  }
  public function recycle(Request $request, int $id)
  {
        $recycle = null;
        $errors = new MessageBag();
        try
        {
            $url = env('API_URL') . "ringless/list/recycle/$id";
            $response = Helper::GetApi($url, [], true);
          // echo "<pre>";print_r($response);die;
            if ($response["success"])
            {
                $recycle = $response["data"];
            }
            else
            {
                foreach ($response->errors as $key => $messages)
                {
                    if (is_array($messages))
                    {
                        foreach ($messages as $index => $message)
                            $errors->add("$key.$index", $message);
                    }
                    else
                    {
                        $errors->add($key, $messages);
                    }
                }
                return view("ringless-voicemail.lists.list")->withErrors($errors);
                
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("ringless-voicemail.lists.list")->withErrors($errors);
        }
        return $response;
  }
 }