<?php

namespace App\Http\Controllers\Ringless;
use App\Http\Controllers\Controller;

use App\Helper\Helper;
use Illuminate\Support\MessageBag;
use Session;
use Illuminate\Http\Request;
use App\Http\Controllers\InheritApiController;
use Carbon\Carbon;
class RinglessWalletController extends Controller
{
    
    function getWalletTransactions()
    {

        $walletTransactions = NULL;
        $errors = new MessageBag();
        $url = env('API_URL') . 'ringless/wallet/transactions';
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $walletTransactions = $response->data;
            } else {
                $errors->add("error", $response->message);
                return view("ringless-voicemail.billing.wallet-transactions", compact("errors", $errors));
            }
        } catch (\Throwable $ex) {
            $errors->add("error", $ex->getMessage());
            return view("ringless-voicemail.billing.wallet-transactions", compact("errors", $errors));
        }
        return view("ringless-voicemail.billing.wallet-transactions", compact("walletTransactions"));
    }
    function getWalletAmount()
    {

        $walletAmount = NULL;
        $errors = new MessageBag();
        $url = env('API_URL') . 'ringless/wallet/amount';
        try {
            $response = Helper::GetApi($url);
            
            if ($response->success) {
                $walletAmount = $response->data;
                //echo "<pre>";print_r($walletAmount);die;
            } else {
                $errors->add("error", $response->message);
                return view("ringless-voicemail.billing.wallet-amount", compact("errors", $errors));
            }
        } catch (\Throwable $ex) {
            $errors->add("error", $ex->getMessage());
            return view("ringless-voicemail.billing.wallet-amount", compact("errors", $errors));
        }
        return view("ringless-voicemail.billing.wallet-amount", compact("walletAmount"));
    }
}
