<?php

namespace App\Http\Controllers\Ringless;
use App\Http\Controllers\Controller;

use App\Helper\Helper;
use Illuminate\Support\MessageBag;
use Session;
use Illuminate\Http\Request;
use App\Http\Controllers\InheritApiController;
use Carbon\Carbon;
class RvmCdrLogController extends Controller
{
    public function index(Request $request)
{
    $errors = new MessageBag();

    // Fetch ringless voicemail drop data
    $ringless_voicemail_drop = [];
    try {
        $response = Helper::GetApi(env('API_URL') . "ringless-voicemail-drop-log");
        if ($response->success) {
            $ringless_voicemail_drop = $response->data;
        } else {
            foreach ($response->errors as $key => $message) {
                $errors->add($key, $message);
            }
        }
    } catch (RequestException $ex) {
        $errors->add("error", $ex->getMessage());
        return view("ringless-voicemail.reports.call-data-report", compact("errors"));
    }

    // Fetch SIP gateways
    $sip_gateways = [];
    try {
        $response = Helper::GetApi(env('API_URL') . "sip-gateways");
        if ($response->success) {
            $sip_gateways = $response->data;
        } else {
            foreach ($response->errors as $key => $message) {
                $errors->add($key, $message);
            }
        }
    } catch (RequestException $ex) {
        $errors->add("error", $ex->getMessage());
        return view("ringless-voicemail.reports.call-data-report", compact("errors"));
    }

    // Fetch campaigns
    $campaign_list = [];
    try {
        $response = Helper::GetApi(env('API_URL') . "ringless/campaign");
        if ($response->success) {
            $campaign_list = $response->data;
        } else {
            foreach ($response->errors as $key => $message) {
                $errors->add($key, $message);
            }
        }
    } catch (RequestException $ex) {
        $errors->add("error", $ex->getMessage());
        return view("ringless-voicemail.reports.call-data-report", compact("errors"));
    }

    // Pagination logic
    $show = $request->input('show', 10);
    $urlpage = $request->input('page', 1);
    $page = $urlpage;
    $upper_limit = ($show == 25 || $show == 50 || $show == 100) ? $show : 10;
    $lower_limit = ($urlpage > 1) ? ($urlpage - 1) * $upper_limit : 0;

    // Filter body
    $body = [
        'start_date'   => $request->start_date,
        'end_date'     => $request->end_date,
        'id'           => Session::get('id'),
        'status'       => $request->status,
        'cli'          => $request->cli,
        'phone'        => $request->phone_number,
        'lower_limit'  => $lower_limit,
        'upper_limit'  => $upper_limit,
    ];

    // Fetch filtered log report
    $report = [];
    $record_count = 0;
    try {
        $response = Helper::PostApi(env('API_URL') . "rvm-cdr-log", $body);
        if ($response->success) {
            $report = $response->data ?? [];
            $record_count = $response->recordCount ?? 0;
        } else {
            foreach ($response->errors as $key => $msg) {
                $errors->add($key, $msg);
            }
            return view("ringless-voicemail.reports.cdr-log", compact("errors"));
        }
    } catch (RequestException $ex) {
        $errors->add("error", $ex->getMessage());
        return view("ringless-voicemail.reports.cdr-log", compact("errors"));
    }

    // Return final view with all merged data
    return view("ringless-voicemail.reports.cdr-log", compact(
        "campaign_list",
        "sip_gateways",
        "ringless_voicemail_drop",
        "report",
        "record_count",
        "lower_limit",
        "upper_limit",
        "show",
        "page"
    ));
}


}
