<?php

namespace App\Http\Controllers;

namespace App\Http\Controllers;

use App\Helper\Helper;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Session;
use Illuminate\Support\Facades\Log;

class ScheduleController extends Controller
{
    public function index()
{
    $client_id = Session::get('parentId');
    $url = env('API_URL') . "schedule?client_id=" . $client_id;
    
    // echo "<pre>";print_r($body);die;
    $sched_res = Helper::GetApi($url);

    return view('calender.schedule',compact('sched_res'));
}
public function store(Request $request){
    $event=[];

    $url = env('API_URL') . "save-schedule";
    $body = array(
        'user_id' => Session::get('id'),
        'client_id' => Session::get('parentId'),

       'id'=>$request->id,
        'title' => $request->title,    
        'description' => $request->description,
        'start_datetime' => $request->start_date . ' ' . $request->start_time,
        'end_datetime' => $request->end_date . ' ' . $request->end_time,

    );
    $event = Helper::PostApi($url,$body);
    //echo "<pre>";print_r($event);die;
    return redirect('/schedule')->withSuccess($event->message);

 
}
public function deleteSchedule($id){
    $url = env('API_URL') . 'schedule/delete-schedule';
    // echo "<pre>";print_r($body);die;
    $body = array(
        'client_id' => Session::get('parentId'),
        'id' => Session::get('id'),
        'token' => Session::get('tokenId'),
        'event_id' => $id,
    
    );
    try {
        $event = Helper::PostApi($url,$body);
        //echo "<pre>";print_r($ext_group);die;
        if ($event->success == 'true') {
            // echo "<pre>";print_r($group);die;
            //return back()->withSuccess($event->message);
            return back()->withSuccess($event->message);
        }

        if ($event->success == 'false') {
            return redirect('/schedule');
            //return back()->withSuccess($ext_group->message);
        }
    } catch (BadResponseException   $e) {
        return back()->with('message', "Error code - (edit-campaign): Oops something went wrong :( Please contact your administrator.)");
    } catch (RequestException $ex) {
        return back()->with('message', "Error code - (edit-campaign): Oops something went wrong :( Please contact your administrator.)");
    }
 }
}


