<?php

namespace App\Http\Controllers;
use Session;
use App\Helper\Helper;
use Illuminate\Http\Request;
use GuzzleHttp\Exception\RequestException;
use App\Http\Controllers\InheritApiController;
use GuzzleHttp\Exception\BadResponseException;
use Illuminate\Support\MessageBag;
class SipGatewaysController extends Controller
{
  public function index()
  {
    $sip_gateways = [];
    $errors = new MessageBag();
    $url = env('API_URL') . "sip-gateways";
    try
    {
      $response = Helper::GetApi($url);
      if($response->success)
      {
        $sip_gateways = $response->data;
      }
      else
      {
        $custom_field_labels = [];
        foreach ($response->errors as $key => $message)
        {
          $errors->add($key, $message);
        }
      }
    }

    catch(RequestException $ex)
    {
      $errors->add("error", $ex->getMessage());
      return view("sip-gateways.list", compact("errors", $errors));
    }

    //echo "<pre>";print_r($sip_gateways);die;
    return view('sip-gateways.list',compact('sip_gateways'));
  }

  function add(Request $request)
  {

    return view("sip-gateways.add");

        /*$this->validate($request, [
            'client_name'      => 'required',
            "sip_trunk_provider"    => "required",
            "sip_trunk_name"          => "required",
            "sip_trunk_host"          => "required",
            "sip_trunk_password"          => "required",
            "sip_trunk_username"          => "required",

        ]);
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "tariff-label-value";
            $response = Helper::RequestApi($url, "PUT", $this->getBuildBody($request), "json");
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                session()->flash("success", "Tariff Label Values created");
                return redirect("tariff-label-values");
            } else {
                foreach ( $response->errors as $key => $messages ) {
                    if (is_array($messages)) {
                        foreach ( $messages as $index => $message )
                            $errors->add("$key.$index", $message);
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return redirect()->back()->withInput()->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput()->withErrors($errors);
        }*/
    }

  public function create(Request $request)
  {
    $this->validate($request, [
            'client_name'      => 'required',
            "sip_trunk_provider"    => "required",
            "sip_trunk_name"          => "required",
            "sip_trunk_host"          => "required",
            "sip_trunk_password"          => "required",
            "sip_trunk_username"          => "required",

        ]);
        $errors = new MessageBag();

        //dd($request);

   
      try
      {
        $url = env('API_URL') . "sip-gateway";
        $response = Helper::RequestApi($url, "PUT", $this->getBuildBody($request), "json");
        //echo "<pre>";print_r($response);die;
        if ($response->success)
        {
          session()->flash("success", "SIP Gateway added");
          return redirect("sip-gateways");
        }

        else
        {
          foreach ($response->errors as $key => $messages)
          {
            if (is_array($messages))
            {
              foreach ($messages as $index => $message)
                $errors->add("$key.$index", $message);
            }
            else
            {
              $errors->add($key, $messages);
            }
          }
          return redirect()->back()->withInput()->withErrors($errors);
        }
      }
      catch (RequestException $ex)
      {
        $errors->add("error", $ex->getMessage());
        return redirect()->back()->withInput()->withErrors($errors);
      }
  }
  function edit(Request $request,$id)
  {
    $sip_gateways = [];
    $errors = new MessageBag();
    $url = env('API_URL') . "sip-gateways/{$id}";
    try
    {
      $response = Helper::GetApi($url);
      if($response->success)
      {
        $sip_gateways = $response->data;
      }
      else
      {
        $custom_field_labels = [];
        foreach ($response->errors as $key => $message)
        {
          $errors->add($key, $message);
        }
      }
    }

    catch(RequestException $ex)
    {
      $errors->add("error", $ex->getMessage());
      return view("sip-gateways.edit", compact("errors", $errors));
    }
    return view("sip-gateways.edit",compact('sip_gateways'));
  }
  function saveEdit(Request $request,$id)
  {
    $this->validate($request, [
      'client_name'      => 'required',
      "sip_trunk_provider"    => "required",
      "sip_trunk_name"          => "required",
      "sip_trunk_host"          => "required",
      "sip_trunk_password"          => "required",
      "sip_trunk_username"          => "required",

  ]);
  $errors = new MessageBag();

  //dd($request);
  $body=[
    "id"=>Session::get('id'),
    "token"=>Session::get('token'),
    "sip_id"=>$id,
    "client_name" => trim(($request->get("client_name"))),
    'sip_trunk_provider'=> trim(($request->get("sip_trunk_provider"))),
    'sip_trunk_name'=> trim(($request->get("sip_trunk_name"))),
    'sip_trunk_host'=> trim(($request->get("sip_trunk_host"))),
    'sip_trunk_password'=> trim(($request->get("sip_trunk_password"))),
    'sip_trunk_username'=> trim(($request->get("sip_trunk_username"))),
  ];


try
{
  $url = env('API_URL') . "update-sip-gateways";
  $response = Helper::RequestApi($url, "POST", $body, "json");
  //echo "<pre>";print_r($response);die;
  if ($response->success)
  {
    session()->flash("success", "SIP Gateway updated");
    return redirect("sip-gateways");
  }

  else
  {
    foreach ($response->errors as $key => $messages)
    {
      if (is_array($messages))
      {
        foreach ($messages as $index => $message)
          $errors->add("$key.$index", $message);
      }
      else
      {
        $errors->add($key, $messages);
      }
    }
    return redirect()->back()->withInput()->withErrors($errors);
  }
}
catch (RequestException $ex)
{
  $errors->add("error", $ex->getMessage());
  return redirect()->back()->withInput()->withErrors($errors);
}
  }
  public function show(Request $request, int $id)
  {
    $tariff_label = null;
    $errors = new MessageBag();
    try
    {
      $url = env('API_URL') . "tariff-plan/$id";
      $response = Helper::GetApi($url, [], true);
      if ($response["success"])
      {
        $tariff_label = $response["data"];
      }
      else
      {
        foreach ($response->errors as $key => $messages)
        {
          if (is_array($messages))
          {
            foreach ($messages as $index => $message)
              $errors->add("$key.$index", $message);
          }
          else
          {
            $errors->add($key, $messages);
          }
        }
        return view("tariff_plans.tariff_labels")->withErrors($errors);
      }
    }
    catch (RequestException $ex)
    {
      $errors->add("error", $ex->getMessage());
      return view("tariff_plans.tariff_labels")->withErrors($errors);
    }
    return $tariff_label;
  }

  public function update(Request $request, int $id)
  {
    $this->validate($request, ['title' => 'required|string|max:255','description' =>'required|string|max:255' ]);
    $errors = new MessageBag();
    try
    {
      $url = env('API_URL') . "tariff-plan/$id";
      $response = Helper::PostApi($url, $this->getBuildBody($request));
      if ($response->success)
      {
        session()->flash("success", "Custom Field Label Updated");
        return redirect("tariff-labels");
      }
      else
      {
        foreach ($response->errors as $key => $messages)
        {
          if (is_array($messages))
          {
            foreach ($messages as $index => $message)
              $errors->add("$key.$index", $message);
          }
          else
          {
            $errors->add($key, $messages);
          }
        }
        return redirect()->back()->withInput($request->input())->withErrors($errors);
      }
    }
    catch (RequestException $ex)
    {
      $errors->add("error", $ex->getMessage());
      return redirect()->back()->withInput($request->input())->withErrors($errors);
    }
    session()->flash("success", "Tariff Label updated");
    return redirect()->back();
  }

  private function getBuildBody(Request $request)
  {
    $body = [
      "client_name" => trim(ucwords($request->get("client_name"))),
      'sip_trunk_provider'=> trim(($request->get("sip_trunk_provider"))),
      'sip_trunk_name'=> trim(($request->get("sip_trunk_name"))),
      'sip_trunk_host'=> trim(($request->get("sip_trunk_host"))),
      'sip_trunk_password'=> trim(($request->get("sip_trunk_password"))),
      'sip_trunk_username'=> trim(($request->get("sip_trunk_username"))),
    ];

      
    return $body;
  }


  public function delete(Request $request, int $id)
  {
      $errors = new MessageBag();
  
      try {
          $url = env('API_URL') . "sip-gateway-delete/$id";
          $response = Helper::GetApi($url, [], true);
  
          // Check if response contains 'success' and 'message'
          if (isset($response['success']) && $response['success']) {
              // Handle successful response
              return response()->json([
                  'success' => true,
                  'message' => 'SIP Gateway deleted successfully.',
                  'data' => $response['data'] ?? null
              ]);
          } else {
              // Handle errors in the response
              $errorMessages = [];
  
              if (isset($response['message'])) {
                  // Add the error message from response
                  $errorMessages[] = $response['message'];
              }
  
              if (isset($response['errors']) && is_array($response['errors'])) {
                  foreach ($response['errors'] as $key => $messages) {
                      if (is_array($messages)) {
                          foreach ($messages as $index => $message) {
                              $errorMessages[] = "$key.$index: $message";
                          }
                      } else {
                          $errorMessages[] = "$key: $messages";
                      }
                  }
              }
  
              return response()->json([
                  'success' => false,
                  'message' => $errorMessages,
                  'errors' => $errorMessages
              ], 400);
          }
      } catch (RequestException $ex) {
          // Handle exceptions
          return response()->json([
              'success' => false,
              'message' => 'An error occurred: ' . $ex->getMessage()
          ], 500);
      }
  }
  
  
}

