<?php

namespace App\Http\Controllers\Sip_trunk;
use App\Http\Controllers\Controller;

use App\Helper\Helper;
use Illuminate\Support\MessageBag;
use Session;
use Illuminate\Http\Request;
use App\Http\Controllers\InheritApiController;
use Carbon\Carbon;
class TrunkingCallReportController extends Controller
{
    public function index()
    {
        $errors = new MessageBag();
        $connection_list=[];
        $url = env('API_URL') . 'trunking/connections';
        
        $response = Helper::GetApi($url);
        try {
            if ($response && !empty($response->data)) {
                $connection_list = $response->data;
                //echo "<pre>";print_r($response);die;

            } else {
              
                session()->flash('error', 'No data available for the connection.');
            }
            //  echo "<pre>";print_r($connection_list);die;
            
        } catch (Exception $e) {
            return response()->json("Something went wrong!!", 500);
        }
        $tags=[];
        $url = env('API_URL') . 'trunking/tags';
        
        try {
            $response = Helper::GetApi($url);
            // $tags=  $response->data;
            // echo "<pre>";print_r($response);die;
            
        } catch (Exception $e) {
            return response()->json("Something went wrong!!", 500);
        }
        $billing_group=[];
        $url = env('API_URL') . 'trunking/billing_group';
        
        $response = Helper::GetApi($url);
        try {
            // echo "<pre>";print_r($billing_group);die;
            if ($response && !empty($response->data)) {
                $billing_group=  $response->data;
                //echo "<pre>";print_r($response);die;

            } else {
              
                session()->flash('error', 'No data available for the billing group.');
            }
            
        } catch (Exception $e) {
            return response()->json("Something went wrong!!", 500);
        }
            return view("sip-trunk.call-report",compact('connection_list','tags','billing_group'));
    }
    public function getReport(Request $request)
    {
       
        $errors = new MessageBag();

        $inherit_label = new InheritApiController;
        $userdetails = $inherit_label->headerUserDetails();

       $timezone= $userdetails->data->timezone;
       $tags=[];
       $report = [];

       $url = env('API_URL') . 'trunking/tags';
       
       try {
           $response = Helper::GetApi($url);
           // $tags=  $response->data;
           // echo "<pre>";print_r($response);die;
           
       } catch (Exception $e) {
           return response()->json("Something went wrong!!", 500);
       }
       $billing_group=[];
       $url = env('API_URL') . 'trunking/billing_group';
       
       $response = Helper::GetApi($url);
       try {
         
           if ($response && !empty($response->data)) {
            $billing_group=  $response->data;
            //echo "<pre>";print_r($response);die;

        } else {
          
            session()->flash('error', 'No data available for the billing group.');
        }
           // echo "<pre>";print_r($billing_group);die;
           
       } catch (Exception $e) {
           return response()->json("Something went wrong!!", 500);
       }
       //dd($timezone);
        $connection_list=[];
        $url = env('API_URL') . 'trunking/connections';
        
        $response = Helper::GetApi($url);
        try {
            //  echo "<pre>";print_r($response);die;
            if ($response && !empty($response->data)) {
                $connection_list = $response->data;
                //echo "<pre>";print_r($response);die;

            } else {
              
                session()->flash('error', 'No data available for the connection.');
            }
            
        } catch (Exception $e) {
            return response()->json("Something went wrong!!", 500);
        }
        $start_date=$request->start_date;
        $end_date=$request->end_date;
        // Create Carbon instances and set the timezone
        $start_date_with_timezone = Carbon::parse($start_date)->setTimezone($timezone);
        $end_date_with_timezone = Carbon::parse($end_date)->setTimezone($timezone);

       // Format the dates as ISO with timezone
       $formatted_start_date = $start_date_with_timezone->toISOString();
       $formatted_end_date = $end_date_with_timezone->toISOString();
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'aggregation_type'=>$request->aggregation_type,
            'product_breakdown'=>$request->product_breakdown,
            'connections'=>$request->connections,
            'tags'=>$request->tag,
            'billing_group'=>$request->billing_group,
            'direction'=>$request->direction,
            'start_date'=>$formatted_start_date,
            'end_date'=>$formatted_end_date

        );
        $url = env('API_URL') . 'trunking/report';
        
        $response = Helper::PostApi($url, $body);
                $download_url="";

                // echo "<pre>";print_r($download_url);die;
                try {
                    if ($response && !empty($response->result)) {
                $download_url=$response->report_url;
                $report = $response->result;
                //echo "<pre>";print_r($response);die;

            } else {
              
                session()->flash('error', 'No data available for the selected criteria.');
            }
        } 
        catch (Exception $e) 
        {
            return response()->json("Something went wrong!!", 500);
        }
        return view("sip-trunk.call-report",compact('report','connection_list','billing_group','tags','download_url'));

    }
}
