<?php

namespace App\Http\Controllers\Sip_trunk;
use App\Http\Controllers\Controller;

use App\Helper\Helper;
use Illuminate\Support\MessageBag;
use Session;
use Illuminate\Http\Request;
use App\Http\Controllers\InheritApiController;
use Carbon\Carbon;
class TrunkingPaymentMethodController extends Controller
{
    public function index()
    {
        $paymentMethods = $this->getPaymentMethods();
        
            return view("sip-trunk.payment-method",compact('paymentMethods'));
    }
    public function addPaymentMethod()
    {
        
            return view("sip-trunk.add-payment-method");
    }
    public function saveCard(Request $request) {
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'name' => $request->name,
            'line1' => $request->line1,
            'city' => $request->city,
            'state' => $request->state,
            'country' => $request->country,
            'postal_code' => $request->postal_code,
            'number' => $request->number,
            'exp_month' => $request->exp_month,
            'exp_year' => $request->exp_year,
            'cvc' => $request->cvc,
        );

        $url = env('API_URL') . 'trunking/stripe/save-card';
        $response = Helper::PostApi($url, $body);
        echo "<pre>";print_r($response);die;

        return response()->json($response);
    }
    public function getPaymentMethods() {
        $paymentMethods = [];
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId')
        );
        $url = env('API_URL') . 'trunking/stripe/get-customer-payment-method';
        $response = Helper::GetApi($url, $body);

        if ($response->success) {
            if($response->data[0] == NULL){
                return [];
            }
            $paymentMethods = (array)$response->data[0]->data;
        }
        return $paymentMethods;
    }
    public function updateCard(Request $request) {
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'payment_method_id' => $request->payment_method_id,
            'full_name' => $request->full_name,
            'line1' => $request->line1,
            'city' => $request->city,
            'state' => $request->state,
            'country' => $request->country,
            'postal_code' => $request->postal_code,
            'exp_month' => $request->exp_month,
            'exp_year' => $request->exp_year
        );

        $url = env('API_URL') . 'trunking/stripe/update-card';
        $response = Helper::PostApi($url, $body);
        return response()->json($response);
    }
    public function editPaymentMethod($id) {
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'payment_method_id' => $id
        );

        $url = env('API_URL') . 'trunking/stripe/get-payment-method';
        $response = Helper::PostApi($url, $body);

        if($response->success == 'true') {
            $pmDetails = $response->data[0];
            return view('sip-trunk.edit-payment-method', ['pmDetails' => $pmDetails]);
        }
        return redirect()->to('payment-method');
    }
    public function deletePaymentMethod($id) {
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'payment_method_id' => $id
        );

        $url = env('API_URL') . 'trunking/stripe/delete-stripe-payment_method';
        $response = Helper::PostApi($url, $body);
        return response()->json($response);
    }
    
}
