<?php

namespace App\Http\Controllers\Sip_trunk;
use App\Http\Controllers\Controller;

use App\Helper\Helper;
use Illuminate\Support\MessageBag;
use Session;
use Illuminate\Http\Request;
use App\Http\Controllers\InheritApiController;
use Carbon\Carbon;
class TrunkingRechargeController extends Controller
{
    public function index()
    {
        $paymentMethods = $this->getPaymentMethods(); 
        //echo "<pre>";print_r($paymentMethods);die;
       
            return view("sip-trunk.recharge",compact('paymentMethods'));
    }


    public function getPaymentMethods() {
        $paymentMethods = [];
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId')
        );
        $url = env('API_URL') . 'trunking/stripe/get-customer-payment-method';
        $response = Helper::GetApi($url, $body);

        if ($response->success) {
            if($response->data[0] == NULL){
                return [];
            }
            $paymentMethods = (array)$response->data[0]->data;
        }
        return $paymentMethods;
    }
    public function Recharge(Request $request) {
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'name' => $request->name,
            'line1' => $request->line1,
            'city' => $request->city,
            'state' => $request->state,
            'country' => $request->country,
            'postal_code' => $request->postal_code,
            'number' => $request->number,
            'exp_month' => $request->exp_month,
            'exp_year' => $request->exp_year,
            'cvc' => $request->cvc,
            'amount' => $request->amount,
            'payment_method' => $request->payment_method,
            'request_type' => $request->request_type
        );

        $url = env('API_URL') . 'trunking/stripe/recharge';
        $response = Helper::PostApi($url, $body);
        //echo "<pre>";print_r($response);die;

        return response()->json($response);
    }
 
}
