<?php

namespace App\Http\Controllers\Sip_trunk;
use App\Http\Controllers\Controller;

use App\Helper\Helper;
use Illuminate\Support\MessageBag;
use Session;
use Illuminate\Http\Request;
use App\Http\Controllers\InheritApiController;
use Carbon\Carbon;
class TrunkingWalletController extends Controller
{
    
    function getWalletTransactions()
    {

        $walletTransactions = NULL;
        $errors = new MessageBag();
        $url = env('API_URL') . 'trunking/wallet/transactions';
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $walletTransactions = $response->data;
            } else {
                $errors->add("error", $response->message);
                return view("sip-trunk.wallet-transactions", compact("errors", $errors));
            }
        } catch (\Throwable $ex) {
            $errors->add("error", $ex->getMessage());
            return view("sip-trunk.wallet-transactions", compact("errors", $errors));
        }
        return view("sip-trunk.wallet-transactions", compact("walletTransactions"));
    }
}
