<?php

namespace App\Http\Controllers\SmsAi;
use Session;
use App\Helper\Helper;
use GuzzleHttp\Exception\BadResponseException;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\MessageBag;
use Illuminate\Support\Facades\Config;
use App\Http\Controllers\Controller;
use App\Http\Controllers\InheritApiController;

class SmsAiCampaignController extends Controller
{
    public function list()
    {
        $campaign_list = [];
        $url = env('API_URL').'smsai/campaigns';
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                $campaign_list = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }

        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
        }
        return view('sms-ai.campaign.list', compact('campaign_list'));

    }

    private function getBuildBody(Request $request)
    {
        $body = [
            "title" => trim(ucwords($request->get("title"))),
            'description'=> $request->get("description"),
            'status'=>$request->get('status'),
            'caller_id'=>$request->get('caller_id'),
            'custom_caller_id'=>$request->get('custom_caller_id'),
            'time_based_calling'=>$request->get('time_based_calling'),
            'call_time_start'=>$request->get('call_time_start'),
            'sms_ai_template_id'=>$request->get('sms_ai_template_id'),
            'call_time_end'=>$request->get('call_time_end'),
            'call_ratio'=>$request->get('call_ratio'),
            'call_duration'=>$request->get('call_duration')
        ];

        return $body;
    }

    public function create(Request $request)
    {
        $extension_list = $this->getExtensionList();
        $inherit_list = new InheritApiController;
        $did_list = $inherit_list->getDidList();


         $templates = [];
        $url = env('API_URL').'smsai/templates';
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                $templates = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }

        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
        }

        /* Phone Country list */
        $list = [];
        $url = env('API_URL').'country-list';
        try
        {
            $response = Helper::PostApi($url);
            if ($response->success)
            {
                $phone_country = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }

        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
        }
    
        if (!is_array($did_list)) {
            $did_list = array(); // checking empty record
        }
    
       // return view('ringless-voicemail.ringless-campaign.add', compact('extension_list', 'did_list'));

        return view('sms-ai.campaign.add',compact('extension_list','phone_country','did_list','templates'));
    }

    function add(Request $request)
    {
        $this->validate($request, ['title'      => 'required']);

        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "smsai/campaign/add";
            $response = Helper::RequestApi($url, "PUT", $this->getBuildBody($request), "json");
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                session()->flash("success", "SMS AI Campaign created");
                return redirect("sms-ai-campaign");
            } else {
                foreach ( $response->errors as $key => $messages ) {
                    if (is_array($messages)) {
                        foreach ( $messages as $index => $message )
                            $errors->add("$key.$index", $message);
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return redirect()->back()->withInput()->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput()->withErrors($errors);
        }
    }

    public function show(Request $request, int $id)
    {
        $campaign_list = null;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "smsai/campaign/view/$id";
            $response = Helper::GetApi($url, [], true);
            //echo "<pre>";print_r($response);die;
            if ($response["success"]) {
                $campaign_list = $response["data"];
            } else {
                foreach ( $response["errors"] as $key => $message ) {
                    $errors->add($key, $message);
                }
                return view("tariff_plans.edit-tariff-values")->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("sms-ai.campaign.add")->withErrors($errors);
        }

         $templates = [];
        $url = env('API_URL').'smsai/templates';
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                $templates = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }

        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
        }


        /* Phone Country list */
        $list = [];
        $url = env('API_URL').'country-list';
        try
        {
            $response = Helper::PostApi($url);
            if ($response->success)
            {
                $phone_country = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }

        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
        }


        $inherit_list = new InheritApiController;
        $did_list = $inherit_list->getDidList();
        $extension_list = $this->getExtensionList();

        $no_of_campaign_list = [];
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'campaign_id' => $id,
            'is_deleted' => '0'
        );

        $errors = new MessageBag();
        $url = env('API_URL') . "smsai/campaign-list";
        
        try
        {
            
            $response = Helper::PostApi($url, $body);
            //echo "<pre>";print_r($response);die;

            if($response)
            {
                $no_of_campaign_list = $response;
            }
            else
            {
                $no_of_campaign_list = [];
                if (is_object($response)) {
                    foreach ($response->errors as $key => $message) {
                        $errors->add($key, $message);
                    }
                } else {
                    // Handle other cases where $response is not an object (e.g., empty response)
                    $errors->add("error", "Unexpected response format");
                }
            }
        }
        catch(RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("sms-ai.campaign.edit", compact("errors", $errors));
        }

       
    
    
    return view("sms-ai.campaign.edit",compact("campaign_list","phone_country",'did_list','extension_list','templates','no_of_campaign_list'));
  }


   public function update(Request $request, int $id)
  {
     
    $errors = new MessageBag();
    try
    {
      //echo "<pre>";print_r($this->getBuildBody($request));die;
      $url = env('API_URL') . "smsai/campaign/update/$id";
      $response = Helper::PostApi($url, $this->getBuildBody($request));

      
      if ($response->success)
      {
        session()->flash("success", "SMS AI Campaign Updated");
                return redirect("sms-ai-campaign");

        
      }
      else
      {
        foreach ($response->errors as $key => $messages)
        {
          if (is_array($messages))
          {
            foreach ($messages as $index => $message)
              $errors->add("$key.$index", $message);
          }
          else
          {
            $errors->add($key, $messages);
          }
        }
        return redirect()->back()->withInput($request->input())->withErrors($errors);
      }
    }
    catch (RequestException $ex)
    {
      $errors->add("error", $ex->getMessage());
      return redirect()->back()->withInput($request->input())->withErrors($errors);
    }
        session()->flash("success", "SMS AI Campaign Updated");
    
    return redirect()->back();
  }


    
    function getExtensionList()
    {
        $url = env('API_URL') . 'active-extension-group-list';
        try
        {
            $response = Helper::PostApi($url);
            return $response;
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
        }
    }
 
    function editCampaign(Request $request)
    {

        $call_time_start = explode(":", $request->call_time_start);

        $start_time = $call_time_start[0] . ':' . $call_time_start[1];

        $call_time_end = explode(":", $request->call_time_end);

        $end_time = $call_time_end[0] . ':' . $call_time_end[1];

        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'campaign_id' => $request->campaign_id,
            'title' => $request->title,
            'description' => $request->description,
            'status' => $request->status,
            'caller_id' => $request->caller_id,
            'custom_caller_id' => $request->custom_caller_id,
            'time_based_calling' => $request->time_based_calling,
            'call_time_start' => $start_time,//'09:30',//$request->call_time_start,
            'call_time_end' => $end_time,//'09:30', //$request->call_time_end,
            
        );
            //echo "<pre>";print_r($body);die;

        $url = env('API_URL') . 'ringless-edit-campaign';

        
        
        try {
            $addcampaign = Helper::PostApi($url, $body);
            //echo "<pre>";print_r($addcampaign);die;
            if ($addcampaign->success == 'true') {
                return back()->withSuccess($addcampaign->message);
            }

            if ($addcampaign->success == 'false') {
                return back()->withSuccess($addcampaign->message);
            }
        } catch (BadResponseException   $e) {
            return back()->with('message', "Error code - (edit-campaign-disposition): Oops something went wrong :( Please contact your administrator.)");
        } catch (RequestException $ex) {
            return back()->with('message', "Error code - (edit-campaign-disposition): Oops something went wrong :( Please contact your administrator.)");
        }
    }
    function deleteCampaign($campaign_id)
    {
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'campaign_id' => $campaign_id,
            'is_deleted' => '1'
        );

        // echo "<pre>";print_r($body);die;

        $url = env('API_URL') . 'smsai/campaign/delete';
        // echo "<pre>";print_r($body);die;

        try {
            $ringless_campaign = Helper::PostApi($url, $body);
       // echo "<pre>";print_r($ringless_campaign);die;

            if ($ringless_campaign->success == 'true') {
        
                return back()->withSuccess($ringless_campaign->message);
            }

            if ($ringless_campaign->success == 'false') {
                return back()->withError($ringless_campaign->message);
            }
        } catch (BadResponseException   $e) {
            return back()->with('message', "Error code - (edit-campaign): Oops something went wrong :( Please contact your administrator.)");
        } catch (RequestException $ex) {
            return back()->with('message', "Error code - (edit-campaign): Oops something went wrong :( Please contact your administrator.)");
        }
    }
    public function updateCampaignStatus($id = "", $status = "")
    {
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'listId' => $id,
            'status' => $status,
        );

        $url = env('API_URL') . 'smsai/campaign/update-status';
        try
        {
            $update_list = Helper::PostApi($url, $body);
           // echo "<pre>";print_r($update_list);die;
            Log::debug('API Response', ['response' => $update_list]);
            if ($update_list->success == 'true')
            {
                //return redirect('/list')->withSuccess($delete_list->message);
                echo json_encode(array('status' => "true", 'message' => $update_list->message));
            }
            if ($update_list->success == 'false') {
                //return redirect('/list')->withSuccess($delete_list->message);
                echo json_encode(array('status' => "false", 'message' => $update_list->message));
            }
        } catch (BadResponseException $e) {
            return back()->with('message', "Error code - (edit-list): Oops something went wrong :( Please contact your administrator.)");
        }
    }
    public function copyCampaign(Request $request)
    {
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'c_id' => $request->id
        );
        $url = env('API_URL') . 'smsai/campaign/copy';

        try {
            $copyCampaign = Helper::PostApi($url, $body);
           // echo "<pre>";print_r($copyCampaign);die;

            if ($copyCampaign->success == 'true') {
                return redirect('/sms-ai-campaign')->withSuccess($copyCampaign->message);
            }

            if ($copyCampaign->success == 'false') {
                return back()->withSuccess($copyCampaign->message);
            }
        } catch (BadResponseException   $e) {
            return back()->with('message', "Error code - (copy-campaign): Oops something went wrong :( Please contact your administrator.)");
        } catch (RequestException $ex) {

            return back()->with('message', "Error code - (copy-campaign): Oops something went wrong :( Please contact your administrator.)");
        }

    }
 }