<?php

namespace App\Http\Controllers\SmsAi;

use App\Http\Controllers\Controller;

use Session;
use Pusher\Pusher;
use App\Helper\Helper;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use PDF;
use Illuminate\Support\Str;
use App\Http\Controllers\InheritApiController;
use Illuminate\Support\Collection;

class SmsAiDailyReportController extends Controller
{




    public function index(Request $request)
    {
        $startDate = date('Y-m-d');
        $end_date = date('Y-m-d');
        if ($request->has('start_date')) {
            // The 'start_date' parameter is present in the request.
            $startDate = $request->start_date;
            // Do something with $startDate
        }
        if ($request->has('end_date')) {
            // The 'start_date' parameter is present in the request.
            $end_date = $request->end_date;
            // Do something with $startDate
        }


        // $body = array(
        //     'level' => Session::get('userLevel'),
        //     'start_date' => $request->start_date,
        //     'end_date' =>  $request->end_date,
        //     'id' => Session::get('id'),


        // );

        $body = array(
            'level' => Session::get('userLevel'),
            'start_date' => $startDate,
            'end_date' =>  $end_date,
            'id' => Session::get('id'),


        );

        //  echo "<pre>";
        //  print_r($body);
        //  die;



        $leads = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "smsai/daily/reports";


        try {
            $response = Helper::PostApi($url, $body);

            // echo "<pre>";
            // print_r($response);
            // die;


            if ($response->success) {
                if (!empty($response->data)) {
                    // Data exists, do something
                    $message = "";

                    $report = $response->data[0]->report_data;
                    //echo "<pre>";print_r($report);die;

                    // Extracting variables
                    // Decode JSON into an associative array
                    $reportData = json_decode($report, true);

                    // Now extract variables from the decoded JSON
                    $client_id = $reportData['client_id'];

                    $time_period = $reportData['time_period'];
                    $sent_numbers = $reportData['sent_numbers'];
                    $failed_numbers = $reportData['failed_numbers'];
                    $queued_numbers = $reportData['queued_numbers'];
                    $sending_numbers = $reportData['sending_numbers'];
                    $canceled_numbers = $reportData['canceled_numbers'];

                    $undelivered_numbers = $reportData['undelivered_numbers'];
                    $scheduled_numbers = $reportData['scheduled_numbers'];
                    $partially_delivered_numbers = $reportData['partially_delivered_numbers'];


                    $detailed_analysis = $reportData['detailed_analysis'];
                    $message_statistics = $reportData['message_statistics'];
                    $conversation_analysis = $reportData['conversation_analysis'];
                    $delivery_status = $message_statistics['delivery_status'];
                    $interested_conversations = $detailed_analysis['interested_conversations']; // List of interested convers//echo "<pre>";print_r($unique_conversations);die;
                    //echo "<pre>";print_r($interested_conversations);die;

                } else {
                    $message = $response->message;
                    $report = "";

                    // Now extract variables from the decoded JSON
                    $client_id = "";

                    $time_period = "";

                    $detailed_analysis = "";
                    $message_statistics = "";
                    $conversation_analysis = "";
                    $delivery_status = "";
                    $interested_conversations = "";
                    $time_period = "";
                    $sent_numbers = "";
                    $failed_numbers = "";
                    $queued_numbers = "";
                    $sending_numbers = "";
                    $canceled_numbers = "";

                    $undelivered_numbers = "";
                    $scheduled_numbers = "";
                    $partially_delivered_numbers = "";

                    // List of interested convers//echo "<pre>";print_r($unique_conversations);die;
                    //echo "<pre>";print_r($interested_conversations);die;

                    // No data in the array
                    // echo "No data found.";
                }
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("sms-ai.report.list", ["errors" => $errors]);
        }
        return view("sms-ai.daily-call-report.list", [
            'message' => $message,
            'report' => $report,
            'time_period' => $time_period,
            'message_statistics' => $message_statistics,
            'detailed_analysis' => $detailed_analysis,
            'conversation_analysis' => $conversation_analysis,
            'delivery_status' => $delivery_status,
            'interested_conversations' => $interested_conversations,
            'sent_numbers' => $sent_numbers,
            'failed_numbers' => $failed_numbers,
            'queued_numbers' => $queued_numbers,
            'sending_numbers' => $sending_numbers,
            'canceled_numbers' => $canceled_numbers,
            'undelivered_numbers' => $undelivered_numbers,
            'scheduled_numbers' => $scheduled_numbers,
            'partially_delivered_numbers' => $partially_delivered_numbers
        ]);
    }
}
