<?php
namespace App\Http\Controllers\SmsAi;
use App\Http\Controllers\Controller;

use Session;
use Pusher\Pusher;
use App\Helper\Helper;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use PDF;
use Illuminate\Support\Str;
use App\Http\Controllers\InheritApiController;
use Illuminate\Support\Collection;
use Yajra\DataTables\Facades\DataTables;
class SmsAiReportController extends Controller
{
 
   


    public function index(Request $request)
    {

       $inherit_list = new InheritApiController;
        $did_list = $inherit_list->getDidList();

         if (!is_array($did_list)) {
            $did_list = array(); // checking empty record
        }   
        $page=0;
        $upper_limit=10;
        $urlpage = $request->page;
        $show = $request->input('show', 10);
        if ($show == 25 || $show == 50 || $show == 100) {
            $upper_limit = $show;
        }
        if (!empty($urlpage) && $urlpage > 1)
        {
            $urlpage = $urlpage - 1;
            $lower_limit = $urlpage * 10;
        }
        else
        {
            $lower_limit = 0;
        }

    

         if ($request->submit_download == 'excel') {

             $upper_limit='';
         }


         $phone_number = str_replace(array('(',')', '_', '-',' '), array(''), $request->phone_number);


         $searchTerm = $request->input('search');


        $body = array
        (
            'level' => Session::get('userLevel'),
            'start_date' => $request->start_date,
            'end_date' =>  $request->end_date,
            'lower_limit' => $lower_limit,
            'upper_limit' => $upper_limit,
            'id' => Session::get('id'),
            'phone_number' => $phone_number,
            'cli' => $request->cli,
            'search' => $searchTerm,


        );

          // echo "<pre>";print_r($body);die;



        $leads = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "smsai/reports";
        try
        {
            $response = Helper::PostApi($url, $body);
            //echo "<pre>";print_r($response);die;
         

            if ($response)
            {
                $leads = $response->data;
            if (!is_array($leads)) $leads = [];

                // $record_count = $response->record_count;
            }

            else
            {
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }

        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("sms-ai.report.list", ["errors" => $errors]);
        }
        //$sortedUsers = $this->groupAndSortUsers($users);
       //echo "<pre>";print_r($leads);die;

if ($request->ajax()) {
    $data = DataTables::of(collect($leads))
        ->addIndexColumn()
->addColumn('number', function ($row) {
    $number = $row->number;
    $length = strlen($number);

    if ($length > 10) {
        $front = substr($number, 0, $length - 10);   // leading digits
        $last10 = substr($number, -10);              // last 10 digits
    } else {
        $front = '';
        $last10 = $number;
    }

    // Format last 10 digits as (999) 999-9999
    $formattedLast10 = sprintf('(%s) %s-%s',
        substr($last10, 0, 3),
        substr($last10, 3, 3),
        substr($last10, 6, 4)
    );

    return $front . $formattedLast10;
})
->addColumn('cli', function ($row) {
    $did = $row->did;
    $length = strlen($did);

    if ($length > 10) {
        $front = substr($did, 0, $length - 10);   // leading digits
        $last10 = substr($did, -10);              // last 10 digits
    } else {
        $front = '';
        $last10 = $did;
    }

    // Format last 10 digits as (999) 999-9999
    $formattedLast10 = sprintf('(%s) %s-%s',
        substr($last10, 0, 3),
        substr($last10, 3, 3),
        substr($last10, 6, 4)
    );

    return $front . $formattedLast10;
})
        ->addColumn('message', fn($row) => $row->message)
        ->addColumn('type', function ($row) {
            $style = '';
            if ($row->type === 'merchant') {
                $style = "background-color:#a90329!important;color:#fff;text-align:center;";
            } elseif ($row->type === 'ai') {
                $style = "background-color:#c79121!important;color:#fff;text-align:center;";
            }
            return '<span class="right badge" style="' . $style . '">' . strtoupper($row->type) . '</span>';
        })
        ->addColumn('sms_type', function ($row) {
            $badgeClass = $row->sms_type === 'incoming' ? "right badge badge-success" : "right badge badge-danger";
            return '<span class="' . $badgeClass . '">' . strtoupper($row->sms_type) . '</span>';
        })
        ->addColumn('action', function ($row) {
            $num = $row->number;
            $did = $row->did;
            return '<a target="_blank" href="/sms-ai-report/view?number='
                . substr($num, -10) . '&cli=' . substr($did, -10)
                . '" class="list-icons-item me-10"><i class="fa fa-eye fa-lg"></i></a>';
        })
        ->rawColumns(['type', 'sms_type', 'action']);

    // Set total and filtered records explicitly (optional, useful if you have filtering logic)


    return $data
        ->toJson();
}


       // echo "<pre>";print_r($leads);die;


        return view("sms-ai.report.list", ["sms_ai_report" => $leads]);
    }

    public function view()
    {
          return view("sms-ai.report.view");
    }

       public function getSmsCountsunread(Request $request)
    {
        $merchant = $request->merchant_number;
        $cli = $request->cli;


        



        


        $sms_ai_history = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "sms-ai-history";

        $body=array('number'=>$merchant,'cli' => $cli);

           



        try
        {
          $response_data = Helper::PostApi($url,$body);
            //echo "<pre>";print_r($response_data);die;
            if ($response_data->success) {
                $sms_ai_history = $response_data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("open-ai.update-setting", ["errors" => $errors]);
        }

        return json_encode($sms_ai_history);
/*
        //$count_sms_history =$sms_ai_history->count;

        //$merchant = $request->merchant_number;
        
        return $sms_ai_history;*/
        

    }


    public function delete(Request $request)
    {

        $number = '1'.str_replace(array('(',')', '_', '-',' '), array(''), $request->to);


        $open_ai_setting = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "open-ai-setting";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $open_ai_setting = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("open-ai.update-setting", ["errors" => $errors]);
        }

        $access_token = $open_ai_setting[0]->access_token;
        $cli = '1'.$open_ai_setting[0]->cli;
        $introduction = $open_ai_setting[0]->introduction;
        $description = $open_ai_setting[0]->description;
        $api_url = $open_ai_setting[0]->sms_ai_api_url;
        $webhook_url = $open_ai_setting[0]->webhook_url;


        //sms ai delete data

        $TELNYX_SMS_AI_URL   = env('TELNYX_SMS_AI_URL');
        $deleteSms = $TELNYX_SMS_AI_URL.'sms/delete?cli='.$cli.'&number='.$number;
         $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $deleteSms);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
       curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'accept: application/json',
            'x-api-key: '.$access_token,
            'Content-Type: application/json',
        ]);
        $response = curl_exec($ch);
        curl_close($ch);





        $delete_ai_history = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "delete-message-ai";

        $body=array('number'=>$number,'cli' => $cli);


        try
        {
            $response = Helper::PostApi($url,$body);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $delete_ai_history = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("open-ai.update-setting", ["errors" => $errors]);
        }

        return 1;

    }








}


