<?php

namespace App\Http\Controllers\SmsAi;
use Session;
use App\Helper\Helper;
use GuzzleHttp\Exception\BadResponseException;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\MessageBag;
use Illuminate\Support\Facades\Config;
use App\Http\Controllers\Controller;
use App\Http\Controllers\InheritApiController;

class SmsAiTemplatesController extends Controller
{
    public function list()
    {

        $templates = [];
        $url = env('API_URL').'smsai/templates';
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                $templates = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }

        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
        }
        
        return view('sms-ai.templates.list', compact('templates'));

    }

    private function getBuildBody(Request $request)
    {
        $body = [
            "template_name" => trim(ucwords($request->get("template_name"))),
            'introduction'=> $request->get("introduction"),
            'description'=> $request->get("description")
        ];

        return $body;
    }

    public function create(Request $request)
    {
        $inherit_list = new InheritApiController;
        $label_list =  $inherit_list->getLabel();
         usort($label_list, function ($a, $b) {
            return strcasecmp($a->title, $b->title);
        });
        // echo Session::get('tokenId'); exit;
        if(!is_array($label_list))
        {
          $label_list =array();
        }

       // echo "<pre>";print_r($label_list);die;
        return view('sms-ai.templates.add',compact('label_list'));
    }

    function add(Request $request)
    {
        $this->validate($request, ['template_name'      => 'required']);

        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "smsai/template/add";
            $response = Helper::RequestApi($url, "PUT", $this->getBuildBody($request), "json");
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                session()->flash("success", "SMS AI Template created");
                return redirect("sms-ai-templates");
            } else {
                foreach ( $response->errors as $key => $messages ) {
                    if (is_array($messages)) {
                        foreach ( $messages as $index => $message )
                            $errors->add("$key.$index", $message);
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return redirect()->back()->withInput()->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput()->withErrors($errors);
        }
    }

    public function show(Request $request, int $id)
    {
    
        $template = null;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "smsai/template/view/$id";
            $response = Helper::GetApi($url, [], true);
            //echo "<pre>";print_r($response);die;
            if ($response["success"]) {
                $template = $response["data"];

           // echo "<pre>";print_r($lists);die;

            } else {
                foreach ( $response["errors"] as $key => $message ) {
                    $errors->add($key, $message);
                }
                return view("tariff_plans.edit-tariff-values")->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("sms-ai.templates.edit")->withErrors($errors);
        }

        $inherit_list = new InheritApiController;
        $label_list =  $inherit_list->getLabel();
         usort($label_list, function ($a, $b) {
            return strcasecmp($a->title, $b->title);
        });
        // echo Session::get('tokenId'); exit;
        if(!is_array($label_list))
        {
          $label_list =array();
        }



           // echo "<pre>";print_r($lists);die;
       
    
        return view('sms-ai.templates.edit', compact('template','label_list'));
    }

   
   public function update(Request $request, int $id)
  {
     
    $errors = new MessageBag();
    try
    {
      $url = env('API_URL') . "smsai/template/update/$id";
      $response = Helper::PostApi($url, $this->getBuildBody($request));

    //  echo "<pre>";print_r($response);die;
      
      if ($response->success)
      {
        session()->flash("success", "SMS AI Template Updated");
                return redirect("sms-ai-templates");

        
      }
      else
      {
        foreach ($response->errors as $key => $messages)
        {
          if (is_array($messages))
          {
            foreach ($messages as $index => $message)
              $errors->add("$key.$index", $message);
          }
          else
          {
            $errors->add($key, $messages);
          }
        }
        return redirect()->back()->withInput($request->input())->withErrors($errors);
      }
    }
    catch (RequestException $ex)
    {
      $errors->add("error", $ex->getMessage());
      return redirect()->back()->withInput($request->input())->withErrors($errors);
    }
        session()->flash("success", "SMS AI Template Updated");
    
    return redirect()->back();
  }






   public function updateStatus($id = "", $status = "")
    {
        $body = array(
            
            'template_id' => $id,
            'status' => $status,
        );

        $url = env('API_URL') . 'smsai/template/update-status';
        try
        {
            $delete_list = Helper::PostApi($url, $body);
            if ($delete_list->success == 'true')
            {
                //return redirect('/list')->withSuccess($delete_list->message);
                echo json_encode(array('status' => "true", 'message' => $delete_list->message));
            }
            if ($delete_list->success == 'false') {
                //return redirect('/list')->withSuccess($delete_list->message);
                echo json_encode(array('status' => "false", 'message' => $delete_list->message));
            }
        } catch (RequestException $ex)
    {
      $errors->add("error", $ex->getMessage());
      return redirect()->back()->withInput($request->input())->withErrors($errors);
    }
    }


     public function delete(Request $request, int $id)
  {
        $custom_field_labels = null;
        $errors = new MessageBag();
        try
        {
            $url = env('API_URL') . "smsai/template/delete/$id";
            $response = Helper::GetApi($url, [], true);
            echo "<pre>";print_r($response);die;
            if ($response["success"])
            {
                $custom_field_labels = $response["data"];
            }
            else
            {
                foreach ($response->errors as $key => $messages)
                {
                    if (is_array($messages))
                    {
                        foreach ($messages as $index => $message)
                            $errors->add("$key.$index", $message);
                    }
                    else
                    {
                        $errors->add($key, $messages);
                    }
                }
                return view("tariff_plans.edit-tariff-values")->withErrors($errors);
                
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("tariff_plans.edit-tariff-values")->withErrors($errors);
        }
        return $response;
  }

 }