<?php

namespace App\Http\Controllers\SmsAi;
use App\Http\Controllers\Controller;

use App\Helper\Helper;
use Illuminate\Support\MessageBag;
use Session;
use Illuminate\Http\Request;
use App\Http\Controllers\InheritApiController;
use Carbon\Carbon;
class SmsAiWalletController extends Controller
{
    
    function getWalletTransactions()
    {

        $walletTransactions = NULL;
        $errors = new MessageBag();
        $url = env('API_URL') . 'smsai/wallet/transactions';
        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $walletTransactions = $response->data;
            } else {
                $errors->add("error", $response->message);
                return view("sms-ai.billing.wallet-transactions", compact("errors", $errors));
            }
        } catch (\Throwable $ex) {
            $errors->add("error", $ex->getMessage());
            return view("sms-ai.billing.wallet-transactions", compact("errors", $errors));
        }
        return view("sms-ai.billing.wallet-transactions", compact("walletTransactions"));
    }
    function getWalletAmount()
    {

        $walletAmount = NULL;
        $errors = new MessageBag();
        $url = env('API_URL') . 'smsai/wallet/amount';
        try {
            $response = Helper::GetApi($url);
            
            if ($response->success) {
                $walletAmount = $response->data;
                //echo "<pre>";print_r($walletAmount);die;
            } else {
                $errors->add("error", $response->message);
                return view("sms-ai.billing.wallet-amount", compact("errors", $errors));
            }
        } catch (\Throwable $ex) {
            $errors->add("error", $ex->getMessage());
            return view("sms-ai.billing.wallet-amount", compact("errors", $errors));
        }
        return view("sms-ai.billing.wallet-amount", compact("walletAmount"));
    }
}
