<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use League\OAuth2\Client\Provider\GenericProvider;

class AzureServiceProvider extends ServiceProvider
{
    public function register()
    {
        $this->app->singleton(GenericProvider::class, function ($app) {
            return new GenericProvider([
                'clientId'                => env('AZURE_CLIENT_ID'),
                'clientSecret'            => env('AZURE_CLIENT_SECRET'),
                'redirectUri'             => env('AZURE_REDIRECT_URI'),
                'urlAuthorize'            => 'https://login.microsoftonline.com/' . env('AZURE_TENANT_ID') . '/oauth2/v2.0/authorize',
                'urlAccessToken'          => 'https://login.microsoftonline.com/' . env('AZURE_TENANT_ID') . '/oauth2/v2.0/token',
                'urlResourceOwnerDetails' => '',
                'scopes'                  => 'openid profile offline_access user.read mail.read',
                'pkceMethod'              => 'S256' // Enable PKCE
            ]);
        });
    }

    public function boot()
    {
        //
    }
}
