<?php

namespace App\Providers;

use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use App\Helper\Helper;

class ViewServiceProvider extends ServiceProvider
{
    public function boot()
    {
        // Share data with all views (like header, footer, etc.)
        View::composer('*', function ($view) {
            $urlClientPackages = env('API_URL') . "client-packages";
            $response = Helper::GetApi($urlClientPackages);

            $availablePackages = [];
            if ($response && isset($response->success) && $response->success) {
                $availablePackages = (array) $response->data;
            }

            $view->with('availablePackages', $availablePackages);
        });
    }

    public function register() {}
}
