<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
   /* protected $fillable = [
        'name', 'email', 'password', 'profile_pic',
    ];*/

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',  
    ];


    public function getTableColumns() {
        $selected_columns = array('first_name','last_name','email','mobile','company_name');
        $columns = $this->getConnection()->getSchemaBuilder()->getColumnListing($this->getTable());
        //return $this->getConnection()->getSchemaBuilder()->getColumnListing($this->getTable());
        return $result=array_intersect($selected_columns,$columns);
    }
}
