<?php

use Monolog\Handler\StreamHandler;
use Monolog\Handler\SyslogUdpHandler;

return [

    /*
    |--------------------------------------------------------------------------
    | Default Log Channel
    |--------------------------------------------------------------------------
    |
    | This option defines the default log channel that gets used when writing
    | messages to the logs. The name specified in this option should match
    | one of the channels defined in the "channels" configuration array.
    |
    */

    'default' => env('LOG_CHANNEL', 'stack'),

    /*
    |--------------------------------------------------------------------------
    | Log Channels
    |--------------------------------------------------------------------------
    |
    | Here you may configure the log channels for your application. Out of
    | the box, Laravel uses the Monolog PHP logging library. This gives
    | you a variety of powerful log handlers / formatters to utilize.
    |
    | Available Drivers: "single", "daily", "slack", "syslog",
    |                    "errorlog", "monolog",
    |                    "custom", "stack"
    |
    */

    'channels' => [
        'stack' => [
            'driver' => 'stack',
            'channels' => ['daily'],
            'ignore_exceptions' => false,
        ],
        'single' => [
            'driver' => 'single',
            'path' => storage_path('logs/frontend.log.json'),
            'formatter' => Monolog\Formatter\JsonFormatter::class,
            'level' => 'debug',
        ],
        'staging' => [
            'driver' => 'daily',
            'path' => '/var/log/cafmotel/staging-frontend.log',
            'formatter' => Monolog\Formatter\JsonFormatter::class,
            'level' => 'debug',
            'days' => 2
        ],
        'test' => [
            'driver' => 'daily',
            'path' => '/var/log/cafmotel/test-frontend.log',
            'formatter' => Monolog\Formatter\JsonFormatter::class,
            'level' => 'debug',
            'days' => 2
        ],
        'daily' => [
            'driver' => 'daily',
            'path' => '/var/log/cafmotel/frontend.log',
            'formatter' => Monolog\Formatter\JsonFormatter::class,
            'level' => 'debug',
            'days' => 7,
        ],
        'backend-request-local' => [
            'driver' => 'single',
            'path' => storage_path('logs/backend-request.log.json'),
            'formatter' => Monolog\Formatter\JsonFormatter::class,
            'level' => 'debug'
        ],
        'backend-request-staging' => [
            'driver' => 'daily',
            'path' => '/var/log/cafmotel/staging-backend-request.log',
            'formatter' => Monolog\Formatter\JsonFormatter::class,
            'level' => 'debug',
            'days' => 2,
        ],
        'backend-request-test' => [
            'driver' => 'daily',
            'path' => '/var/log/cafmotel/test-backend-request.log',
            'formatter' => Monolog\Formatter\JsonFormatter::class,
            'level' => 'debug',
            'days' => 2,
        ],
        'backend-request-production' => [
            'driver' => 'daily',
            'path' => '/var/log/cafmotel/backend-request.log',
            'formatter' => Monolog\Formatter\JsonFormatter::class,
            'level' => 'debug',
            'days' => 2,
        ],
        'slack' => [
            'driver' => 'slack',
            'url' => env('LOG_SLACK_WEBHOOK_URL'),
            'username' => 'Laravel Log',
            'emoji' => ':boom:',
            'level' => 'critical',
        ],
        'papertrail' => [
            'driver' => 'monolog',
            'level' => 'debug',
            'handler' => SyslogUdpHandler::class,
            'handler_with' => [
                'host' => env('PAPERTRAIL_URL'),
                'port' => env('PAPERTRAIL_PORT'),
            ],
        ],
        'stderr' => [
            'driver' => 'monolog',
            'handler' => StreamHandler::class,
            'formatter' => env('LOG_STDERR_FORMATTER'),
            'with' => [
                'stream' => 'php://stderr',
            ],
        ],
        'syslog' => [
            'driver' => 'syslog',
            'level' => 'debug',
        ],
        'errorlog' => [
            'driver' => 'errorlog',
            'level' => 'debug',
        ],
    ],

];
