$(document).ready(function () {
    $.ajax({
        url: 'contact-book',
        type: 'GET',
        success: function (contact_response) {
            if(contact_response.length == 1){
                //toastr.error(contact_response[0]);
            } else if(contact_response[1].length == 0){
                toastr.error(contact_response[0]);
            }else{
                var contactBookHtml = '';
                $.each(contact_response, function (index, value) {
                    contactBookHtml += '<div class="single-user user-'+value.id +'" data-id ="'+ value.id + '" data-extension ="'+ value.extension + '"><span class="user-avatar"><i class="fa fa-user"></i></span><span class="user-name">' + value.first_name + ' ' + value.last_name + '</span></div>';
                });

                $(".chat-users-listing").html(contactBookHtml);
                $(".users-chat-header .count").html("("+contact_response.length+")");
            }
        },
        error: function (response) {
            console.log(response);
        }
    });

    if($('#txtPhoneNumber').length > 0)
        $('#txtPhoneNumber').inputmask("(999) 999-9999");
});

$(document).on("click", ".call-contact", function (e) {
    e.preventDefault();
    var toId = $(this).parents(".single-chat-container").data('id');
    var extension = $(this).parents(".single-chat-container").data('extension');
    $("#control-sidebar-dark").find(".control-sidebar-tabs > li:first-child a").trigger('click');

    //if not connected then connect
    if (!oSipStack) {
        sipRegister();
        $('#txtPhoneNumber').val(extension);
    }
    //in call already
    if(oSipStack && oSipSessionCall){
        toastr.error("Already on another call!!!");
    }
    if(oSipStack && !oSipSessionCall){
        $("#btnCall").click();
    }

});

$(document).on("click", ".add-meeting", function (e) {
    e.preventDefault();
    var toId = $(this).parents(".single-chat-container").data('id');
    var generatedId = getGeneratedId();
    var videoURL = $(".video-url").val();

    $(".chat-box-"+toId).find(".m-send").val("Join the meeting, https://"+videoURL+"/"+ generatedId);
    $(".chat-box-"+toId).find(".meeting_key").val(generatedId);
});

$(document).on('click', 'span.close-chat', function() {
    $(this).parents(".single-chat-container").remove();
});

$(document).on('click', '.single-user', function() {
    var id = $(this).data('id');
    var extension = $(this).data('extension');
    var userName = $(this).find('.user-name').text();
    var isWindowExist = document.getElementsByClassName('chat-box-'+id);

    if (isWindowExist.length <= 0) {
        //create and append elements
        var singleChatContainer = document.createElement("div");
        singleChatContainer.className = "single-chat-container chat-box-"+id;
        singleChatContainer.dataset.id = id;
        singleChatContainer.dataset.extension = extension;

        //chat header
        var headerDiv = document.createElement("div");
        headerDiv.className = "chat-header";
        headerDiv.innerHTML = '<div class="user-name">'+userName+'</div><div class="chat-controls"><span class="call-contact"><i class="fa fa-phone"></i></span><span class="add-meeting"><i class="fa fa-video-camera"></i></span><a href="/chat/'+id+'" target="_blank" class="external-link"><i class="fa fa-external-link"></i></a><span class="close-chat"><i class="fa fa-close fa-lg"></i></span></div>';

        //chat body
        var bodyDiv = document.createElement("div");
        bodyDiv.className = "chat-body";
        bodyDiv.innerHTML = '<img class="chat-loading" src="/asset/img/loader-30px.gif"/>';

        //chat typing
        var typingDiv = document.createElement("div");
        typingDiv.className = "typing-indicator";
        typingDiv.innerHTML = `<div class="">
                                    <p>
                                        <span class="typing-dots">
                                            <span class="dot dot-1"></span>
                                            <span class="dot dot-2"></span>
                                            <span class="dot dot-3"></span>
                                        </span>
                                    </p>
                                </div>`;

        //attachment-preview
        var attachmentPreviewDiv = document.createElement("div");
        attachmentPreviewDiv.className = "attachment-preview";

        //chat footer
        var footerDiv = document.createElement("div");
        footerDiv.className = "chat-footer";
        footerDiv.innerHTML = '<label class="add-attachment"><span class="fa fa-paperclip"></span><input type="file" class="upload-attachment" name="file" accept="image/*, .txt, .rar, .zip" /></label>';
        footerDiv.innerHTML += '<input type="text" class="m-send app-scroll" placeholder="Type a message.." value="">';
        footerDiv.innerHTML += '<button class="send-btn"><i class="fa fa-send"></i></button>';
        footerDiv.innerHTML += '<input type="hidden" name="meeting_key" class="meeting_key" value="">';

        singleChatContainer.appendChild(headerDiv);
        singleChatContainer.appendChild(bodyDiv);
        singleChatContainer.appendChild(typingDiv);
        singleChatContainer.appendChild(attachmentPreviewDiv);
        singleChatContainer.appendChild(footerDiv);

        document.getElementById("chat-window-area").appendChild(singleChatContainer);

        //get chat data
        $.ajax({
            url: 'fetchMessages',
            type:'POST',
            data: {
                'id' : id
            },
            success: function (response) {
                $(".chat-box-"+id).find(".chat-body").html(response.messages);
                scrollBottom(id);
            },
            error: function (response) {
                console.log(response);
            }
        });
    }
});

$(document).on('click', '.chat-header .user-name', function() {
    $(this).parents(".chat-header").siblings(".chat-body").toggle();
    $(this).parents(".chat-header").siblings(".chat-footer").toggle();
});

$(document).on('click', '.send-btn', function() {
    var message = $(this).siblings(".m-send").val();
    var toId = $(this).parents(".single-chat-container").data('id');
    sendMessage(message,toId);
});

//if enter key pressed then send.
$(document).on("keyup",".single-chat-container .m-send", function(e){
    var message = $(this).val();
    var toId = $(this).parents(".single-chat-container").data('id');

    if (e.which == 13 || e.keyCode == 13) {
        sendMessage(message,toId);
    }
});

// subscribe to the channel
var channel2 = pusher.subscribe("private-chatify");
const auth_id = $(".user-id").val();
var typingNow = 0,typingTimeout;

// Listen to messages, and append if data received
channel2.bind("messaging", function (data) {
    const div = document.querySelector('#control-sidebar-dark');

    if (data.to_id == auth_id) {
        //if found then append message and scroll
        //elseif in any window right panel is open then open chat window
        //else add notification which will open chat window
        if ($(".chat-box-"+data.from_id).length){
            appendMessage(data.message,data.from_id);
            scrollBottom(data.from_id);
            makeSeen(data.from_id, true);
        } else if(div.classList.contains('control-sidebar-open')) {
            $(".single-user.user-"+data.from_id).trigger("click");
        } else {
            var count = $('.notification_id_total_count').text();
            $('.notification_id_total_count').text(parseInt(count) + 1);

            var liElement = document.createElement("li");
            liElement.innerHTML = '<div data-from-id="'+data.from_id+'" class="chat-notification"><div class="sender_name"><i class="fa fa-commenting-o"></i> '+data.sender_name+'</div>'+ data.message +'</div>';
            $(".notifications-menu ul.dropdown-menu").append(liElement);
            $(".notifications-menu ul.dropdown-menu").find("a.chat-message .message-card").css("display","inline-block");
            $(".notifications-menu ul.dropdown-menu").find("a.chat-message sub").hide();
        }

        if (Notification.permission !== 'granted')
            Notification.requestPermission();
        else {
            var messageText = data.message.substring(data.message.indexOf("<p>") + 3,data.message.lastIndexOf("<sub"));
            var notification = new Notification(data.sender_name, {
                body: messageText,
            });
            notification.onclick = function() {
                window.open('/chat/'+data.from_id);
            };
        }
    }
});

// listen to typing indicator
channel2.bind("client-typing", function (data) {
    if (data.to_id == auth_id) {
        data.typing == true
            ? $(document).find(".chat-box-"+data.from_id).find(".typing-indicator").show()
            : $(document).find(".chat-box-"+data.from_id).find(".typing-indicator").hide();
    }
});

$(document).on("keydown",".single-chat-container .m-send", function(e) {
    var toId = $(this).parents(".single-chat-container").data('id');
    if (typingNow < 1) {
        // Trigger typing
        let triggered = isTyping(toId,true);
        // triggered
        //     ? console.info("[+] Triggered")
        //     : console.error("[+] Not triggered");
        // Typing now
        typingNow = 1;
    }
    // Clear typing timeout
    clearTimeout(typingTimeout);
    // Typing timeout
    typingTimeout = setTimeout(function () {
        triggered = isTyping(toId,false);
        // triggered
        //     ? console.info("[-] Triggered")
        //    : console.error("[-] Not triggered");
        // Clear typing now
        typingNow = 0;
    }, 1000);
});

$(document).on('click', '.chat-notification', function() {
    var fromId = $(this).data('from-id');
    $(".single-user.user-"+fromId).trigger("click");
});

// Image modal
$(document).on("click", "#chat-window-area .image-file.chat-image", function () {
    let src = $(this).css("background-image").split(/"/)[1];
    $("#imageModalBox").show();
    $("#imageModalBoxSrc").attr("src", src);
});

$(".imageModal-close").on("click", function () {
    $("#imageModalBox").hide();
});


// On [upload attachment] input change, show a preview of the image/file.
$(document).on("change", ".upload-attachment",  function (e) {
    let file = e.target.files[0];
    if (!attachmentValidate(file)) return false;
    let reader = new FileReader();
    let sendCard = $(this).parents(".chat-footer");

    reader.readAsDataURL(file);
    reader.addEventListener("loadstart", (e) => {
        $("#message-form").before(loadingSVG());
    });
    reader.addEventListener("load", (e) => {
        $(".messenger-sendCard").find(".loadingSVG").remove();
        if (!file.type.match("image.*")) {
            // if the file not image
            sendCard.find(".attachment-preview").remove(); // older one
            sendCard.prepend(attachmentTemplate("file", file.name));
        } else {
            // if the file is an image
            sendCard.find(".attachment-preview").remove(); // older one
            sendCard.prepend(
                attachmentTemplate("image", file.name, e.target.result)
            );
        }
    });
});

// Attachment preview cancel button.
$(document).on("click", ".attachment-preview .attachment-preview-close", function (e) {
    var id = $(this).parents('.single-chat-container').data('id');
    cancelAttachment(id);
});

//functions
function sendMessage(message,toId){
    var fdForFile = new FormData();
    $(document).find(".chat-box-"+toId).find(".message-hint").hide();
    $(document).find(".chat-box-"+toId).find(".m-send").val("");

    let hasFile = $(".upload-attachment").val() ? $(".upload-attachment").val() : false;
    fdForFile.append('id',toId);
    fdForFile.append('message',message);
    fdForFile.append('type',"user");
    fdForFile.append('temporaryMsgId',"");
    fdForFile.append('_token',$('meta[name="csrf-token"]').attr('content'));

    if(hasFile) {
        var files = $('.upload-attachment')[0].files;
        fdForFile.append('file',files[0]);
    } else if(message == ''){
        toastr.error('Please enter a message');
        return false;
    }
    cancelAttachment(toId);

    $.ajax({
        url: 'sendMessage',
        type:'POST',
        data:fdForFile,
            contentType: false,
            processData: false,
        success: function (response) {
            if(response.error.status != 0) {
                console.log("Unable to send message");
            }

            appendMessage(response.message,toId);
            scrollBottom(toId);
            $(".upload-attachment").val("");
        },
        error: function (response) {
            console.log(response);
        }
    });
}

function appendMessage(message, fromId) {
    $(document).find(".chat-box-"+fromId).find(".chat-body").append(message);
    $(document).find(".chat-box-"+fromId).find(".chat-footer .meeting_key").val("");
}

function scrollBottom(Id) {
    var scrollableElement = $(".chat-box-"+Id).find('.chat-body');
    scrollableElement.scrollTop(scrollableElement[0].scrollHeight);
}

function getGeneratedId() {
    var length = 12,
        charset = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789",
        retVal = "";
    for (var i = 0, n = charset.length; i < length; ++i)
    {
        retVal += charset.charAt(Math.floor(Math.random() * n));
    }
    return retVal;
}

function isTyping(toId, status) {
    return channel2.trigger("client-typing", {
        from_id: auth_id, // Me
        to_id: toId, // Messenger
        typing: status,
    });
}

function makeSeen(from_id, status) {
    // seen
    $.ajax({
        url: "/makeSeen",
        method: "POST",
        data: { _token: $('meta[name="csrf-token"]').attr('content'), id: from_id },
        dataType: "JSON",
        // success: data => {
        //     console.log("[seen] Messages seen - " + getMessengerId());
        // }
    });
    return channel.trigger("client-seen", {
        from_id: auth_id, // Me
        to_id: from_id, // Messenger
        seen: status,
    });
}

function attachmentValidate(file) {
    const fileElement = $(".upload-attachment");
    const allowedExtensions = [
        "jpg",
        "jpeg",
        "png",
        "gif",
        "zip",
        "rar",
        "txt",
    ];
    const sizeLimit = 5000000; // 5 megabyte
    const { name: fileName, size: fileSize } = file;
    const fileExtension = fileName.split(".").pop();
    if (!allowedExtensions.includes(fileExtension)) {
        alert("file type not allowed");
        fileElement.val("");
        return false;
    }
    // Validate file size.
    if (fileSize > sizeLimit) {
        alert("Please select file size less than 5 MiB");
        return false;
    }
    return true;
}

// upload image preview card.
function attachmentTemplate(fileType, fileName, imgURL = null) {
    if (fileType != "image") {
        return (
            `
<div class="attachment-preview">
  <span class="attachment-preview-close"><i class="fa fa-close"></i></span>
</div>
`
        );
    } else {
        return (
            `
<div class="attachment-preview">
  <span class="attachment-preview-close"><i class="fa fa-close"></i></span>
  <div class="image-file chat-image" style="background-image: url('` +
            imgURL +
            `');"></div>
</div>
`
        );
    }
}

function loadingSVG(w_h = "25px", className = "", style = "") {
    return `
<svg style="${style}" class="loadingSVG ${className}" xmlns="http://www.w3.org/2000/svg" width="${w_h}" height="${w_h}" viewBox="0 0 40 40" stroke="#2180f3">
<g fill="none" fill-rule="evenodd">
<g transform="translate(2 2)" stroke-width="3">
<circle stroke-opacity=".1" cx="18" cy="18" r="18"></circle>
<path d="M36 18c0-9.94-8.06-18-18-18" transform="rotate(349.311 18 18)">
    <animateTransform attributeName="transform" type="rotate" from="0 18 18" to="360 18 18" dur=".8s" repeatCount="indefinite"></animateTransform>
</path>
</g>
</g>
</svg>
`;
}

const escapeHtml = (unsafe) => {
    return unsafe
        .replace(/&/g, "&amp;")
        .replace(/</g, "&lt;")
        .replace(/>/g, "&gt;");
};

/**
 *-------------------------------------------------------------
 * Cancel file attached in the message.
 *-------------------------------------------------------------
 */
function cancelAttachment(id) {
    $(".chat-box-"+id).find(".attachment-preview").remove();
    $(".upload-attachment").replaceWith(
        $(".upload-attachment").val("").clone(true)
    );
}
