
var channel = pusher.subscribe('my-channel');
channel.bind('my-event', function(data) {
  if(typeof(data.message) != 'undefined') {
        var userIds = data.message.user_ids;
        userIds.forEach(function(user_id) {
            if(user_id == logged_in_user_id) {
                if(data.message.platform == 'call') {
                    switch(data.message.event) {
                        case "ringing":
                            setRingingCallNotif(data.message, user_id);
                        break;
                        case "received":
                            setReceivedCallNotif(data.message, user_id);
                        break;
                        case "completed":
                            setCompletedCallNotif(data.message, user_id);
                        break;
                    }
                } else {
                    playNotificationAudio('short_notification_audio');
                    var link = '';
                    if(data.message.platform == 'text') {
                        link = root_url+"/inbox";
                    }
                    if(data.message.platform == 'fax') {
                        link = root_url+"/receive-fax";
                    }
                    if(data.message.platform == 'voicemail') {
                        link = root_url+"/mailbox";
                    }

                    toastr.success("<a href='"+link+"'>"+data.message.msg+"</a>");
                }
            } else {
                //HIde ringing notification if call is received by other extension
                if(typeof(data.message.event) != 'undefined' &&
                        (data.message.event == 'received' || data.message.event == 'completed')) {
                    setCompletedCallNotif(data.message, user_id);
                }
            }
        });
  }
});


function setRingingCallNotif(data, user_id) {
    var html = '<li class="call_noti_'+data.number+'_'+user_id+'">';
    html += '<a href="javascript::;">';
    html += '<i class="menu-icon fa fa-phone bg-blue"></i>';
    html += '<div class="menu-info">';
    html += '<h4 id="incoming_call_head_tag_'+data.number+'_'+user_id+'" style="font-size:20px;" class="control-sidebar-subheading ">'+data.msg+'</h4>';
    html += '</div>';
    html += '</a>';
    html += '</li>';
    html += '<li id="call_notif_view_lead_btn_div_'+data.number+'_'+user_id+'" class="call_noti_'+data.number+'_'+user_id+'" style="text-align:center;display:none;">';
    var url = root_url+"/lead-activity?from=notification&phone_number="+data.number;
    html += '<a href="'+url+'" ><button type="button" class="btn btn-warning"> View Lead</button></a>';
    html += '</li>';
    playNotificationAudio('notification_audio');
    $("#notification_side_bar").append(html);
    $("#control-sidebar-dark").addClass('control-sidebar-open');
    blink('#incoming_call_head_tag_'+data.number+'_'+user_id);
}

function setReceivedCallNotif(data, user_id) {
    $("#incoming_call_head_tag_"+data.number+'_'+user_id).text(data.msg);
    $("#call_notif_view_lead_btn_div_"+data.number+'_'+user_id).show();
    pauseNotificationAudio('notification_audio');
}

function setCompletedCallNotif(data, user_id) {
    $(".call_noti_"+data.number+'_'+user_id).remove();
    pauseNotificationAudio('notification_audio');
    $("#control-sidebar-dark").removeClass('control-sidebar-open');
}

function playNotificationAudio(audio_type_id) {
    var sound = document.getElementById(audio_type_id);
    sound.play();
}

function pauseNotificationAudio(audio_type_id) {
    var sound = document.getElementById(audio_type_id);
    sound.pause();
    sound.currentTime = 0;
}

function blink(selector){
    $(selector).fadeOut('slow', function(){
      $(this).fadeIn('slow', function(){
       blink(this);
      });
    });
}
