$(function () {
    $(document).ready(function () {
        $('.number-of-users .minus').click(function () {
            var input = $(this).parent().find('input');
            var count = parseInt(input.val()) - 1;
            var page = $(this).data("page");

            if (page === 'upgrade') {
                count = count < 1 ? 0 : count;
                input.val(count);
                input.change();
                return;
            }

            if (page === 'cart' && count < 1) {
                return;
            }

            count = count < 1 ? 1 : count;
            input.val(count);
            input.change();

            if (page === 'cart') {
                var subTotal = 0;
                var Id = $(this).parents(".number-of-users").data("id");
                var taxPrice = $(".tax-price").data("price");
                var shippingPrice = $(".shipping-price").data("price");
                var CurrentProductPrice = $(this).closest("tr").find(".product-price").data("price");
                var billing = $(this).closest("tr").find(".billing-period").data("billing");

                //Assign Subtotal
                $(this).closest("tr").find(".product-price").text('$' + CurrentProductPrice * billing * input.val());

                //Calculate Amount Due
                $(".product-price").each(function (i, element) {
                    subTotal += parseFloat($(element).text().replace('$', ''));
                });
                var grandTotal = subTotal + Number(taxPrice) + Number(shippingPrice);

                //Assign Amount Due
                $(".subtotal-price").text('$' + subTotal.toFixed(2));
                $(".grand-total").text('$' + grandTotal.toFixed(2));

                $.ajax({
                    url: '/cart/update/' + Id,
                    type: 'POST',
                    data: {
                        operation: 'minus'
                    },
                    dataType: "json",
                    success: function (response) {
                        toastr.success(response);
                    }
                });
            }
        });

        $('.number-of-users .plus').click(function () {
            var input = $(this).parent().find('input');
            var page = $(this).data("page");
            input.val(parseInt(input.val()) + 1);
            input.change();

            if (page === 'cart') {
                var subTotal = 0;
                var Id = $(this).parents(".number-of-users").data("id");
                var taxPrice = $(".tax-price").data("price");
                var shippingPrice = $(".shipping-price").data("price");
                var CurrentProductPrice = $(this).closest("tr").find(".product-price").data("price");
                var billing = $(this).closest("tr").find(".billing-period").data("billing");

                //Assign Subtotal
                $(this).closest("tr").find(".product-price").text('$' + CurrentProductPrice * billing * input.val());

                //Calculate Amount Due
                $(".product-price").each(function (i, element) {
                    subTotal += parseFloat($(element).text().replace('$', ''));
                });
                var grandTotal = subTotal + Number(taxPrice) + Number(shippingPrice);

                //Assign Amount Due
                $(".subtotal-price").text('$' + subTotal.toFixed(2));
                $(".grand-total").text('$' + grandTotal.toFixed(2));

                $.ajax({
                    url: '/cart/update/' + Id,
                    type: 'POST',
                    data: {
                        operation: 'plus'
                    },
                    dataType: "json",
                    success: function (response) {
                        toastr.success(response);
                    }
                });
            }
        });
    });

    $(document).on('click', '.add-to-cart', function (e) {
        e.preventDefault();
        var billingPeriod = $(this).parents(".info").find(".billing-type").val();
        var NoOfUsers = $(this).parents(".info").find(".number-of-users input").val();
        var selectedPackage = $(this).siblings(".selected-package").val();

        if (billingPeriod === '#') {
            toastr.error("Please select Billing Period.");
            return;
        }
        if (NoOfUsers === '0') {
            toastr.error("Please select No of Users.");
            return;
        }

        $.ajax({
            url: '/cart/add/' + selectedPackage,
            type: 'POST',
            data: {
                billingPeriod: billingPeriod,
                NoOfUsers: NoOfUsers
            },
            dataType: "json",
            success: function (response) {
                $oldValue = $(".right-panel .shopping-cart span.label.label-success").text();
                $(".right-panel .shopping-cart span.label.label-success").text(Number($oldValue)+1);
                toastr.success(response);
            }
        });
        $(this).parents(".info").find(".billing-type option:selected").removeAttr("selected");
        $(this).parents(".info").find(".number-of-users input").val(0);
    });

    $(document).on('click', '.delete-cart-item', function (e) {
        e.preventDefault();
        var Id = $(this).data("id");
        $.ajax({
            url: '/cart/delete/' + Id,
            type: 'POST',
            success: function (response) {
                toastr.success(response);
                location.reload();
            }
        });
    });
});
