$(function () {
    CKEDITOR.config.autoParagraph = false;
    CKEDITOR.config.versionCheck = false;
    CKEDITOR.config.enterMode = CKEDITOR.ENTER_BR;
    CKEDITOR.config.shiftEnterMode = CKEDITOR.ENTER_P;
    CKEDITOR.replace('editor1', {
        enterMode: CKEDITOR.ENTER_BR,
        filebrowserUploadUrl: "{{route('start-dialing.upload', ['_token' => csrf_token() ])}}",
        filebrowserUploadMethod: 'form'
    });

    CKEDITOR.instances['editor1'].on('contentDom', function () {
        this.document.on('click', function (event) {
            console.log('abh');
            $('#setBoxValue').html('');
        });
    });

    $("#multiple_labels").on('change', function () {
        //console.log($(this).val());
        var label_name = $(this).val();
        var lead_id = $("#lead_id").val();
        var list_id = $("#list_id").val();


        $.ajax({
            url: 'getLabelValue/' + label_name + '/' + list_id + '/' + lead_id,
            type: 'get',
            success: function (response) {

                //console.log($(this).val());
                var hidden_box = $('#setBoxValue').html();
                if (hidden_box == 'subject_box')
                {
                    var cursorPos = $('#subject').prop('selectionStart');
                    var v = $('#subject').val();
                    console.log(v);

                    var textBefore = v.substring(0, cursorPos);
                    var textAfter = v.substring(cursorPos, v.length);
                    $('#subject').val(textBefore + response + textAfter);
                }
                else
                {
                    for (var i in CKEDITOR.instances) {
                        //console.log(response);
                        CKEDITOR.instances[i].insertHtml(response);
                    }
                }
            }
        });
    });

    $("#multiple_names").on('change', function () {
        //console.log($(this).val());
        var sender_id = $(this).val();
        $.ajax({
            url: 'getSenderValue/' + sender_id,
            type: 'get',
            success: function (response) {
                var hidden_box = $('#setBoxValue').html();
                if (hidden_box == 'subject_box')
                {
                    var cursorPos = $('#subject').prop('selectionStart');
                    var v = $('#subject').val();
                    //console.log(v);

                    var textBefore = v.substring(0, cursorPos);
                    var textAfter = v.substring(cursorPos, v.length);
                    $('#subject').val(textBefore + response + textAfter);
                }
                else
                {
                    for (var i in CKEDITOR.instances) {
                        CKEDITOR.instances[i].insertHtml(response);
                    }
                }
            }
        });
    });

    $("#templates").on('change', function () {
        console.log("Template change called");
        var output = '';
        CKEDITOR.instances['editor1'].setData(output);

        var template_id = this.value;
        var lead_id = $("#lead_id").val();
        var list_id = $("#list_id").val();

        $.ajax({
            url: 'getTemplate/' + template_id + '/' + list_id + '/' + lead_id,
            type: 'get',
            success: function(response){
                $("#subject").val(response['subject']);
                for (var i in CKEDITOR.instances) {
                    CKEDITOR.instances[i].insertHtml(response['template_html']);
                    var editor = CKEDITOR.instances[i];
                    editor.on('contentDom', function () {
                        var editable = editor.editable();
                        editable.attachListener(editable, 'click', function () {
                            //console.log("click event");
                            $('#setBoxValue').html('');
                        });
                    });
                }
            }
        });
    });

    $('#subject').on('click', function () {
        $('#setBoxValue').html('subject_box');
    });
});



$("#start_dialing").on('click', function () {
    var campaign = $("#campaign").val();
    if (campaign != '') {
        $('.form-dialer').submit(function () {
            $("#start_dialing").prop('disabled', true);
            return true;
        });
    } else {
        $("#form_error").html("Please select Campaign");
    }
});

$("#dialPad").click(function () {
    $("#dialPadModal").modal();
});

$("#btn-hangup").click(function () {
    $("input[name=disposition]").prop('checked', false);
    $("#disposition-panel").toggle();
});
$("#reload-lead").click(function (event) {
    $("#block-reload-lead").hide();
    event.preventDefault();
    event.stopPropagation();
    location.reload();
});

$('.form-control').keypress(function (e) {
    var c = String.fromCharCode(e.which);
    if (c.toUpperCase() === c && c.toLowerCase() !== c && !e.shiftKey) {
        $('#message').show();
    } else {
        $('#message').hide();
    }
});


$(document).on('click', '.alternate_phone_btn', function(){
    var nxt_call = $(this).data('nxt_call');
    var lead_id = $(this).data('lead_id');
    var list_id = $(this).data('list_id');
    var csrf_token = $('meta[name="csrf-token"]').attr('content');
    $.ajax({
        async: false,
        type: "POST",
        url: "/add-new-lead-pd",
        data : { 'nxt_call' : nxt_call, 'lead_id' : lead_id , 'list_id': list_id , 'csrf_token': csrf_token },
        dataType: "json",
        success: function(data) {
            $("#csrf-token").val(data.token);
            return true;
        },
        error: function(xhr, status, error) {
            return false;
        }
    });
    
});