function formatPhoneNumber(phoneNumber) {
    // Extract the last 10 digits of the phone number
    const lastTenDigits = phoneNumber.slice(-10);

    // Format the last 10 digits
    const formattedLastTenDigits = lastTenDigits.replace(/(\d{3})(\d{3})(\d{4})/, '($1) $2-$3');

    // Combine the front digits with the formatted last 10 digits
    const formattedNumber = "+" + phoneNumber.slice(0, -10) + formattedLastTenDigits;
    
    return formattedNumber;
}



//$(window).load(function() {
$(function () {

var lead_detail_class_box = $('.lead-detail-class-box').attr('value');

$.ajax({
    url: base_url + '/messaging_modal_box_data',
    type: 'POST', // http method
    dataType: "json",
    data: {"_token": $('meta[name="csrf-token"]').attr('content') , 'lead_id': lead_detail_class_box }, // data to submit
    success: function (data) {
        var sms_var = data['sms_data'];
        var c_num = data['c_number'];
        let dropdown = $('#sms_template_list');
        var userRole = data['role'];

        dropdown.empty();
        dropdown.append('<option value="">--SELECT SMS TEMPLATE--</option>');
        dropdown.prop('selectedIndex', 0);
        $.each(sms_var.crm_sms, function (key, entry) {
            dropdown.append($('<option></option>').attr('value', entry.id).text(entry.template_name));
        })

        let dropdown_tab = $('#sms_template_list_tab');
        dropdown_tab.empty();
        dropdown_tab.append('<option value="">--SELECT SMS TEMPLATE--</option>');
        dropdown_tab.prop('selectedIndex', 0);
        $.each(sms_var.sms, function (key, entry) {
            dropdown_tab.append($('<option></option>').attr('value', entry.templete_id).text(entry.templete_name));
        })


		if(c_num.length==0){
			$('#sms_box_1').hide();
			$('#sms_box_2').show();
			$('#singlebutton').hide();

		}

        let agent_phone = $('#agent_phone');
        agent_phone.empty();
        // console.log(sms_var, c_num);
        $.each(c_num, function (key1, entry1) {
            const formattedPhoneNumber = formatPhoneNumber(entry1.cli);
         let optionLabel = formattedPhoneNumber;
           if (userRole === 'system_administrator' && entry1.voip_provider) {
        optionLabel += " (" + entry1.voip_provider.charAt(0).toUpperCase() + entry1.voip_provider.slice(1) + ")";
    }
                agent_phone.append($('<option></option>').attr('value', entry1.cli).text(optionLabel));        });
        

        let agent_phone_tab = $('#agent_phone_tab');
        agent_phone_tab.empty();
        // console.log(sms_var, c_num);
        const formattedPhoneNumber = formatPhoneNumber(entry1.cli);
        $.each(c_num, function (key1, entry1) {
            agent_phone_tab.append($('<option></option>').attr('value', entry1.cli).text(formattedPhoneNumber));
        })
    },
    error: function (jqXhr, textStatus, errorMessage) {
        console.log('Error' + errorMessage);
    }
});


$('#sms_template_list').on('change', function () {
    let sms_val = $(this).val();
    let lead_id = $('#lead_id_crm').val();
   // alert(lead_id);
    $.ajax({
        url: base_url + '/messaging_modal_sms_template_review_crm',
        type: 'POST', // http method
        dataType: "json",
        data: {"_token": $('meta[name="csrf-token"]').attr('content'), 'sms_tpl_id': sms_val, 'lead_id': lead_id}, // data to submit
        success: function (data) {
            $('#preview_sms_id').val(data);
            $('#preview_sms_id_tab').val(data);

            //$('#preview_sms_id').html(data);
            var n = data.length;
            var remaning_word = 190 - n;
            $('#count_word').html(remaning_word);
			if(remaning_word>=0){
				$('#singlebutton').prop('disabled', false);
			}else{
				$('#singlebutton').prop('disabled', true);
			}
        },
        error: function (jqXhr, textStatus, errorMessage) {
            console.log('Error' + errorMessage);
        }
    });
})

$("#preview_sms_id").keyup(function () {
    // Getting the current value of textarea
    var currentText = $(this).val();
    var n = currentText.length;
    var remaning_word = 190 - n;
    $('#count_word').html(remaning_word);
    $('#preview_id').html(currentText);
    if(remaning_word>=0){
        $('#singlebutton').prop('disabled', false);
    }else{
		$('#singlebutton').prop('disabled', true);
	}
});

$('#myModal_open').on('hidden.bs.modal', function () {
    // Re-enable the button when the modal is hidden (closed)
    $('#singlebuttonCrm').prop('disabled', false);
});
/// Send sms
$('#singlebuttonCrm').on('click', function () {
     lead_id = $('#lead_id_crm').val();
    message = $("#preview_sms_id").val();
    fileInput = $('#sms_file')[0].files[0];

    // Check if a video file is uploaded
    isVideoFile = fileInput && fileInput.type.startsWith('video/');
    // Validate message only if no video file is uploaded
    if (!isVideoFile && !message.trim()) {
        toastr.error("Please write a message");
        return false;
    }
        country_code = $("#country_code").val();
    let agent_phone = $("#agent_phone").val();

    if (!agent_phone) {   // catches both "" and null
        toastr.error("Please select/enable a phone number from DID");
    }

    let to = $("#send_phone_crm").val();
    if (!to) {
    toastr.error("Please enter Number");
    return false;
}

    if (to === "") {
        toastr.error("Please enter Number");
       
    } else {
        // Remove non-numeric characters
        to = to.replace(/\D/g, '');

        // Check if the cleaned value has exactly 10 digits
        if (to.length !== 10) {
            toastr.error("Please enter a 10-digit number");
           
            return false;
        }
    }

    var formData = new FormData();
    formData.append('sms_file', $('#sms_file')[0].files[0]);
    formData.append('from', $('#agent_phone').val());
    formData.append('to', country_code + to);
    formData.append('message', $('#preview_sms_id').val());
    formData.append('created_date', moment.utc().format('YYYY-MM-DD HH:mm:ss'));
    formData.append('mms_url', $('#mms_url').val());
    formData.append('lead_id', $('#lead_id_crm').val());
    $.ajax({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        url: '/send_sms_dialer',
        method: 'post',
        data: formData,
        contentType: false,
        processData: false,
        success: function (response) {
            console.log(response);
            toastr.success('Sms sent successfully');
              $('#myModal_open').modal('hide');

              //let res = response.original;
               // response is already a JS object
        // if (!res.success) {
        //     Swal.fire({
        //         icon: 'error',
        //         title: 'Error',
        //         text: response.message,
        //     });
        //     return;
        // }

        // // SUCCESS CASE
        // Swal.fire({
        //     icon: 'success',
        //     title: 'Success',
        //     text: response.message,
        // }).then(() => {
        //     window.location.reload();
        // });
            // Handle success
            // Reset other form fields
            $('#sms_template_list').val('');
            $('#preview_sms_id').val('');
            $('#mms_url').val('');
            $('#sms_file').val('');
            $('#lead_id_crm').val();
            $('#previewImage').attr('src', '').hide();
            $('#previewPDF').attr('src', '').css('display', 'none');

                let userObj = $.getJSON(response);

          var returnedData = JSON.parse(response);
        //   if(!returnedData.success ||returnedData.success==="false"){
        //     Swal.fire({
        //         icon: 'error',
        //         title: 'Error',
        //         text: returnedData.message,
        //     });

        //   } else{
        //     $('#myModal_open').modal('hide');

        //     Swal.fire({
        //         icon: 'success',
        //         title: 'Success',
        //         text: returnedData.message,
        //     });
        //     window.location.reload();

            //   $('.sms_popup_send').addClass('alert-success');
            //   $('.sms_popup_send').html(returnedData.message);
            //   $('.sms_popup_send').css( "visibility", "visible" );
            //   $('.sms_popup_send').show();
          //}
          $('.sms_popup_send').fadeOut(6000);
          $('#singlebuttonCrm').prop('disabled', true);          
//           setTimeout(function() {
//   $('#myModal_open').modal('hide');
// }, 7000);
        },
        error: function (errors) {
          
                     $('#singlebutton').prop('disabled', false);
        }
     
    });
});


// $('#singlebuttonCrm').on('click',function(){
//    // $(this).prop('disabled', true);
//   var to_phone = $('#send_phone_crm').val();
//   var agent_phone = $('#agent_phone').val();
//   var sms_txt = $('#preview_sms_id').val();
//   var sms_template_list = $('#sms_template_list').val();
//   var mms_url = $('#mms_url').val();
//   var sms_file = $('#sms_file').val();
//   if(to_phone==''){
//       $('#send_phone_crm').focus();
//       return false;
//   }
//   if(agent_phone==''){
//       $('#agent_phone').focus();
//       return false;
//   }
//   if(sms_template_list=='' ){
//     //  $('#sms_template_list').focus();
//     //  return false;
//   }
//   if(sms_txt==''){
//       $('#preview_sms_id').focus();
//       return false;
//   }

//   // 1 added before lead no
// //   $('#singlebuttonCrm').prop('disabled', true);
//   var created_date = moment.utc().format('YYYY-MM-DD HH:mm:ss');
//     $.ajax({
//         headers: {
//             'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
//         },
        
//        // url: 'send_sms_dialer/' + agent_phone + '/' + to_phone + '/' + preview_sms_id,
//         url: '/send_sms_dialer',
//         method:'post',
//         //data : { 'from' : agent_phone , 'to' : "1"+to_phone , 'message': sms_txt , 'created_date':created_date},
//         data : { 'from' : agent_phone , 'to' : "1"+to_phone , 'message': sms_txt , 'created_date':created_date,'mms_url':mms_url,'sms_file':sms_file},

//         type: 'get',
//         success: function (response) {
//           //let userObj = $.getJSON(response);

//           var returnedData = JSON.parse(response);
//           if(returnedData.success==="false"){
//               $('.sms_popup_send').addClass('alert-danger');
//               $('.sms_popup_send').html(returnedData.message);
//               $('.sms_popup_send').css( "visibility", "visible" );
//               $('.sms_popup_send').show();

//           } else{
//               $('.sms_popup_send').addClass('alert-success');
//               $('.sms_popup_send').html(returnedData.message);
//               $('.sms_popup_send').css( "visibility", "visible" );
//               $('.sms_popup_send').show();
//           }
//           $('.sms_popup_send').fadeOut(6000);
//         //   $('#singlebuttonCrm').prop('disabled', false);
          
// //           setTimeout(function() {
// //   $('#myModal_open').modal('hide');
// // }, 7000);

//         },
//         error: function(errors) {
//            $('#sms_popup_send').addClass('alert-success');
//               $('#sms_popup_send').html('Error Message');
//              $('#singlebutton').prop('disabled', false);
//         }

//     });
// });




 //$(this).prop('disabled', false);
$('#btn_send_sms').on('click',function(){
    $('#preview_sms_id').val("");
    $("#sms_template_list").prop('selectedIndex','');
    let cont_number_sms = $(this).attr('data-contact');
    $('#send_phone').val(cont_number_sms)
});

});
