/**
* Get notitfication for unread sms, text and voicemail count
* Data shown on header bell icon
* @return type
*/
function getNotificationsCounts() {
       // Only proceed if on the dashboard page
    if (!window.location.href.includes("dashboard")) {
        return;
    }
    $.ajax({
        type: 'POST',
        url: '/get-notification-counts',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
            // Add any other headers if needed
        },
        success: function (result) {
            // Check if total_unread_count is greater than 0
            if (result.total_unread_count > 0) {
                $('.notification_id_total_count').text(result.total_unread_count);
            } else {
                // If total_unread_count is 0 or less, hide the span
                $('#notification_id_total_count').hide();
            }

            // Check if unread_sms_count is greater than 0
            if (result.unread_sms_count > 0) {
                $('.notification_id_text_count').show();
                $('#notification_id_text_count').text(result.unread_sms_count);
            } else {
                // If unread_sms_count is 0 or less, hide the span
                $('.notification_id_text_count').hide();
            }

            // Check if unread_mailbox_count is greater than 0
            if (result.unread_mailbox_count > 0) {
                $('.notification_id_voicemail_count').show();
                $('#notification_id_voicemail_count').text(result.unread_mailbox_count);
            } else {
                // If unread_mailbox_count is 0 or less, hide the span
                $('.notification_id_voicemail_count').hide();
            }

            // Check if unread_fax_count is greater than 0
            if (result.unread_fax_count > 0) {
                $('.notification_id_fax_count').show();
                $('#notification_id_fax_count').text(result.unread_fax_count);
            } else {
                // If unread_fax_count is 0 or less, hide the span
                $('.notification_id_fax_count').hide();
            }
        },
        error: function (data) {
            console.log(data);
        }
    });
}

