$(function () {
    $(document).ready(function () {
        function formatPrice(value) {
            // Always return with two decimals
            return parseFloat(value).toFixed(2);
        }

        $(".number-of-users .minus").click(function () {
            var input = $(this).parent().find("input");
            var count = parseInt(input.val()) - 1;
            var page = $(this).data("page");

            if (page === "upgrade") {
                count = count < 1 ? 0 : count;
                input.val(count);
                input.change();
                return;
            }

            if (page === "cart" && count < 1) {
                return;
            }

            count = count < 1 ? 1 : count;
            input.val(count);
            input.change();

            if (page === "cart") {
                var subTotal = 0;
                var Id = $(this).parents(".number-of-users").data("id");
                var taxPrice = parseFloat($(".tax-price").data("price"));
                var shippingPrice = parseFloat(
                    $(".shipping-price").data("price")
                );
                var CurrentProductPrice = parseFloat(
                    $(this).closest("tr").find(".product-price").data("price")
                );
                var billing = parseFloat(
                    $(this)
                        .closest("tr")
                        .find(".billing-period")
                        .data("billing")
                );

                // Calculate product total with 2 decimals
                var productTotal = CurrentProductPrice * billing * input.val();
                $(this)
                    .closest("tr")
                    .find(".product-price")
                    .text("$" + formatPrice(productTotal));

                //Calculate Amount Due (sum of all product prices)
                $(".product-price").each(function (i, element) {
                    subTotal += parseFloat($(element).text().replace("$", ""));
                });
                var grandTotal = subTotal + taxPrice + shippingPrice;

                //Assign Amount Due with 2 decimals
                $(".subtotal-price").text("$" + formatPrice(subTotal));
                $(".grand-total").text("$" + formatPrice(grandTotal));

                // Add CSRF token to the data
                var csrfToken = $('meta[name="csrf-token"]').attr("content");
                $.ajax({
                    url: "/cart/update/" + Id,
                    type: "POST",
                    data: {
                        operation: "minus",
                        _token: csrfToken, // Include the CSRF token here
                    },
                    dataType: "json",
                    success: function (response) {
                        toastr.success(response);
                    },
                });
            }
        });

        $(".number-of-users .plus").click(function () {
            var input = $(this).parent().find("input");
            var page = $(this).data("page");
            input.val(parseInt(input.val()) + 1);
            input.change();

            if (page === "cart") {
                var subTotal = 0;
                var Id = $(this).parents(".number-of-users").data("id");
                var taxPrice = parseFloat($(".tax-price").data("price"));
                var shippingPrice = parseFloat(
                    $(".shipping-price").data("price")
                );
                var CurrentProductPrice = parseFloat(
                    $(this).closest("tr").find(".product-price").data("price")
                );
                var billing = parseFloat(
                    $(this)
                        .closest("tr")
                        .find(".billing-period")
                        .data("billing")
                );

                // Calculate product total with 2 decimals
                var productTotal = CurrentProductPrice * billing * input.val();
                $(this)
                    .closest("tr")
                    .find(".product-price")
                    .text("$" + formatPrice(productTotal));

                //Calculate Amount Due (sum of all product prices)
                $(".product-price").each(function (i, element) {
                    subTotal += parseFloat($(element).text().replace("$", ""));
                });
                var grandTotal = subTotal + taxPrice + shippingPrice;

                //Assign Amount Due with 2 decimals
                $(".subtotal-price").text("$" + formatPrice(subTotal));
                $(".grand-total").text("$" + formatPrice(grandTotal));

                var csrfToken = $('meta[name="csrf-token"]').attr("content");
                $.ajax({
                    url: "/cart/update/" + Id,
                    type: "POST",
                    data: {
                        operation: "plus",
                        _token: csrfToken, // Include the CSRF token here
                    },
                    dataType: "json",
                    success: function (response) {
                        toastr.success(response);
                    },
                });
            }
        });
    });

    function updateCartCount() {
        fetch("/cart/count")
            .then((response) => response.json())
            .then((data) => {
                let count = 0;
                if (Array.isArray(data)) {
                    count = data[0];
                }
                document.getElementById("cart-count-badge").textContent = count;
            })
            .catch((err) => console.error("Error fetching cart count:", err));
    }

    $(document).on("click", ".add-to-cart", function (e) {
        e.preventDefault();
        var billingPeriod = $(this)
            .parents(".info")
            .find(".billing-type")
            .val();
        var NoOfUsers = $(this)
            .parents(".info")
            .find(".number-of-users input")
            .val();
        var selectedPackage = $(this).siblings(".selected-package").val();

        if (billingPeriod === "#") {
            toastr.error("Please select Billing Period.");
            return;
        }
        if (NoOfUsers === "0") {
            toastr.error("Please select No of Users.");
            return;
        }
        var csrfToken = $('meta[name="csrf-token"]').attr("content");

        $.ajax({
            url: "/cart/add/" + selectedPackage,
            type: "POST",
            data: {
                billingPeriod: billingPeriod,
                NoOfUsers: NoOfUsers,
                _token: csrfToken, // Include the CSRF token here
            },
            dataType: "json",
            success: function (response) {
                $oldValue = $(
                    ".right-panel .shopping-cart span.label.label-success"
                ).text();
                $(".right-panel .shopping-cart span.label.label-success").text(
                    Number($oldValue) + 1
                );
                 // quietly add: show cart icon if hidden
                var $cartItem = $(".btn-group.nav-item");
                if ($cartItem.hasClass("d-none")) {
                    $cartItem.removeClass("d-none");
                }
                updateCartCount();
                toastr.success(response);
            },
        });
        $(this)
            .parents(".info")
            .find(".billing-type option:selected")
            .removeAttr("selected");
        $(this).parents(".info").find(".number-of-users input").val(0);
    });

    $(document).on("click", ".delete-cart-item", function (e) {
        e.preventDefault();
        var Id = $(this).data("id");
        var csrfToken = $('meta[name="csrf-token"]').attr("content");

        $.ajax({
            url: "/cart/delete/" + Id,
            type: "POST",
            _token: csrfToken, // Include the CSRF token here
            success: function (response) {
                toastr.success(response);
                location.reload();
            },
        });
    });
});
