$(document).ready(function () {
    $(document).on("customChatBoxHiddenEvent", function () {
        // Re-enable the button when the custom event is triggered
        $("#sendNewSms").prop("disabled", false);
    });

    $("#sendNewSms").on("click", function () {
        $("#left_box").show();
        $("#right_new_msg").show();

        countryCode = $("#countryCode").val();
        to = $("#new_to").val();

        if (to === "") {
            toastr.error("Please enter Number");
            $("#left_box").hide();
            $("#right_new_msg").hide();
                    $(".loading").hide();

            return false;
        } else {
            // Remove non-numeric characters
            to = to.replace(/\D/g, "");

            // Check if the cleaned value has exactly 10 digits
            if (to.length !== 10) {
                toastr.error("Please enter a 10-digit number");
                $("#left_box").hide();
                $("#right_new_msg").hide();
                $(".loading").hide();

                return false;
            }
        }

        from = $("#new_from").val();
        if (from == "") {
            toastr.error("Please select/enable a phone number from DID");
            $("#left_box").hide();
            $("#right_new_msg").hide();
            $(".loading").hide();

            return false;
        }

        message = $("#new_message").val();
        if (message == "") {
            toastr.error("Please write message");
            $("#left_box").hide();
            $("#right_new_msg").hide();
             $(".loading").hide();

            return false;
        }

        to = countryCode + to;
        var created_date = moment.utc().format("YYYY-MM-DD HH:mm:ss");

        // Get the file input element
        var fileInput = $("#sms_file")[0];
   if (fileInput && fileInput.files.length > 0) {
    toastr.error("MMS not enabled. Please remove the file before sending.");
    $(".loading").hide();
    $("#left_box").hide();
    return false;
}
        // Create a FormData object
        var formData = new FormData();

        // Append the file data to the FormData object
        formData.append("sms_file", fileInput.files[0]);

        // Append other data to the FormData object
        formData.append("from", from);
        formData.append("to", to);
        formData.append("message", message);
        formData.append("created_date", created_date);

        var jqXhr = $.ajax({
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            },

            url: "sendSms",
            type: "post",
            dataType: "json",
            data: formData,
            contentType: false,
            processData: false,
        });

        jqXhr
            .done(function (data) {
                $("#right_new_msg").hide();
                if (data.success === true || data.success === "true") {
                    $("#sms_file").val("");
                    $("#previewImage").attr("src", "").hide();
                    $("#previewPDF").attr("src", "").css("display", "none");
                    $("#sendNewSms").prop("disabled", true);
                    var div_close = "alert-success";
                    toastr.success(data.message);
                    // This is where you hide the chat box
                    $("#hide_new_message_div").hide();

                    // Trigger a custom event when the chat box is hidden
                    $("#hide_new_message_div").trigger(
                        "customChatBoxHiddenEvent"
                    );
                } else {
                    toastr.success(data.message);
                    var div_close = "alert-danger";
                    $("#left_box").hide();
                }

                $("." + div_close)
                    .delay(4000)
                    .slideUp(1000, function () {
                        $(this).alert("close");
                    });
            })
            .done(function (data) {
                $.ajax({
                    url: "recentSmsList",
                    type: "get",
                    dataType: "json",
                    success: function (response_data) {
                        $("#hiddenAfterSms").html("");
                        var res_length = Object.keys(response_data.data).length;
                        if (res_length > 0) {
                            // console.log(dataobj);
                            $("#hiddenAfterSms").html("");
                            var counter = 1;
                            var elem =
                                document.getElementById("hiddenAfterSms");
                            for (var i = 0; i < res_length; i++) {
                                var obj = response_data.data[i];

                                if (obj.status == "0") {
                                    status = "font-weight:bold";
                                } else {
                                    status = "";
                                }
                                var localTime = moment.utc(obj.date).local();
                                var created_date =
                                    localTime.format("YYYY-MM-DD HH:mm");
                                elem.innerHTML =
                                    elem.innerHTML +
                                    '<tr class="authTabs" id="' +
                                    obj.number +
                                    "_" +
                                    obj.did +
                                    '" style="' +
                                    status +
                                    '" onclick="openDiv(' +
                                    obj.number +
                                    "," +
                                    obj.did +
                                    ');"><td>' +
                                    counter++ +
                                    "</td><td>" +
                                    "" +
                                    '</td><td class="mailbox-name"  >' +
                                   formatPhoneNumber(obj.number) +
                                    '</td><td class="mailbox-name"  >' +
                                    formatPhoneNumber(obj.did) +
                                    '</td><td class="mailbox-subject">' +
                                    obj.message +
                                    '</td><td class="mailbox-date" style="width:180px;">' +
                                    created_date +
                                    "</td></tr>";
                            }
                        }
                        $("#left_box").hide();
                    },
                });
            })
            .done(function (data) {
                $.ajax({
                    url: "openSmsDetails",
                    data: { from: from, to: to },
                    type: "get",
                    success: function (response) {
                    
                        $("#div_number").val(to);
                        $("#div_did").val(from);
                        $("#sms_list").show();
                        $("#hide_new_message_div").hide();
                        for (var i = 0; i < response.length; i++) {
                            var obj = response[i];
                            var ele = document.getElementById("show");
                            const chatBoxEl = document.getElementById("chatBoxNumber");
if (chatBoxEl && obj.number) {
    chatBoxEl.textContent = formatPhoneNumber(obj.number);
}

                               const dateObj = new Date(obj.date);
        const options = {
            weekday: "long",
            hour: "numeric",
            minute: "numeric",
            hour12: true,
        };
        const formattedDate = dateObj.toLocaleString("en-US", options);

        ele.innerHTML +=
            '<div style="text-align:center; font-size:12px; color:#888; margin:10px 0;">' + formattedDate + "</div>";

        if (obj.type === "incoming") {
            ele.innerHTML +=
                '<div style="display:flex; justify-content:flex-start; margin:6px 0;">' +
                '<div style="max-width:75%; background:#f3f6f9; color:#000; border-radius:18px; border-top-left-radius:0; padding:8px 12px; box-shadow:0 1px 3px rgba(0,0,0,0.1);">' +
                obj.message +
                getImageTag(obj.mms_url) +
                "</div></div>";
        } else {
            ele.innerHTML +=
                '<div style="display:flex; justify-content:flex-end; margin:6px 0;">' +
                '<div style="max-width:75%; background:#007bff; color:#fff; border-radius:18px; border-top-right-radius:0; padding:8px 12px; box-shadow:0 1px 3px rgba(0,0,0,0.1); text-align:left;">' +
                obj.message +
                getImageTag(obj.mms_url) +
                "</div></div>";
        }
                        }
                    },
                });
            })
            .fail(function (xhr) {
                console.log("error callback 1", xhr);
            })
            .fail(function (xhr) {
                console.log("error callback 1", xhr);
            })
            .fail(function (xhr) {
                console.log(xhr);
                console.log("error common back", xhr);
            });
    });

    $("#sendNewSms1").click(function () {
        $("#hide_new_message_div").hide();
        $("#sms_list").show();
        $("#openNewMessage").show();
        message = $("#new_message").val();
        if (message == "") {
            $("#new_message_errorMsg").html("Please write message");
            return false;
        }

        to = $("#new_to").val();
        if (to == "") {
            $("#new_to_errorMsg").html("Please enter Number");
            return false;
        }

        from = $("#new_from").val();
        if (from == "") {
            $("#new_from_errorMsg").html("Please select DID");
            return false;
        }
        $(".loading").show();

        $.ajax({
            url: "sendSms",
            type: "get",
            dataType: "json",
            data: { from: from, to: to, message: message },
            success: function (response) {
                $("#hiddenAfterSms").html("");
                var counter = 1;
                for (var i = 0; i < response.length; i++) {
                    var elem = document.getElementById("hiddenAfterSms");
                    for (var j = 0; j < response[i].length; j++) {
                        var obj = response[i][j];
                        if (obj.status == "0") {
                            status = "font-weight:bold";
                        } else {
                            status = "";
                        }
                        elem.innerHTML =
                            elem.innerHTML +
                            '<tr class="authTabs" id="' +
                            obj.number +
                            "_" +
                            obj.did +
                            '" style="' +
                            status +
                            '" onclick="openDiv(' +
                            obj.number +
                            "," +
                            obj.did +
                            ');"><td>' +
                            counter++ +
                            "</td><td>" +
                            "" +
                            '</td><td class="mailbox-name"  >' +
                            obj.number +
                            '</td><td class="mailbox-name"  >' +
                            obj.did +
                            '</td><td class="mailbox-subject">' +
                            obj.message +
                            '</td><td class="mailbox-date">' +
                            obj.date +
                            "</td></tr>";
                    }
                }

                $.ajax({
                    url: "openSmsDetails",
                    data: { from: from, to: to },
                    type: "get",
                    success: function (response) {
                        //$("#show").html('');
                        for (var i = 0; i < response.length; i++) {
                            var obj = response[i];
                            var ele = document.getElementById("show");
                               const dateObj = new Date(obj.date);
        const options = {
            weekday: "long",
            hour: "numeric",
            minute: "numeric",
            hour12: true,
        };
        const formattedDate = dateObj.toLocaleString("en-US", options);

        ele.innerHTML +=
            '<div style="text-align:center; font-size:12px; color:#888; margin:10px 0;">' + formattedDate + "</div>";

        if (obj.type === "incoming") {
            ele.innerHTML +=
                '<div style="display:flex; justify-content:flex-start; margin:6px 0;">' +
                '<div style="max-width:75%; background:#f3f6f9; color:#000; border-radius:18px; border-top-left-radius:0; padding:8px 12px; box-shadow:0 1px 3px rgba(0,0,0,0.1);">' +
                obj.message +
                getImageTag(obj.mms_url) +
                "</div></div>";
        } else {
            ele.innerHTML +=
                '<div style="display:flex; justify-content:flex-end; margin:6px 0;">' +
                '<div style="max-width:75%; background:#007bff; color:#fff; border-radius:18px; border-top-right-radius:0; padding:8px 12px; box-shadow:0 1px 3px rgba(0,0,0,0.1); text-align:left;">' +
                obj.message +
                getImageTag(obj.mms_url) +
                "</div></div>";
        }
                        }
                    },
                });

                //$("#divLoading").hide();
                $(".loading").hide();
            },
        });
    });

    // template_blog

    //
    /// closed new sms code //////////

    $("#sendSmsold").on("click", function () {
        message = $(".div_message").val();
        if (message == "") {
            $("#errorMsg").html("Please write message");
            return false;
        }

        //$("#divLoading").show();
        $(".loading").show();
        to = $("#div_number").val();
        from = $("#div_did").val();
        message = $(".div_message").val();
        $.ajax({
            url: "sendSms/" + from + "/" + to + "/" + message,
            type: "get",
            success: function (response) {
                $("#hiddenAfterSms").html("");
                var counter = 1;
                for (var i = 0; i < response.length; i++) {
                    var elem = document.getElementById("hiddenAfterSms");

                    for (var j = 0; j < response[i].length; j++) {
                        var obj = response[i][j];

                        if (obj.status == "0") {
                            status = "font-weight:bold";
                        } else {
                            status = "";
                        }
                        elem.innerHTML =
                            elem.innerHTML +
                            '<tr class="authTabs" id="' +
                            obj.number +
                            "_" +
                            obj.did +
                            '" style="' +
                            status +
                            '" onclick="openDiv(' +
                            obj.number +
                            "," +
                            obj.did +
                            ');"><td>' +
                            counter++ +
                            "</td><td>" +
                            "" +
                            '</td><td class="mailbox-name"  >' +
                            obj.number +
                            '</td><td class="mailbox-name"  >' +
                            obj.did +
                            '</td><td class="mailbox-subject">' +
                            obj.message +
                            '</td><td class="mailbox-date">' +
                            obj.date +
                            "</td></tr>";
                    }
                }

                $("#show").animate(
                    { scrollTop: $("#show")[0].scrollHeight },
                    1000
                );
                $.ajax({
                    url: "openSmsDetails",
                    data: { from: from, to: to },
                    type: "get",
                    success: function (response) {
                        $("#show").html("");
                        for (var i = 0; i < response.length; i++) {
                            var obj = response[i];

                            var ele = document.getElementById("show");

                            if (obj.type == "incoming") {
                                ele.innerHTML =
                                    ele.innerHTML +
                                    ' <div class="chat-box-body"><div class="chat-msg user"><div class="d-flex align-items-center"><div class="mx-10"><a class="text-dark hover-primary fw-bold"><i style="color:green;" class="fa fa-arrow-down" aria-hidden="true"></i>' +
                                    obj.number +
                                    '</a><p class="text-muted fs-12 mb-0">' +
                                    obj.date +
                                    '</p></div></div> <div class="cm-msg-text">' +
                                    obj.message +
                                    "</div></div>";
                            }

                            if (obj.type == "outgoing") {
                                ele.innerHTML =
                                    ele.innerHTML +
                                    '<div class="chat-box-body"> <div class="chat-msg self"><div class="d-flex align-items-center justify-content-end"><div class="mx-10"><a class="text-dark hover-primary fw-bold"><i style="color:green;" class="fa fa-arrow-up" aria-hidden="true"></i>You<br>' +
                                    obj.number +
                                    '</a><p class="text-muted fs-12 mb-0">' +
                                    obj.date +
                                    '</p></div></div><div class="cm-msg-text">' +
                                    obj.message +
                                    "</div></div>";
                            }
                            // alert(obj.id);
                        }
                    },
                });
                //$("#divLoading").hide();
                $(".loading").hide();

                $(".div_message").val("");
            },
        });
    });

    $(".sendSms").on("click", function () {
        $("#left_box").show();
        $("#right_list_msg").show();
        to = $("#div_number").val();
        from = $("#div_did").val();
        message = $(".div_message").val();
        var sms_file = $("#fileInput")[0].files[0]; // ✅ actual file object
        var created_date = moment.utc().format("YYYY-MM-DD HH:mm:ss");
        if (message == "") {
                        $("#left_box").hide();

            toastr.error("Please write message");
            return false;
        }
    if (sms_file) {
        toastr.error("MMS not enabled. Please remove the file before sending.");
        $(".loading").hide();
                    $("#left_box").hide();


        return false; // ⛔ stop sending
    }
        var jqXhr = $.ajax({
            url: "sendSms",
            type: "post",
            dataType: "json",
            data: {
                from: from,
                to: to,
                message: message,
                created_date: created_date,
                sms_file,sms_file,
                _token: $('meta[name="csrf-token"]').attr("content"), // ✅ Add token here
            },
        });

        jqXhr
            .done(function (data) {
                console.log("SMS API Response:", data); // ✅ log full response
                if (
                    data.success === true ||
                    data.success === "true" ||
                    data.success === 1 ||
                    data.success === "1"
                ) {
                    $(".div_message").val("");
                    var div_close = "alert-success";
                    toastr.success(data.message);
                } else {
                    toastr.error(data.message);
                    var div_close = "alert-danger";
                    $("#left_box").hide();
                }

                $("." + div_close)
                    .delay(4000)
                    .slideUp(1000, function () {
                        $(this).alert("close");
                    });
                $("#right_list_msg").hide();
            })
            .done(function (data) {
                $.ajax({
                    url: "recentSmsList",
                    type: "get",
                    dataType: "json",
                    success: function (response_data) {
                        $("#hiddenAfterSms").html("");
                        var counter = 1;
                        var res_length = Object.keys(response_data.data).length;
                        if (res_length > 0) {
                            // console.log(dataobj);
                            $("#hiddenAfterSms").html("");
                            var elem =
                                document.getElementById("hiddenAfterSms");
                            for (var i = 0; i < res_length; i++) {
                                var obj = response_data.data[i];

                                if (obj.status == "0") {
                                    status = "font-weight:bold";
                                } else {
                                    status = "";
                                }

                                var localTime = moment.utc(obj.date).local();
                                var created_date =
                                    localTime.format("YYYY-MM-DD HH:mm");
                                elem.innerHTML =
                                    elem.innerHTML +
                                    '<tr class="authTabs" id="' +
                                    obj.number +
                                    "_" +
                                    obj.did +
                                    '" style="' +
                                    status +
                                    '" onclick="openDiv(' +
                                    obj.number +
                                    "," +
                                    obj.did +
                                    ');">' +
                                    "<td>" +
                                    counter++ +
                                    "</td>" + // ID
                                    "<td></td>" + // Blank TD
                                    '<td class="mailbox-name">' +
                                    formatPhoneNumber(obj.number) +
                                    "</td>" + // CLI
                                    '<td class="mailbox-name">' +
                                    formatPhoneNumber(obj.did) +
                                    "</td>" + // DID
                                    '<td class="mailbox-subject">' +
                                    obj.message +
                                    "</td>" + // Message
                                    '<td class="mailbox-date" style="width:180px;">' +
                                    created_date +
                                    "</td>" + // Date
                                    "</tr>";
                            }
                        }
                    },
                });
            })
            .done(function (data) {
                $("#left_box").hide();
                $.ajax({
                    url: "openSmsDetails",
                    data: { from: from, to: to },
                    type: "get",
                    success: function (response) {
                        for (var i = 0; i < response.length; i++) {
                            var obj = response[i];
                            var ele = document.getElementById("show");
                                  const dateObj = new Date(obj.date);
            const options = {
                weekday: "long",
                hour: "numeric",
                minute: "numeric",
                hour12: true,
            };
        const formattedDate = dateObj.toLocaleString("en-US", options);
        ele.innerHTML += '<div style="text-align:center; font-size:12px; color:#888; margin:10px 0;">' + formattedDate + '</div>';
                            if (obj.type == "incoming") {
                               ele.innerHTML +=
                                '<div style="display:flex; justify-content:flex-start; margin:6px 0;">' +
                                '<div style="max-width:75%; background:#f3f6f9; color:#000; border-radius:18px; border-top-left-radius:0; padding:8px 12px; box-shadow:0 1px 3px rgba(0,0,0,0.1);">' +
                                obj.message +
                                getImageTag(obj.mms_url) +
                                "</div></div>";
                            }
                            if (obj.type == "outgoing") {
                               ele.innerHTML +=
                                '<div style="display:flex; justify-content:flex-end; margin:6px 0;">' +
                                '<div style="max-width:75%; background:#007bff; color:#fff; border-radius:18px; border-top-right-radius:0; padding:8px 12px; box-shadow:0 1px 3px rgba(0,0,0,0.1); text-align:left;">' +
                                obj.message +
                                getImageTag(obj.mms_url) +
                                "</div></div>";
                            }
                        }
                    },
                });
            })
            .fail(function (xhr) {
                console.log("error callback 1", xhr);
            })
            .fail(function (xhr) {
                console.log("error callback 1", xhr);
            })
            .fail(function (xhr) {
                console.log(xhr);
                console.log("error common back", xhr);
            });
    });
  function getImageTag(url) {
        if (!url) return "";
        return '<div><img src="' + url + '" style="width:180px; border-radius:12px; margin-top:8px;"></div>';
    }
    $("#openNewMessage").click(function () {
        $("#hide_new_message_div").show();
        $("#sms_list").hide();
        $(".div_message").val("");
        $("#new_message").val("");
        $("#new_to").val("");
        $("#new_from").val("");
    });
});

function openDiv(number, did) {
    $("#sms_list").show();
    $("#hide_new_message_div").hide();
    $("#openNewMessage").hide();
    $("#show").animate({ scrollTop: $("#show")[0].scrollHeight }, 1000);
    $("#div_number").val(number);
    $("#div_did").val(did);
    $("#show").html("");
    document.getElementById("chatBoxNumber").textContent =
        formatPhoneNumber(number);
    var scrollBottom =
        $(".direct-chat-messages").scrollTop() +
        $(".direct-chat-messages").height();
    $(".direct-chat-messages").animate({ scrollTop: scrollBottom * 100 }, 100);
    console.log(scrollBottom);

    $.ajax({
        url: "openSmsDetails",
        data: { from: did, to: number },
        type: "get",
        success: function (response) {
            $("#" + number + "_" + did).removeAttr("style");
            var ele = document.getElementById("show");
            ele.innerHTML = "";

            let lastDate = "";

            for (var i = 0; i < response.length; i++) {
                var obj = response[i];
                console.log("PDF URL:", obj.mms_url);

                if (obj.date !== lastDate) {
                    // Convert timestamp to Date object
                    const dateObj = new Date(obj.date);

                    // Format: Day + Time (Friday 8:19 PM)
                    const options = {
                        weekday: "long",
                        hour: "numeric",
                        minute: "numeric",
                        hour12: true,
                    };
                    const formattedDate = dateObj.toLocaleString(
                        "en-US",
                        options
                    );

                    ele.innerHTML +=
                        '<div style="text-align:center; font-size:12px; color:#888; margin:10px 0;">' +
                        formattedDate +
                        "</div>";
                    lastDate = obj.date;
                }

                // === Incoming Message (Left, Light Gray #f3f6f9) ===
                if (obj.type == "incoming") {
                    var formattedNumber = formatPhoneNumber(obj.number);

                    if (obj.sms_type == 1) {
                        ele.innerHTML +=
                            '<div class="chat-msg user" style="display:flex; justify-content:flex-start; margin:6px 0;">' +
                            '<div style="max-width:75%; background:#f3f6f9; color:#000; border-radius:18px; border-top-left-radius:0; padding:8px 12px; box-shadow:0 1px 3px rgba(0,0,0,0.1);">' +
                            obj.message +
                            getImageTag(obj.mms_url) +
                            "</div></div>";
                    } else {
                        ele.innerHTML +=
                            '<div class="chat-msg user" style="display:flex; justify-content:flex-start; margin:6px 0;">' +
                            '<div style="max-width:75%; background:#f3f6f9; color:#000; border-radius:18px; border-top-left-radius:0; padding:8px 12px; box-shadow:0 1px 3px rgba(0,0,0,0.1);">' +
                            obj.message +
                            "</div></div>";
                    }
                }

                // === Outgoing Message (Right, Blue #007bff) ===
                if (obj.type == "outgoing") {
                    var formattedNumber = formatPhoneNumber(obj.number);

                    if (obj.sms_type == 1) {
                        ele.innerHTML +=
                            '<div class="chat-msg self" style="display:flex; justify-content:flex-end; margin:6px 0;">' +
                            '<div style="max-width:75%; background:#007bff; color:#fff; border-radius:18px; border-top-right-radius:0; padding:8px 12px; box-shadow:0 1px 3px rgba(0,0,0,0.1); text-align:left;">' +
                            obj.message +
                            getImageTag(obj.mms_url) +
                            "</div></div>";
                    } else {
                        ele.innerHTML +=
                            '<div class="chat-msg self" style="display:flex; justify-content:flex-end; margin:6px 0;">' +
                            '<div style="max-width:75%; background:#007bff; color:#fff; border-radius:18px; border-top-right-radius:0; padding:8px 12px; box-shadow:0 1px 3px rgba(0,0,0,0.1); text-align:left;">' +
                            obj.message +
                            "</div></div>";
                    }
                }
            }
        },
    });

    function getImageTag(mms_url) {
        // Check if the URL ends with '.pdf'
        if (mms_url.toLowerCase().endsWith(".pdf")) {
            // If it's a PDF, return the image tag for the PDF icon
            return '<img src="assets/images/pdf.png"style="height:30px;width:30px;">';
        } else {
            // Otherwise, return an empty string
            return '<img src="' + mms_url + '"style="height:80px;width:80px;">';
        }
    }
}

function formatPhoneNumber(phoneNumber) {
    var cleaned = ("" + phoneNumber).replace(/\D/g, ""); // Remove non-digit characters
    var countryCode = cleaned.slice(0, cleaned.length - 10); // Extract front digits (country code)
    var last10Digits = cleaned.slice(-10); // Get the last 10 digits

    // Add '+' before the country code and format the last 10 digits with parentheses and dashes
    return (
        "+" +
        countryCode +
        " (" +
        last10Digits.replace(/(\d{3})(\d{3})(\d{4})/, "$1) $2-$3")
    );
}

$(document).on("click", ".openSmsSend", function () {
    $("#myModal").modal();
    $("#add-edit").html("Send Sms");
    var id = $(this).data("id");

    $(".closed").hide();
    $.ajax({
        url: "editSms/" + id,
        type: "get",
        success: function (response) {
            $("#number").val(response[0].number);
            $("#did").val(response[0].did);
            $("#id").val("1");
        },
    });
});
