
@extends('layouts.app')
@section('title', 'Sms List')
@section('content')
<style>
  .word-wrap {
    word-wrap: break-word;
    word-break: break-all;
  }
</style>

<section class="content">
			<div class="row">			  
				<div class="col-lg-12 col-12">
					    <div class="box"> 
                            <div id="preloader"style="display:none;">
                                <div id="preloader-status">
                                    <img  src="assets/images/loader-30px.gif">
                                </div>  
                            </div>                          
							<div class="box-body">
								<h4 class="box-title text-info mb-0"><i class="fa fa-edit me-15"></i>Sms Lists</h4>

								<hr class="my-15">
                                <div class="row">
                                        <form method="get">
                                            @csrf
                                            <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label class="form-label">Phone No</label>
                                                            <div class="input-group mb-3">
                                                                <span class="input-group-text"><i class="ti-mobile"></i></span>
                                                                <input type="text" class="form-control" placeholder="Enter Phone Number" type="" name="number" value="{{ request()->input('number') }}" id="number" maxlength="" required>
                                                            </div>
                                                        </div>
                                                    </div>
                                                
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label class="form-label">Cli</label>
                                                            <div class="input-group mb-3">
                                                                <span class="input-group-text"><i class="ti-mobile"></i></span>
                                                                <input type="text" class="form-control" placeholder="Enter Cli"  type="" name="cli" value="{{ request()->input('cli') }}" id="cli" maxlength=""required >
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label class="form-label">Limit</label>
                                                            <div class="input-group mb-3">
                                                                <span class="input-group-text"><i class="ti-user"></i></span>
                                                                <select name="limit" class="form-select" id="limit">
                                                                    <option value="10" {{ request()->input('limit') == '10' ? 'selected' : '' }}>10</option>
                                                                    <option value="20" {{ request()->input('limit') == '20' ? 'selected' : '' }}>20</option>
                                                                    <option value="30" {{ request()->input('limit') == '30' ? 'selected' : '' }}>30</option>
                                                                    <option value="40" {{ request()->input('limit') == '40' ? 'selected' : '' }}>40</option>
                                                                    <option value="50" {{ request()->input('limit') == '50' ? 'selected' : '' }}>50</option>
                                                                </select>                                                            </div>
                                                        </div>
                                            </div>
                                            </div>
                                            
                                </div>                    
                            </div>
                          	<!-- /.box-body -->
							<div class="box-footer text-end"style="margin-right:15px;">
                            <button type="submit" name="submit"   value="Search" class="btn btn btn-primary waves-effect waves-light"><i class="fa fa-search" aria-hidden="true"></i> Search</button>
                            <!-- <button type="submit" name="submit_download" class="btn btn-danger waves-effect waves-light m-l-10" value="1"> <i class="fa fa-file-pdf-o"></i> Download</button>                                      -->
							</div>  
						</form>    
                        </div>
                        
                          
                      
                          
                           
						
					  </div>
					  <!-- /.box -->			

                    </div>  

		
<div class="row"> 
  <div class="col-lg-12 col-12">
    <div class="box">
     <div class="box-body">           
        <div class="table-responsive">
        <table id="tickets" class="table mt-0 table-hover no-wrap did_list_table" data-page-size="10">
            <thead>
              <tr>
                        <th>id</th>
                        <th>Sms id</th>
                        <th>Cli</th>
                        <th>Number</th>
                        <th>Text </th>                       
                        <th>Message Type</th>                       
                        <th>Status</th>                       
                        <th>Time</th>                       
                        <th>Action </th>                       

                      </tr>
            </thead>
            <tbody>
            @foreach($cli_list as $k => $list)
            <tr>
                <td>{{ $k + 1 }}</td>
                <td>{{ $list->sms_id }}</td>
                <td>{{ $list->cli }}</td>
                <td>{{ $list->number }}</td>
                <td>{{ $list->text }}</td>
                <td>{{ $list->messsage_type }}</td>
                <td>{{ $list->status }}</td>
                <td>  @php
        echo \Carbon\Carbon::parse($list->time)->format('d-m-Y H:i');
    @endphp</td>
                <td><a  type="button" data-bs-toggle="modal"  data-bs-target="#myModal-{{ $k }}"data-id="{{$k}}" class="list-icons-item me-10"><i class="fa fa-eye fa-lg"></i></a>
                </td>
                  
                <div id="myModal-{{ $k }}" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
        
        
        <!-- /.box-header -->
          <div class="box-body">
        

        <!-- form itself -->
        <form id="test-form" class="mfp-hide white-popup-block">
          <h4><i class="icon-Add-user"><span class="path1"></span><span class="path2"></span></i> Sms List <button style="padding: 5px 11px 5px 11px;" type="button" class="btn btn-danger float-end" data-bs-dismiss="modal">X</button></h4>
          <hr>
          <div class="row">
          <div class="col-md-6">
          <div class="form-group">
              <i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputName">Sms id</label>
              <p class="word-wrap"><span class="badge badge-md badge-primary">{{$list->sms_id}}<span></p>
            </div>
       
            <div class="form-group">
              <i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputEmail">Number</label>
              @if($list->number)
              <p><span class="badge badge-md badge-primary">{{$list->number}}<span></p>
              @else<p>-</p>
             @endif
            </div>
            <div class="form-group">
              <i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputPhone">Message Type</label>
              @if($list->messsage_type)
              <p class="word-wrap"><span class="badge badge-md badge-primary mobile">{{$list->messsage_type}}<span></p>
              @else<p>-</p>
              @endif
            </div>
            <div class="form-group">
              <i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputPhone">Text</label>
              @if($list->text)
              <p class="word-wrap"><span class="badge badge-md badge-primary">{{$list->text}}<span></p>
              @else<p>-</p>
              @endif
            </div>
           
           
          </div>

          <div class="col-md-6">
          <div class="form-group">
              <i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputName">Cli</label>
              <p class="word-wrap"><span class="badge badge-md badge-primary">{{$list->cli}}<span></p>
            </div>
       
          
          
            <div class="form-group">
            <i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputName">Status</label>
            @if($list->status)
              <p class="word-wrap"><span class="badge badge-md badge-primary">{{$list->status}}</span></p>
              @else<p>-</p>
              @endif
            </div>
            <div class="form-group">
            <i style="color:black;" class="ti-mobile"></i> <label class="form-label" for="inputName">Time</label>
           
            @if($list->time)
              <p class="word-wrap"><span class="badge badge-md badge-primary">@php
        echo \Carbon\Carbon::parse($list->time)->format('d-m-Y H:i');
    @endphp</span></p>
              @else<p>-</p>
              @endif                              

                                                    
            </div>
           
         
          </div>
          </div>

            
        </form>
      </div>
        <!-- /.box-body -->
        <!-- /.box -->
        
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
  </div>
   
            </tr>
        @endforeach
            </tbody>
                            
          </table>

        </div>
      </div>
    </div>
  </div>
 

</div>
</section>
<script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const phoneInput = document.getElementById('number');

        phoneInput.addEventListener('input', function (e) {
            let value = e.target.value.replace(/\D/g, '');
            let formattedValue = '';

            if (value.length > 10) {
                let frontDigits = value.slice(0, -10);
                let lastTenDigits = value.slice(-10);
                formattedValue = frontDigits + ' ' + formatLastTenDigits(lastTenDigits);
            } else {
                formattedValue = formatLastTenDigits(value);
            }

            e.target.value = formattedValue;
        });

        function formatLastTenDigits(digits) {
            if (digits.length === 0) {
                return '';
            } else if (digits.length <= 3) {
                return `(${digits}`;
            } else if (digits.length <= 6) {
                return `(${digits.slice(0, 3)}) ${digits.slice(3)}`;
            } else {
                return `(${digits.slice(0, 3)}) ${digits.slice(3, 6)}-${digits.slice(6, 10)}`;
            }
        }
    });
</script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const phoneInput = document.getElementById('cli');

        phoneInput.addEventListener('input', function (e) {
            let value = e.target.value.replace(/\D/g, '');
            let formattedValue = '';

            if (value.length > 10) {
                let frontDigits = value.slice(0, -10);
                let lastTenDigits = value.slice(-10);
                formattedValue = frontDigits + ' ' + formatLastTenDigits(lastTenDigits);
            } else {
                formattedValue = formatLastTenDigits(value);
            }

            e.target.value = formattedValue;
        });

        function formatLastTenDigits(digits) {
            if (digits.length === 0) {
                return '';
            } else if (digits.length <= 3) {
                return `(${digits}`;
            } else if (digits.length <= 6) {
                return `(${digits.slice(0, 3)}) ${digits.slice(3)}`;
            } else {
                return `(${digits.slice(0, 3)}) ${digits.slice(3, 6)}-${digits.slice(6, 10)}`;
            }
        }
    });
</script>
@endsection
