@extends('layouts.app')
@section('title', 'Allowed IP')
@section('content')
<style>
        .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;
    margin-top:5px;}
    .table > tbody > tr > td, .table > tbody > tr > th {
     padding: 0.5rem; 
    vertical-align: middle;
}
.btn-toggle.active {
    background-color: #2196f3; /* Set to the desired green color */
    color: white; /* Set to the desired text color */
    border-color: green; /* Set to the desired border color */
}

/* Style for the inactive state */
.btn-toggle:not(.active) {
    background-color: red; /* Set to the desired red color */
    color: white; /* Set to the desired text color */
    border-color: red; /* Set to the desired border color */
}

    </style>
        <link href="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/css/bootstrap4-toggle.min.css" rel="stylesheet">

<!-- Main content -->
        <section class="content">

      <div class="row">

       
        
        <div class="col-12">
          <div class="box">
                     
             <div class="box-body">           
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Allowed IPs</h4>             
               <a id="openLabelForm" type="submit"  class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"style="float:right;"><i class="fa fa-plus"></i>Add IP</a>         
         <hr class="my-15">
              <div class="table-responsive">
                <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
                  <thead>
                    <tr>
                                    <th>#</th>
                                    <th>IP</th>
                                    <th>Label</th>
                                    <th>Is Primary</th>
                                    <th>Status</th>
                                    <th>Action</th>

                            </tr>
                  </thead>
                  <tbody>
                  @if(!empty($allowed_ips))
                                @foreach($allowed_ips as $key => $label_data)

                                <tr>
                                  <th scope="row">{{$key+1}}</th>
                                  <td>{{$label_data->ip_address}}</td>
                                    <td>{{$label_data->label}}</td>

                                    <td>
                                        @if($label_data->is_primary == '0')
                                        <span class="badge badge-sm badge-warning">No</span> 
                                        @else ($label_data->is_primary == '1')
                                        <span class="badge badge-sm badge-success">Yes</span> @endif
                                    
                                    </td>

                                    <td>
                                        <!-- @if($label_data->status == '0')
                                        <span class="badge badge-sm badge-warning">Inactive</span> 
                                        @else ($label_data->status == '1')
                                        <span class="badge badge-sm badge-success">Active</span> @endif -->
                                        <button type="button"data-listid="{{$label_data->id}}" class="btn btn-sm btn-toggle  @if($label_data->status == '1') active @endif" data-bs-toggle="button" aria-pressed="true" autocomplete="off">
                                        <div class="handle"></div>
                                    </td>

                                    <td><a style="cursor:pointer;margin-right:5px;"title="Edit" class='editLabel' data-id="{{$label_data->id}}" ><i class="fa fa-edit fa-lg"></i></a> 
                                    <a style="cursor:pointer;"title="Delete" class='openLabelDelete' data-id="{{$label_data->id}}"><i class="fa fa-trash-o fa-lg"></i></a></td>

                                </tr>
                                @endforeach
                                @endif
                         
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
        <div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                <h5 class="modal-title" id="add-edit"></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                    <form method="post" action="" >
                    @csrf
                    <input type="hidden" class="form-control" name="ip_id" value="" id="id">

                                        <div class="modal-body">
                                            <div class="form-group">									
                                            <label for="inputEmail3" class="form-label closed number">IP Address  </label>
                                                <div class="input-group mb-3">
                                                <span class="input-group-text"><i class="ti-user"></i></span>
                                                <!-- <input type="text" class="form-control" required name="ip_address" id="ip_address"  pattern="[0-9\.]*" title="Please enter numbers and dots only"> -->
                                                <input type="text" class="form-control" required name="ip_address" id="ip_address" pattern="[0-9]+(\.[0-9]+){3}" title="Please enter a valid IP address">

                                                </div>
                                            </div>
                                                <div class="form-group">	
                                                    <label for="inputEmail3" class="form-label ">Label </label>
                                                    <div class="input-group mb-3">
                                                    <span class="input-group-text"><i class="ti-user"></i></span>
                                                    <input type="text" class="form-control" required name="label" id="label" placeholder="Label">
                                                    </div>
                                                </div>
                                                <div class="form-group">	
                                                    <label for="inputEmail3" class="form-label ">Status</label>
                                                    <div class="input-group mb-3">
                                                    <span class="input-group-text"><i class="ti-user"></i></span>                                          
                                                    <select class="form-select" name="status" id="status">
                                                        <option value="1">Active</option>
                                                        <option value="0">Inactive</option>
                                                    </select>
                                                    </div>
                                                    </div>
                                                    <div class="form-group">	
                                                    <label for="inputEmail3" class="form-label ">Is Primary </label>
                                                    <div class="input-group mb-3">
                                                    <span class="input-group-text"><i class="ti-user"></i></span>
                                                    <select class="form-select" name="is_primary" id="is_primary">
                                                        <option value="0">No</option>
                                                        <option value="1">Yes</option>

                                                    </select>
                                                    </div>
                                                </div>

                                        </div>           
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                                        <button type="submit"name="submit" class="btn btn-primary btn-sm">Save</button>
                                    </div>
                            </div>
                    </form>
            </div>
            </div>
        </div>
        <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
            
                    <div class="modal-body">
                    <p>You are about to delete <b><i class="title"></i></b>Record.</p>
                    <p>Do you want to proceed?</p>
                    <input type="hidden" class="form-control" name="ip_id" value="" id="ip_id">
                
                    </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                    <button type="submit"name="submit" class="btn btn-danger btn-sm deleteLabel">Delete</button>
                </div>
            </div>
        </div>
    </div>
      <!-- /.row -->

    </section>
        <!-- /.content -->

        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
        <script>

    $(".openLabelDelete").click(function() {
        var delete_id = $(this).data('id');
        $("#delete").modal('show');
        $("#ip_id").val(delete_id);

    });

    $("#openLabelForm").click(function() {
        $("#myModal").modal('show');
        $("#ip_address").val('');
        $("#label").val();
        $("#status").val('1');
        $("#is_primary").val('0');


        $("#id").val('');
        $("#add-edit").html('Add IP Address');


    });

    $(document).on("click", ".editLabel", function() {
        $("#myModal").modal('show');
        $("#add-edit").html('Edit IP Address');
        var edit_id = $(this).data('id');
        $.ajax({
            url: 'allowed-ip/' + edit_id,
            type: 'get',
            success: function(response) {
                $("#ip_address").val(response.ip_address);
                $("#label").val(response.label);
                $("#id").val(response.id);
                $("#status").val(response.status);
                $("#is_primary").val(response.is_primary);


            }
        });
    });

    $(document).on("click", ".deleteLabel", function()
    {
        var delete_id = $("#ip_id").val();
        var el = this;
        $.ajax({
            url: 'delete-allowed-ip/' + delete_id,
            type: 'get',
            success: function(response) {
                window.location.reload(1);
            }
        });
    });
</script>
<script>
$(function()
{
    $("#tickets").on("click", ".btn-toggle", function ()
    {
       console.log('hi');
      var status = $(this).hasClass('active') ? 1 : 0;
        var listid = $(this).data('listid');    


        $.ajax({
            type: "GET",
            dataType: "json",
            url: '/updateAllowedIpStatus/'+listid+ '/' +status,

            success: function(data)
            {
                if(data.status == 'true')
                {
                    toastr.success(data.message);
                }
                else
                {
                    toastr.error(data.message);

                }

                console.log(data.success);
                window.location.reload(1);
            }
        });
    })
})
</script>



@endsection
