@extends('layouts.app')
@section('title', 'Recharge')

@section('content')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.20/dist/sweetalert2.min.css">

    <style>
        .nav-tabs-custom>.tab-content {
            background: #ffffff;
            padding: 1.25rem;
            border-radius: 0;
            min-height: 100px;
        }

        .content-wrapper {
            position: relative;
        }

        section.waiting-section {
            text-align: center;
            background-color: #ffffffbd;
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            z-index: 2;
        }

        section.waiting-section div.payment-processing {
            padding-top: 20%;
        }

        section.waiting-section p {
            font-size: 16px;
        }

        input::-webkit-outer-spin-button,
        input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        input[type=number] {
            -moz-appearance: textfield;
        }
    </style>

    <section class="content">
        <form id="stripeForm" class="form-horizontal" method="post">
            @csrf
            <div class="row">
                <div class="col-md-12" style="margin-top:20px;">
                    <div class="box">
                        <div class="box-header with-border" style="padding:10px 10px;">
                            <h4 class="box-title">Add New Card</h4>
                        </div>
                        <div class="box-body">
                            <div class="nav-tabs-custom">
                                <div class="p-30">
                                    <div class="row">
                                        <div class="col-lg-12 col-md-6 col-12">
                                            <div class="form-group row">
                                                <div class="col-md-3">
                                                    <label class="form-label">Card Holder Name <span
                                                            style="color:red;">*</span></label>
                                                    <input type="text" class="form-control" placeholder="John Doe"
                                                        id="cardholder-name" required>
                                                </div>
                                                <div class="col-sm-6">
                                                    <label class="form-label">Card Details <span
                                                            style="color:red;">*</span></label>
                                                    <div id="card-element" class="form-control p-2"></div>
                                                    <div id="card-errors" class="text-danger mt-1"></div>
                                                </div>
                                                <div class="col-md-3">
                                                    <label class="form-label">Billing Address</label>
                                                    <input type="text" class="form-control"
                                                        placeholder="Enter Billing Address" id="line1" required>
                                                </div>
                                            </div>

                                            <div class="form-group row showOnlyOnNewCard">
                                                <div class="col-md-3">
                                                    <label class="form-label">City</label>
                                                    <input type="text" class="form-control" placeholder="City" id="city"
                                                        required>
                                                </div>
                                                <div class="col-md-3">
                                                    <label class="form-label">State</label>
                                                    <input type="text" class="form-control" placeholder="State" id="state"
                                                        required>
                                                </div>
                                                <div class="col-md-3">
                                                    <label class="form-label">Zip</label>
                                                    <input type="text" class="form-control" placeholder="Zip"
                                                        id="postal_code" maxlength="6" required>
                                                </div>
                                                <div class="col-md-3">
                                                    <label class="form-label">Country</label>
                                                    <select class="form-select" id="country" required>
                                                        <option value="CA">🇨🇦 Canada</option>
                                                        <option value="US">🇺🇸 United States</option>
                                                        <option value="GB">🇬🇧 United Kingdom</option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <div class="col-sm-12">
                                                    <div class="col-md-12 text-end">
                                                        <button type="submit" class="btn btn-success" id="submitBtn"
                                                            data-request="recharge">Add New Card</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </section>

    <section class="waiting-section" style="display: none">
        <div class="payment-processing">
            <img src="{{asset('assets/images/loader-30px.gif')}}" alt="Loading">
            <p>Your Card is being Saved!</p>
        </div>
    </section>

    <script src="https://js.stripe.com/v3/"></script>
    <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM="
        crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.20/dist/sweetalert2.all.min.js"></script>
    <script src="https://unpkg.com/imask"></script>
    <script src="{{ asset('assets/js/country-states.js') }}"></script>

    <script>
        const stripe = Stripe("{{ env('STRIPE_KEY') }}");
        const elements = stripe.elements();

        const cardElement = elements.create('card', {
            style: {
                base: {
                    fontSize: '16px',
                    color: '#32325d',
                }
            }
        });
        cardElement.mount('#card-element');

        const waitingSection = document.querySelector('.waiting-section');
        const submitBtn = document.getElementById('submitBtn');
        const form = document.getElementById('stripeForm');

        form.addEventListener('submit', async (event) => {
            event.preventDefault();
            waitingSection.style.display = 'block';
            submitBtn.disabled = true;
            document.getElementById('card-errors').textContent = '';

            const cardholderName = document.getElementById('cardholder-name').value;
            const billingDetails = {
                name: cardholderName,
                address: {
                    line1: document.getElementById('line1').value,
                    city: document.getElementById('city').value,
                    state: document.getElementById('state').value,
                    postal_code: document.getElementById('postal_code').value,
                    country: document.getElementById('country').value,
                }
            };

            const { paymentMethod, error } = await stripe.createPaymentMethod({
                type: 'card',
                card: cardElement,
                billing_details: billingDetails
            });

            if (error) {
                waitingSection.style.display = 'none';
                document.getElementById('card-errors').textContent = error.message;
                submitBtn.disabled = false;
                return;
            }

            fetch("{{ url('stripe/save-card') }}", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    "X-CSRF-TOKEN": "{{ csrf_token() }}"
                },
                body: JSON.stringify({
                    payment_method: paymentMethod.id
                })
            })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        Swal.fire({
                            title: 'Success!',
                            text: 'Card added successfully!',
                            icon: 'success',
                            confirmButtonText: 'OK'
                        }).then(() => {
                            window.location.reload();
                        });
                    } else {
                        Swal.fire({
                            title: 'Error!',
                            text: data.message,
                            icon: 'error',
                            confirmButtonText: 'OK'
                        });
                    }
                })
                .catch(error => {
                    Swal.fire({
                        title: 'Error!',
                        text: 'An unexpected error occurred.',
                        icon: 'error',
                        confirmButtonText: 'OK'
                    });
                })
                .finally(() => {
                    waitingSection.style.display = 'none';
                    submitBtn.disabled = false;
                });
        });

        (function () {
            let country_list = country_and_states['country'];
            let states_list = country_and_states['states'];

            let option = '<option value="">Select country</option>';
            for (let country_code in country_list) {
                option += '<option value="' + country_code + '">' + country_list[country_code] + '</option>';
            }
            document.getElementById('country').innerHTML = option;

            let state_code_append_id = document.getElementById("state");

            function create_states_dropdown() {
                let country_code = document.getElementById("country").value;
                let states = states_list[country_code];

                let option = '';
                if (!states || states.length === 0) {
                    option = '<input type="text" class="form-control" id="state" name="state" placeholder="State" required>';
                } else {
                    option = '<select class="form-control" name="state" id="state" required>';
                    for (let i = 0; i < states.length; i++) {
                        option += '<option value="' + states[i].name + '">' + states[i].name + '</option>';
                    }
                    option += '</select>';
                }
                state_code_append_id.outerHTML = option;
            }

            document.getElementById("country").addEventListener('change', create_states_dropdown);
        })();
    </script>
@endsection
