@extends('layouts.app')
@section('title', 'Buy Subscription')

@section('content')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.20/dist/sweetalert2.min.css">
    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>

    <style>
        .page-wrapper {
            padding: 20px;
        }

        .card-box {
            background: #fff;
            border-radius: 14px;
            padding: 22px;
            border: 1px solid #e5e7eb;
            margin-bottom: 24px;
            box-shadow: 0 3px 16px rgba(0, 0, 0, 0.06);
        }

        .plan-title {
            font-size: 26px;
            font-weight: 700;
            margin-bottom: 8px;
        }

        .price-tag {
            font-size: 36px;
            font-weight: 700;
            color: #089447;
        }

        .price-description {
            font-size: 14px;
            color: #6b7280;
        }

        .feature-item {
            font-size: 15px;
            margin-bottom: 6px;
        }

        .btn-primary {
            padding: 12px 20px;
            font-size: 16px;
            font-weight: 600;
            transition: .2s;
        }

        .btn-primary:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.16);
        }
    </style>

    <div class="page-wrapper">
        <div class="page-header d-flex justify-content-between align-items-center mb-3">
            <div class="d-flex align-items-center gap-2">
                <a href="{{ url()->previous() }}" class="btn btn-light px-2 py-1">
                    <i class="ti ti-arrow-narrow-left me-1"></i>
                </a>
                <h4 class="mb-0">AI Calling Subscription</h4>
            </div>
        </div>

        <div class="card-box">

            <div class="plan-title">{{ $plans->name }}</div>

            <div class="price-tag">₹{{ number_format($plans->amount, 2) }}</div>
            <div class="price-description"> per {{ $plans->billing_cycle }}, auto-renews </div>

            <hr class="my-3">

            <div class="feature-item"><i class="fa fa-check text-success"></i> 24/7 AI-voice answering converts incoming
                calls into qualified leads or bookings.</div>
            <div class="feature-item"><i class="fa fa-check text-success"></i> Real-time call routing and analytics for
                faster deal conversions and team insights. </div>
            <div class="feature-item"><i class="fa fa-check text-success"></i> Automated outreach (SMS/voice) to fill
                last-minute cancellations and boost capacity. </div>
            <div class="feature-item"><i class="fa fa-check text-success"></i> Seamless integration with CRM and 100+
                business tools via API/webhooks. </div>
            <div class="feature-item"><i class="fa fa-check text-success"></i> Flexible subscription options including
                pay-as-you-go and team plans for scaling. </div>

            <hr class="my-3">

            @php
                $activeSubscription = false;
                $remainingDays = 0;

                if (!empty($clientPackage) && $clientPackage->success && !empty($clientPackage->data)) {
                    if ($clientPackage->data->is_expired == 0) {
                        $activeSubscription = true;
                        $remainingDays = $clientPackage->data->remaining_days;
                    }
                }
            @endphp
            @if ($activeSubscription)
                <div class="alert alert-success mt-2">
                    Your subscription is active. Auto-renew will happen in {{ $remainingDays }} days.
                </div>
            @endif

            <div class="text-end">

                @if ($activeSubscription)
                    <button class="btn btn-secondary" disabled>
                        Subscribed ({{ $remainingDays }} days left)
                    </button>
                @else
                    <button id="subscribeBtn" class="btn btn-primary">
                        Subscribe Now
                    </button>
                @endif

            </div>


        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.7.0.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.20/dist/sweetalert2.all.min.js"></script>

    <script>
        $(function() {

            console.log("SUBS_PAGE: Loaded Buy Subscription Page");

            $("#subscribeBtn").click(async function() {

                console.log("SUBS_STEP_1: Subscribe button clicked");

                Swal.fire({
                    title: "Initializing...",
                    text: "Creating subscription...",
                    allowOutsideClick: false,
                    didOpen: () => Swal.showLoading()
                });

                try {
                    console.log("SUBS_STEP_2: Sending subscription create request");

                    const subRes = await fetch("{{ url('/razorpay-create-subscription') }}", {
                        method: "POST",
                        headers: {
                            "Content-Type": "application/json",
                            "X-CSRF-TOKEN": '{{ csrf_token() }}'
                        },
                        body: JSON.stringify({
                            plan_id: "{{ $plans->plan_id }}" // Your predefined Razorpay plan ID
                        })
                    });

                    const subData = await subRes.json();
                    console.log("SUBS_STEP_2_RES:", subData);

                    if (!subData.success) {
                        Swal.close();
                        Swal.fire({
                            icon: "error",
                            title: "Error",
                            text: subData.message || "Failed to initiate subscription."
                        });
                        return;
                    }

                    Swal.close();

                    console.log("SUBS_STEP_3: Opening Razorpay subscription popup");

                    let rzp = new Razorpay({
                        key: subData.key,
                        subscription_id: subData.subscription_id,
                        name: "{{ $plans->name }} Subscription",
                        description: "Monthly Subscription – Professional Plan",
                        notes: {
                            plan: "{{ $plans->plan_id }}"
                        },

                        handler: async function(resp) {
                            console.log("SUBS_STEP_4: Razorpay success response", resp);

                            Swal.fire({
                                title: "Verifying Subscription...",
                                allowOutsideClick: false,
                                didOpen: () => Swal.showLoading()
                            });

                            console.log(
                                "SUBS_STEP_5: Sending subscription verification request"
                            );

                            const verifyRes = await fetch(
                                "{{ url('/razorpay-verify-subscription') }}", {
                                    method: "POST",
                                    headers: {
                                        "Content-Type": "application/json",
                                        "X-CSRF-TOKEN": '{{ csrf_token() }}'
                                    },
                                    body: JSON.stringify({
                                        razorpay_subscription_id: resp
                                            .razorpay_subscription_id,
                                        razorpay_payment_id: resp
                                            .razorpay_payment_id,
                                        razorpay_signature: resp
                                            .razorpay_signature
                                    })
                                });

                            const verifyData = await verifyRes.json();
                            console.log("SUBS_STEP_5_RES:", verifyData);

                            if (verifyData.success) {
                                Swal.fire({
                                    icon: "success",
                                    title: "Subscription Activated!",
                                    text: "Your subscription is now active."
                                });

                                setTimeout(() => {
                                    window.location.reload();
                                }, 2000);

                            } else {
                                Swal.fire({
                                    icon: "error",
                                    title: "Verification Failed",
                                    text: verifyData.message ||
                                        "Could not verify subscription."
                                });
                            }
                        }
                    });

                    rzp.on("payment.failed", function(err) {
                        console.log("SUBS_ERR: Payment failed", err.error);
                        Swal.fire({
                            icon: "error",
                            title: "Payment Failed",
                            text: err.error.description ||
                                "Subscription payment failed."
                        });
                    });

                    rzp.open();

                } catch (err) {
                    console.log("SUBS_FATAL:", err);

                    Swal.close();
                    Swal.fire({
                        icon: "error",
                        title: "Error",
                        text: "Something went wrong."
                    });
                }
            });

        });
    </script>

@endsection
