@extends('layouts.app')
@section('title', 'Recharge')

@section('content')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.20/dist/sweetalert2.min.css">
    <style>
        .card-container {
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            padding: 20px;
            margin-bottom: 20px;
        }
        .btn-primary {
            transition: all 0.3s ease;
            padding: 8px 16px;
            font-size: 14px;
        }
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        }
        .form-label {
            font-weight: 500;
        }
        .section-header {
            border-bottom: 1px solid #e9ecef;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        .accepted-cards {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        @media (max-width: 768px) {
            .page-header .row {
                flex-direction: column;
                align-items: flex-start;
            }
            .page-header .col-4 {
                text-align: left !important;
                margin-top: 10px;
            }
            .accepted-cards {
                flex-direction: column;
                align-items: flex-start;
            }
            .pay-button {
                margin-top: 10px;
            }
        }
    </style>
    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-md-12">
                <!-- Page Header -->
                <div class="page-header">
                    <div class="row align-items-center">
                        <div class="col-8 mb-0">
                            <div class="d-flex align-items-center gap-2">
                                <a href="{{ url()->previous() }}" class="btn btn-light d-flex align-items-center px-2 py-1">
                                    <i class="ti ti-arrow-narrow-left me-1"></i>
                                </a>
                                <h4 class="page-title mb-0">Recharge Account</h4>
                            </div>
                        </div>
                        <div class="col-4 mb-0 text-end">
                            <div class="head-icons">
                                <a href="" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="Refresh">
                                    <i class="ti ti-refresh-dot"></i>
                                </a>
                                <a href="javascript:void(0);" data-bs-toggle="tooltip" data-bs-placement="top"
                                    data-bs-original-title="Collapse" id="collapse-header">
                                    <i class="ti ti-chevrons-up"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /Page Header -->

                <!-- Payment Details Section -->
                <div class="section-card card-container">
                    <div class="section-header d-flex justify-content-between align-items-center">
                        <h5 class="section-title mb-0">Payment Details</h5>
                        <a role="button" target="_blank" href="{{ url('payment-method-list') }}" class="btn btn-primary">Manage Cards</a>
                    </div>
                    <form id="stripeForm" class="form-horizontal" method="post">
                        @csrf
                        @php
                            $queryPlanId = request('plan_id');
                            if ($queryPlanId) {
                                $selectedPlanId = $queryPlanId;
                            }
                        @endphp
                        <input type="hidden" name="request_type" value="" id="request_type">
                        <div class="nav-tabs-custom">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" data-bs-toggle="tab" href="#debit-card" role="tab">
                                        <span class="hidden-sm-up"><i class="fa fa-cc"></i></span>
                                        <span class="hidden-xs-down">Credit Card</span>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-bs-toggle="tab" href="#paypal" role="tab">
                                        <span class="hidden-sm-up"><i class="fa fa-paypal"></i></span>
                                        <span class="hidden-xs-down">Paypal</span>
                                    </a>
                                </li>
                            </ul>
                            <div class="tab-content tabcontent-border">
                                <div class="tab-pane active" id="debit-card" role="tabpanel">
                                    <div class="p-3">
                                        <div class="row g-3">
                                            <div class="col-md-3">
                                                <label for="payment_method" class="form-label">Select Card</label>
                                                <div class="input-group">
                                                    <span class="input-group-text"><i class="fa fa-credit-card"></i></span>
                                                    <select id="payment_method" name="payment_method" class="form-select" required>
                                                        @foreach ($paymentMethods as $pm)
                                                            <option value="{{ $pm->id }}">XXXX XXXX XXXX {{ $pm->card->last4 }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <label for="full_name" class="form-label">Full Name <span style="color:red;">*</span></label>
                                                <input type="text" maxlength="30" class="form-control address_info" name="full_name" id="full_name" placeholder="Full Name" required>
                                            </div>
                                            <div class="col-md-3">
                                                <label for="line1" class="form-label">Address <span style="color:red;">*</span></label>
                                                <input type="text" maxlength="100" class="form-control address_info" name="line1" id="line1" placeholder="Address" required>
                                            </div>
                                            <div class="col-md-3">
                                                <label for="city" class="form-label">City <span style="color:red;">*</span></label>
                                                <input type="text" maxlength="50" class="form-control address_info" name="city" id="city" placeholder="City" required>
                                            </div>
                                            <div class="col-md-3">
                                                <label for="state" class="form-label">State <span style="color:red;">*</span></label>
                                                <span id="state-code"><input type="text" class="form-control address_info" id="state" name="state" placeholder="State" required></span>
                                            </div>
                                            <div class="col-md-3">
                                                <label for="postal_code" class="form-label">Zip Code <span style="color:red;">*</span></label>
                                                <input type="text" maxlength="20" class="form-control address_info" name="postal_code" id="postal_code" placeholder="Zip Code" required>
                                            </div>
                                            <div class="col-md-3">
                                                <label for="country" class="form-label">Country <span style="color:red;">*</span></label>
                                                <select class="form-select address_info" name="country" id="country" required>
                                                    <option value="">Select Country</option>
                                                </select>
                                            </div>
                                            <div class="col-md-3">
                                                <label for="amount" class="form-label">Amount <span style="color:red;">*</span></label>
                                              <input 
                                                type="text" 
                                                class="form-control" 
                                                name="amount" 
                                                id="amount" 
                                                placeholder="100" 
                                                value="{{ $intCartTotal }}" 
                                                autofocus
                                                onfocus="this.value = this.value.replace(/,/g, '');"
                                                oninput="
                                                    this.value = this.value.replace(/[^0-9.]/g, '');
                                                    let parts = this.value.split('.');
                                                    if (parts.length > 2) {
                                                    this.value = parts[0] + '.' + parts[1];
                                                    }
                                                    if (parts.length === 2) {
                                                    parts[1] = parts[1].substring(0,2);
                                                    this.value = parts[0] + '.' + parts[1];
                                                    }
                                                "
                                                onblur="
                                                    let val = this.value.replace(/,/g, '');
                                                    if(val !== '' && !isNaN(val)) {
                                                    this.value = parseFloat(val).toFixed(2);
                                                    }
                                                "
                                                readonly
                                                >
                                                <small class="text-muted">Payment Gateway fee of 3% will be charged.</small>
                                            </div>
                                            <div class="col-lg-12 col-md-12 col-12 d-flex align-items-center justify-content-between mt-3 accepted-cards">
                                                <div>
                                                    <h3 class="box-title mb-2">Accepted Cards</h3>
                                                    <div>
                                                        <i class="fa fa-cc-visa text-info me-2"></i>
                                                        <i class="fa fa-cc-mastercard text-danger me-2"></i>
                                                        <i class="fa fa-cc-discover text-success me-2"></i>
                                                        <i class="fa fa-cc-amex text-warning"></i>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn-primary pay-button">Pay Now</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="paypal" role="tabpanel">
                                    <div class="p-3">
                                        Paypal service is Coming soon..
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.20/dist/sweetalert2.all.min.js"></script>
    <script src="{{ asset('assets/js/pages/validation.js') }}"></script>
    <script src="{{ asset('assets/js/pages/form-validation.js') }}"></script>
    <script src="{{ asset('assets/js/country-states.js') }}"></script>

    <script>
        $(document).ready(function () {
            // Function to populate form fields based on selected card
            function populateCardDetails() {
                const selectedCardId = $("#payment_method").val();
                if (selectedCardId) {
                    const cardDetails = @json($paymentMethods);
                    const selectedCard = cardDetails.find(card => card.id == selectedCardId);
                    if (selectedCard) {
                        $('#full_name').val(selectedCard.billing_details.name || '');
                        $('#country').val(selectedCard.billing_details.address.country || '');
                        $('#state').val(selectedCard.billing_details.address.state || '');
                        $('#city').val(selectedCard.billing_details.address.city || '');
                        $('#postal_code').val(selectedCard.billing_details.address.postal_code || '');
                        $('#line1').val(selectedCard.billing_details.address.line1 || '');
                    }
                }
            }

            // Bind change event to payment_method dropdown
            $("#payment_method").on('change', populateCardDetails);

            // Trigger population of form fields on page load
            populateCardDetails();

            $("#stripeForm").submit(async function (e) {
                e.preventDefault();

                // Show SweetAlert2 loading popup
                Swal.fire({
                    title: 'Payment in Progress...',
                    text: 'Please wait while we process your payment.',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });

                try {
                    const response = await $.ajax({
                        type: 'POST',
                        url: '{{ url('checkout/subscription') }}',
                        data: $('#stripeForm').serialize(),
                        headers: {
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        }
                    });

                    // Close the loading popup
                    Swal.close();

                    if (response.success === true) {
                        // Show success popup with redirect timer
                        let timeleft = 5;
                        Swal.fire({
                            title: 'Success!',
                            html: `Thank you for your payment. We are updating your Wallet!<br><br>You will be redirected in <span id="redirect-timer">${timeleft}</span> seconds...`,
                            icon: 'success',
                            showConfirmButton: false,
                            allowOutsideClick: false,
                            didOpen: () => {
                                const downloadTimer = setInterval(function () {
                                    if (timeleft <= 0) {
                                        clearInterval(downloadTimer);
                                        window.location.href = "/wallet/transactions";
                                    } else {
                                        $("#redirect-timer").text(timeleft);
                                    }
                                    timeleft -= 1;
                                }, 1000);
                            }
                        });
                    } else {
                        Swal.fire({
                            title: 'Error!',
                            text: response.errors ? Object.values(response.errors).join('\n') : 'An error occurred.',
                            icon: 'error',
                            confirmButtonText: 'OK'
                        });
                    }
                } catch (error) {
                    // Close the loading popup
                    Swal.close();
                    Swal.fire({
                        title: 'Error!',
                        text: 'There is a problem with processing payment',
                        icon: 'error',
                        confirmButtonText: 'OK'
                    });
                    console.error('Error:', error);
                }
            });

            // Country and State dropdown
            (function () {
                const user_country_code = "IN";
                const country_list = country_and_states['country'];
                const states_list = country_and_states['states'];

                let option = '<option value="">Select country</option>';
                for (let country_code in country_list) {
                    const selected = country_code === user_country_code ? ' selected' : '';
                    option += `<option value="${country_code}"${selected}>${country_list[country_code]}</option>`;
                }
                document.getElementById('country').innerHTML = option;

                const state_code_append_id = document.getElementById("state-code");
                function create_states_dropdown() {
                    const country_code = document.getElementById("country").value;
                    const states = states_list[country_code];

                    let option = '';
                    if (!states || states.length === 0) {
                        option = '<input type="text" class="form-control address_info" id="state" name="state" placeholder="State" required>';
                    } else {
                        option = '<select class="form-control address_info" name="state" id="state" required>';
                        states.forEach(state => {
                            option += `<option value="${state.name}">${state.name}</option>`;
                        });
                        option += '</select>';
                    }
                    state_code_append_id.innerHTML = option;
                }

                document.getElementById("country").addEventListener('change', create_states_dropdown);
                create_states_dropdown();
            })();
        });
    </script>
@endsection