@extends('layouts.app')
@section('title', 'Invoice')

@section('content')
<section class="content">

      <div class="row">               
        <div class="col-12">
          <div class="box">
           <div class="box-body">           
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Invoices</h4>
              
          <hr class="my-15">
              <div class="table-responsive">
                <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
                  <thead>
                    <tr>   <th>#</th>
                                    <th>Subscriptions</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>Placed On</th>
                                    <th>Action</th>

                            </tr>
                  </thead>
                  <tbody>

                  @foreach($orders as $key => $order)
                                    <tr>
                                        <td>{{$key+1}}</td>
                                        <td>{{$order->subscriptions}}</td>
                                        <td>${{$order->gross_amount}}</td>
                                        <td>{{ucfirst($order->status)}}</td>
                                        <td>{{\Carbon\Carbon::parse($order->created_at)->format('dS M Y')}}</td>
                                        <td>
                                            <a style="cursor:pointer;color:blue;" href="{{url('/invoice')}}/{{$order->id}}" title="View Orders Details" class=''  ><i class="fa fa-eye fa-lg"></i></a>
                                        </td>
                                    </tr>
                                    </tr>
                                @endforeach
</tbody>      </table>
              </div>
            </div>
          </div>
        </div>
    
      </div>
      <!-- /.row -->



    </section>
        <!-- /.content -->

@endsection
