{{-- resources/views/recharge/_auto-section.blade.php --}}

<style>
    .auto-alert-box {
        background: #089447;
        color: #ffffff;
        padding: 14px 18px;
        border-radius: 10px;
        font-weight: 600;
        margin-bottom: 18px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .auto-disable-btn {
        background: #dc3545;
        border: none;
        color: white;
        padding: 8px 16px;
        border-radius: 6px;
        font-size: 13px;
        font-weight: 600;
        transition: 0.2s;
    }

    .auto-disable-btn:hover {
        opacity: .9;
    }

    .setup-btn {
        background: #089447;
        border: none;
        color: white;
        padding: 10px 22px;
        border-radius: 8px;
        font-weight: 600;
        font-size: 14px;
        transition: .2s;
    }

    .setup-btn:hover {
        opacity: .95;
        transform: translateY(-1px);
    }
</style>

<div class="card-box mb-4 border" style="border-radius:14px; padding:20px;">

    <div class="d-flex justify-content-between align-items-center mb-2">
        <span class="section-title fw-bold" style="font-size:18px;">Auto Recharge</span>

        <label class="switch-toggle m-0">
            <input type="checkbox" id="autoReload" name="auto_reload_enabled" @checked($autoReloadEnabled)>
            <span class="slider"></span>
        </label>
    </div>

    <p class="text-muted mb-3">
        Automatically recharge your wallet when the balance drops below your threshold.
    </p>

    @if ($razorpayCustomerTokenExists)
        <div class="auto-alert-box">
            <span>Auto-Recharge is Active</span>
            <small>Your UPI mandate is active.</small>
        </div>
    @endif

    <div id="auto-recharge-fields" style="display: {{ $autoReloadEnabled ? 'block' : 'none' }};">
        <div class="row g-3 mb-3">
            <div class="col-md-6">
                <label class="form-label fw-semibold">Balance Threshold</label>
                <div class="input-group">
                    <span class="input-group-text">₹</span>
                    <input type="number" class="form-control" id="auto_reload_threshold"
                        value="{{ $autoReloadThreshold }}" min="1">
                </div>
            </div>

            <div class="col-md-6">
                <label class="form-label fw-semibold">Auto Recharge Amount</label>
                <div class="input-group">
                    <span class="input-group-text">₹</span>
                    <input type="number" class="form-control" id="auto_reload_amount" value="{{ $autoReloadAmount }}"
                        min="1">
                </div>
            </div>
        </div>

        <div class="d-flex justify-content-end mt-2">
            @if (!$razorpayCustomerTokenExists)
                {{-- User has NO mandate yet --}}
                <div class="text-end">
                    <button id="setup-mandate-btn" class="setup-btn">Setup Auto Pay</button>
                    <div class="text-muted small mt-1">
                        One-time secure UPI mandate authorization.
                    </div>
                </div>
            @else
                {{-- User HAS an active mandate --}}
                <button id="disable-auto" class="auto-disable-btn">Delete Auto Pay</button>
            @endif
        </div>
    </div>
</div>


<script>
    const hasMandate = {{ $razorpayCustomerTokenExists ? 'true' : 'false' }};

    // ============================
    // AUTO RELOAD TOGGLE SWITCH
    // ============================
    $('#autoReload').on('change', async function() {
        const enabled = $(this).is(':checked');

        // ------------------------------------------
        // USER TURNED ON TOGGLE (NEW FEATURE)
        // ------------------------------------------
        if (enabled) {
            console.log("User trying to ENABLE auto-recharge from toggle");

            const ask = await Swal.fire({
                title: 'Enable Auto Recharge?',
                text: 'This will automatically recharge your wallet based on your threshold.',
                icon: 'info',
                showCancelButton: true,
                confirmButtonText: 'Yes, Enable',
                confirmButtonColor: '#089447'
            });

            if (!ask.isConfirmed) {
                $('#autoReload').prop('checked', false);
                return;
            }

            // Call API to enable
            await enableAutoRecharge();

            return;
        }

        // ------------------------------------------
        // USER TURNED OFF TOGGLE (EXISTING FEATURE)
        // ------------------------------------------
        console.log("User trying to disable auto-recharge from toggle");

        const stop = await Swal.fire({
            title: 'Disable Auto Recharge?',
            text: 'This will stop automatic recharges and disable your mandate.',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, Disable',
            confirmButtonColor: '#d33'
        });

        // Cancel → revert toggle
        if (!stop.isConfirmed) {
            $('#autoReload').prop('checked', true);
            return;
        }

        // Confirm disable
        await disableAutoRecharge(false);
    });


    // ============================
    // ENABLE AUTO-RECHARGE FUNCTION (NEW)
    // ============================
    async function enableAutoRecharge() {

        Swal.fire({
            title: 'Enabling...',
            text: 'Please wait.',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
        });

        try {
            const autoData = {
                _token: '{{ csrf_token() }}',
                auto_reload_enabled: 1,
                auto_reload_threshold: $('#auto_reload_threshold').val(),
                auto_reload_amount: $('#auto_reload_amount').val()
            };

            console.log("Enabling Auto Recharge…", autoData);

            const autoSave = await $.post('{{ url('user/auto-recharge-update') }}', autoData);

            Swal.close();

            if (!autoSave.success) {
                $('#autoReload').prop('checked', false); // revert
                return Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: autoSave.message
                });
            }

            Swal.fire({
                icon: 'success',
                title: 'Auto-Recharge Enabled',
                text: 'Auto-recharge settings saved.'
            });

            $('#auto-recharge-fields').slideDown();

        } catch (err) {
            Swal.close();
            $('#autoReload').prop('checked', false); // revert
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Failed to enable auto-recharge.'
            });
        }
    }



    // ============================
    // DISABLE BUTTON CLICK
    // ============================
    $('#disable-auto').on('click', async function(e) {
        e.preventDefault();

        const ask = await Swal.fire({
            title: 'Delete Auto Pay?',
            text: 'This will permanently disable your auto-recharge mandate.',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Disable',
            confirmButtonColor: '#d33'
        });

        if (!ask.isConfirmed) return;

        await disableAutoRecharge(true);
    });



    // ============================
    // DISABLE AUTO-RECHARGE FUNCTION (already implemented)
    // ============================
    async function disableAutoRecharge(deleteMandate) {
        Swal.fire({
            title: 'Disabling...',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
        });

        try {
            const req = await $.post('{{ url('user/auto-recharge-update') }}', {
                _token: '{{ csrf_token() }}',
                auto_reload_enabled: 0,
                delete_mandate: deleteMandate ? 1 : 0
            });

            Swal.close();

            if (!req.success) {
                return Swal.fire('Error', req.message, 'error');
            }

            Swal.fire('Disabled', 'Auto-recharge is now off.', 'success')
                .then(() => location.reload());

        } catch {
            Swal.close();
            Swal.fire('Error', 'Failed to disable auto-recharge.', 'error');
        }
    }



    // ============================
    // SETUP AUTO PAY → OPEN RAZORPAY MANDATE
    // ============================
    $('#setup-mandate-btn').on('click', function() {
        const threshold = Number($('#auto_reload_threshold').val());
        const amount = Number($('#auto_reload_amount').val());

        Swal.fire({
            title: 'Setup Auto-Recharge',
            html: `
                <p>This authorizes automatic UPI debit of ₹${amount}
                when your wallet goes below ₹${threshold}.</p>
                <div style="background:#fff7d6;padding:12px;border-left:4px solid #f7c600;">
                    <b>No money will be deducted now.</b>
                </div>`,
            icon: 'info',
            showCancelButton: true,
            confirmButtonText: 'Proceed',
            confirmButtonColor: '#089447'
        }).then(res => {
            if (res.isConfirmed) {
                createMandate(amount, threshold);
            }
        });
    });



    // ============================
    // CREATE MANDATE → OPEN CHECKOUT
    // ============================
    async function createMandate(amount, threshold) {

        Swal.fire({
            title: 'Processing...',
            text: 'Creating UPI mandate...',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
        });

        try {
            const req = await fetch("{{ url('/razorpay-create-auto-recharge-mandate') }}", {
                method: "POST",
                headers: {
                    "X-CSRF-TOKEN": "{{ csrf_token() }}",
                    "Content-Type": "application/json"
                },
                body: JSON.stringify({
                    amount
                })
            });

            const data = await req.json();

            if (!data.success) throw new Error(data.message);

            Swal.close();

            const rzp = new Razorpay({
                key: data.key,
                order_id: data.order_id,
                customer_id: data.customer_id,
                recurring: true,
                method: ['upi'],
                name: "{{ config('app.name') }}",
                description: 'Auto-Recharge UPI Mandate',

                handler: async function(resp) {
                    Swal.fire({
                        title: 'Saving...',
                        didOpen: () => Swal.showLoading()
                    });

                    const verifyReq = await fetch(
                        "{{ url('/razorpay-verify-auto-recharge-mandate') }}", {
                            method: "POST",
                            headers: {
                                "Content-Type": "application/json",
                                "X-CSRF-TOKEN": "{{ csrf_token() }}"
                            },
                            body: JSON.stringify({
                                razorpay_payment_id: resp.razorpay_payment_id,
                                razorpay_order_id: resp.razorpay_order_id,
                                razorpay_signature: resp.razorpay_signature,
                                auto_reload_threshold: threshold,
                                auto_reload_amount: amount
                            })
                        });

                    const verifyData = await verifyReq.json();

                    Swal.close();

                    if (verifyData.success) {
                        Swal.fire('Success', 'Auto-recharge is now active.', 'success')
                            .then(() => location.reload());
                    } else {
                        Swal.fire('Error', verifyData.message, 'error');
                    }
                }
            });

            rzp.open();

        } catch (err) {
            Swal.close();
            Swal.fire('Error', err.message, 'error');
        }
    }
</script>
