@extends('layouts.app')
@section('title', 'Recharge')

@section('content')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.20/dist/sweetalert2.min.css">

    <style>
        .card-container {
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            padding: 20px;
            margin-bottom: 20px;
        }

        .btn-primary {
            transition: all 0.3s ease;
            padding: 8px 16px;
            font-size: 14px;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        }

        .form-label {
            font-weight: 500;
        }

        .section-header {
            border-bottom: 1px solid #e9ecef;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }

        .accepted-cards {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        @media (max-width: 768px) {
            .accepted-cards {
                flex-direction: column;
                align-items: flex-start;
            }

            .pay-button {
                margin-top: 10px;
            }
        }
    </style>

    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-md-12">

                <!-- Page Header -->
                <div class="page-header">
                    <div class="row align-items-center">
                        <div class="col-8 mb-0">
                            <div class="d-flex align-items-center gap-2">
                                <a href="{{ url()->previous() }}" class="btn btn-light px-2 py-1">
                                    <i class="ti ti-arrow-narrow-left me-1"></i>
                                </a>
                                <h4 class="page-title mb-0">Recharge Account</h4>
                            </div>
                        </div>
                        <div class="col-4 mb-0 text-end">
                            <div class="head-icons">
                                <a href="" data-bs-toggle="tooltip" title="Refresh"><i class="ti ti-refresh-dot"></i></a>
                                <a href="javascript:void(0);" data-bs-toggle="tooltip" title="Collapse"
                                    id="collapse-header">
                                    <i class="ti ti-chevrons-up"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /Header -->

                <!-- Payment Section -->
                <div class="section-card card-container">
                    <div class="section-header d-flex justify-content-between align-items-center">
                        <h5 class="section-title mb-0">Payment Details</h5>
                        <a role="button" target="_blank" href="{{ url('payment-method-list') }}"
                            class="btn btn-primary">Manage Cards</a>
                    </div>

                    <form id="stripeForm" method="post">
                        @csrf
                        <input type="hidden" name="request_type" value="recharge">

                        <div class="nav-tabs-custom">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" data-bs-toggle="tab" href="#debit-card"><i
                                            class="fa fa-cc"></i> Credit Card</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-bs-toggle="tab" href="#paypal"><i class="fa fa-paypal"></i>
                                        Paypal</a>
                                </li>
                            </ul>

                            <div class="tab-content tabcontent-border">
                                <div class="tab-pane active" id="debit-card">
                                    <div class="p-3">
                                        <div class="row g-3">

                                            <!-- Payment Inputs -->
                                            <div class="col-md-3">
                                                <label for="payment_method" class="form-label">Select Card</label>
                                                <div class="input-group">
                                                    <span class="input-group-text"><i class="fa fa-credit-card"></i></span>
                                                    <select id="payment_method" name="payment_method" class="form-select"
                                                        required>
                                                        @foreach ($paymentMethods as $pm)
                                                            <option value="{{ $pm->id }}"
                                                                @selected($pm->id == $defaultPaymentMethod)>
                                                                XXXX XXXX XXXX {{ $pm->card->last4 }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-md-3">
                                                <label for="full_name" class="form-label">Full Name *</label>
                                                <input type="text" class="form-control address_info" name="full_name"
                                                    id="full_name" required>
                                            </div>
                                            <div class="col-md-3">
                                                <label for="line1" class="form-label">Address *</label>
                                                <input type="text" class="form-control address_info" name="line1" id="line1"
                                                    required>
                                            </div>
                                            <div class="col-md-3">
                                                <label for="city" class="form-label">City *</label>
                                                <input type="text" class="form-control address_info" name="city" id="city"
                                                    required>
                                            </div>
                                            <div class="col-md-3">
                                                <label for="state" class="form-label">State *</label>
                                                <span id="state-code"><input type="text" class="form-control" id="state"
                                                        name="state" required></span>
                                            </div>
                                            <div class="col-md-3">
                                                <label for="postal_code" class="form-label">Zip Code *</label>
                                                <input type="text" class="form-control" name="postal_code" id="postal_code"
                                                    required>
                                            </div>
                                            <div class="col-md-3">
                                                <label for="country" class="form-label">Country *</label>
                                                <select class="form-select" name="country" id="country" required>
                                                    <option value="">Select Country</option>
                                                </select>
                                            </div>
                                            <div class="col-md-3">
                                                <label for="amount" class="form-label">Amount *</label>
                                                <input type="number" class="form-control" name="amount" id="amount"
                                                    placeholder="100">
                                                <small class="text-muted">3% gateway fee applies.</small>
                                            </div>

                                            <!-- AUTO RECHARGE SECTION -->
                                            <div class="col-12 section-card mt-4 p-3"
                                                style="background:#f9f9f9;border:1px solid #e0e0e0;">
                                                <input type="checkbox" id="autoReload" name="auto_reload_enabled" value="1"
                                                    style="accent-color:green;width:18px;height:18px;margin-right:6px;"
                                                    @checked($autoReloadEnabled)>
                                                <label for="autoReload"
                                                    style="font-weight:bold;font-size:15px;">AutoRecharge</label>

                                                <p class="text-muted mb-3">
                                                    Automatically recharge your account when balance falls below the
                                                    threshold.
                                                </p>

                                                <div id="auto-recharge-fields"
                                                    style="display: {{ $autoReloadEnabled ? 'block' : 'none' }};">
                                                    <div class="row g-3">
                                                        <div class="col-md-3">
                                                            <label class="form-label">Balance Threshold</label>
                                                            <div class="input-group">
                                                                <span class="input-group-text">$</span>
                                                                <input type="number" class="form-control"
                                                                    id="auto_reload_threshold" name="auto_reload_threshold"
                                                                    value="{{ $autoReloadThreshold }}">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <label class="form-label">Auto Recharge Amount</label>
                                                            <input type="number" class="form-control"
                                                                id="auto_reload_amount" name="auto_reload_amount"
                                                                value="{{ $autoReloadAmount }}">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Accepted Cards -->
                                            <div
                                                class="col-lg-12 d-flex align-items-center justify-content-between mt-3 accepted-cards">
                                                <div>
                                                    <h3 class="box-title mb-2">Accepted Cards</h3>
                                                    <i class="fa fa-cc-visa text-info me-2"></i>
                                                    <i class="fa fa-cc-mastercard text-danger me-2"></i>
                                                    <i class="fa fa-cc-discover text-success me-2"></i>
                                                    <i class="fa fa-cc-amex text-warning"></i>
                                                </div>
                                                <button type="submit" class="btn btn-primary pay-button">Pay Now</button>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <div class="tab-pane" id="paypal">
                                    <div class="p-3">Paypal integration coming soon.</div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.7.0.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.20/dist/sweetalert2.all.min.js"></script>
    <script src="{{ asset('assets/js/country-states.js') }}"></script>

    <script>
        $(function () {
            // Toggle AutoReload fields
            $('#autoReload').on('change', function () {
                $(this).is(':checked') ? $('#auto-recharge-fields').slideDown() : $('#auto-recharge-fields').slideUp();
            });

            // Combined Logic: Save AutoRecharge → Then Process Payment
            $("#stripeForm").submit(async function (e) {
                e.preventDefault();

                // Step 1: Save AutoRecharge Settings first
                const autoData = {
                    _token: '{{ csrf_token() }}',
                    auto_reload_enabled: $('#autoReload').is(':checked') ? 1 : 0,
                    auto_reload_threshold: $('#auto_reload_threshold').val(),
                    auto_reload_amount: $('#auto_reload_amount').val()
                };

                Swal.fire({
                    title: 'Processing...',
                    text: 'Saving settings & processing payment. Please wait.',
                    allowOutsideClick: false,
                    didOpen: () => Swal.showLoading()
                });

                try {
                    const autoSave = await $.post('{{ url('user/auto-recharge-update') }}', autoData);

                    if (!autoSave.success) {
                        Swal.close();
                        Swal.fire({ icon: 'error', title: 'Error', text: autoSave.message || 'Failed to save auto-recharge settings.' });
                        return; // stop payment if saving fails
                    }

                    // Step 2: Proceed with Payment
                    const paymentResponse = await $.ajax({
                        type: 'POST',
                        url: '{{ url('checkout') }}',
                        data: $(this).serialize(),
                        headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' }
                    });

                    Swal.close();

                    if (paymentResponse.success) {
                        let timer = 5;
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            html: `Payment successful. Redirecting in <b id="timer">${timer}</b> seconds...`,
                            showConfirmButton: false,
                            didOpen: () => {
                                const interval = setInterval(() => {
                                    timer--;
                                    if (timer <= 0) {
                                        clearInterval(interval);
                                        window.location.href = "/wallet/transactions";
                                    }
                                    $('#timer').text(timer);
                                }, 1000);
                            }
                        });
                    } else {
                        Swal.fire({ icon: 'error', title: 'Payment Failed', text: paymentResponse.message || 'An error occurred.' });
                    }

                } catch (err) {
                    Swal.close();
                    Swal.fire({ icon: 'error', title: 'Error', text: 'Failed to process payment or save settings.' });
                }
            });

            // Country/State Dropdown
            (function () {
                const user_country_code = "IN";
                const country_list = country_and_states['country'];
                const states_list = country_and_states['states'];

                let options = '<option value="">Select country</option>';
                for (let code in country_list) {
                    const selected = code === user_country_code ? ' selected' : '';
                    options += `<option value="${code}"${selected}>${country_list[code]}</option>`;
                }
                $('#country').html(options);

                function createStateDropdown() {
                    const country = $('#country').val();
                    const states = states_list[country];
                    let html = '';
                    if (!states || states.length === 0) {
                        html = '<input type="text" class="form-control" id="state" name="state" required>';
                    } else {
                        html = '<select class="form-control" name="state" id="state" required>';
                        states.forEach(s => html += `<option value="${s.name}">${s.name}</option>`);
                        html += '</select>';
                    }
                    $("#state-code").html(html);
                }

                $('#country').on('change', createStateDropdown);
                createStateDropdown();
            })();
        });
    </script>
@endsection
