@extends('layouts.app')
@section('title', 'Edit Blog')
@section('content')
<!-- Content Wrapper. Contains page content -->


    <!-- Main content -->
    <section class="content">
        <div class="row">
        <div class="col-lg-12 col-12">
                <div class="box">

                         
                             <div class="box-body"><!--bg-lightest-->
                             <h4 class="box-title text-info mb-0"><i class="fa fa-plus"></i> Edit Blog</h4>
            <a href="{{url('/admin/blogs')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i> Blogs</a>
            <hr class="my-15">

                   <form action="{{ route('blogs.update', $blog->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="col-form-label">Title <span class="text-danger">*</span></label>
                                <input type="text" name="title" id="title" class="form-control"
                                    value="{{ old('title', $blog->title) }}" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="col-form-label">Slug <span class="text-danger">*</span></label>
                                <input type="text" name="slug" id="slug" class="form-control"
                                    value="{{ old('slug', $blog->slug) }}" required>
                                <small class="text-muted">Auto-generated from title, but editable.</small>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="col-form-label">SEO Title</label>
                                <input type="text" name="seo_title" class="form-control"
                                    value="{{ old('seo_title', $blog->seo_title) }}">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="col-form-label">Tags</label>
                                <input type="text" name="tags" class="form-control"
       value="{{ old('tags',$tagNames) }}"
       placeholder="Enter tags separated by commas (e.g. tag1, tag2)">

                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="col-form-label">Industry</label>
                           
                                
                             <select name="category" class="form-select">
                               
                                    @foreach ($industry as $item)
                                        @php
                                            $decoded = urldecode($item->name);
                                            $slug = Str::slug($decoded);
                                            $value = $item->id . '-' . $slug;
                                        @endphp
                                        <option value="{{ $value }}"
                                            {{ old('category', $blog->category) == $value ? 'selected' : '' }}>
                                            {{ $decoded }}
                                        </option>
                                    @endforeach
                            </select>
                            </div>
                            <div class="col-md-12 mb-3">
                                <label class="col-form-label">Content <span class="text-danger">*</span></label>
                                <textarea class="form-control" name="content" id="editor2" required>{{ old('content', $blog->content) }}</textarea>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="col-form-label">Image</label>
                                <input type="file" name="image" class="form-control">
                                @if ($blog->image)
                                    <img src="{{ asset($blog->image) }}" alt="Current image" class="mt-2"
                                        style="max-width: 200px;">
                                @endif
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="col-form-label">SEO Description</label>
                                <textarea name="seo_description" class="form-control" rows="4">{{ old('seo_description', $blog->seo_description) }}</textarea>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="col-form-label">SEO Keywords</label>
                                <input type="text" name="seo_keywords" class="form-control"
                                    value="{{ old('seo_keywords', $blog->seo_keywords) }}">
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="d-flex align-items-center mb-3">
                                    <label class="form-check-label mt-0 me-2 text-dark fw-medium">Publish</label>
                                                              <div class="custom-control custom-switch">
    <input type="checkbox" class="custom-control-input" id="isPublished" name="is_published" {{ old('is_published', $blog->is_published) ? 'checked' : '' }}>
    <label class="custom-control-label" for="isPublished"></label>
                                    <!-- <div class="form-check form-switch me-2">
                                        <input class="form-check-input me-2" name="is_published" type="checkbox"
                                            role="switch" {{ old('is_published', $blog->is_published) ? 'checked' : '' }}>
                                    </div> -->
                                </div>
                            </div>
                        </div>
                        <div class="d-flex align-items-center justify-content-end">
                            <a href="{{ route('blogs.index') }}" class="btn btn-light me-2">Back</a>
                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>
                    </form>
                <div class="row lead_status">
                </div>

                    </div><!-- /.box-body -->
                </div><!-- /.box -->

            </div><!-- /.col -->
        </div><!-- /.row -->
    </section><!-- /.content -->



   <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM="
        crossorigin="anonymous"></script>

    <script src="https://cdn.ckeditor.com/4.22.1/standard/ckeditor.js"></script>
<script>
    CKEDITOR.replace('editor2', {
         versionCheck: false, // prevent update/notification
        toolbar: [
            { name: 'basicstyles', items: ['Bold', 'Italic', 'Underline'] },
            { name: 'paragraph', items: ['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent'] },
            { name: 'links', items: ['Link', 'Unlink'] },
            { name: 'insert', items: ['Image', 'Table', 'HorizontalRule', 'SpecialChar'] },
            { name: 'document', items: ['Source'] },
            { name: 'styles', items: ['Format'] },
            { name: 'tools', items: ['Maximize'] }
        ],
        filebrowserUploadUrl: "{{ route('blogs.upload-image') }}?_token={{ csrf_token() }}",
        filebrowserUploadMethod: 'form'
    });
</script>
    <script>
        // Auto-generate slug from title
        $('#title').on('input', function() {
            let title = $(this).val();
            let slug = title.toLowerCase()
                .replace(/[^a-z0-9]+/g, '-')
                .replace(/(^-|-$)/g, '');
            $('#slug').val(slug);
        });

        // Allow manual slug editing without overwriting unless title changes
        $('#slug').on('input', function() {
            let slug = $(this).val();
            $(this).val(slug.toLowerCase()
                .replace(/[^a-z0-9-]+/g, '')
                .replace(/(^-|-$)/g, ''));
        });
    </script>
@endsection
