@extends('layouts.app')
@section('title', 'Blogs')
@section('content')
    <!-- Main content -->
        <section class="content">

            <div class="row">
                <div class="col-12">
                    <div class="box">
                        <div class="box-body">
                            <h4 class="box-title text-info mb-0"><i class="icon-Cardboard-vr"><span class="path1"></span><span
                                        class="path2"></span></i> Blogs List</h4>
                            <a href="{{ url('/admin/blogs/create') }}" type="button" style="float:right"
                                class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i
                                    class="fa fa-plus"></i> Add Blog</a>
                            <hr class="my-15">                       
                            <div class="table-responsive">
                                <table class="table table mt-0 table-hover" id="blogs-table">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>ID</th>
                                            <th>Image</th>
                                            <th>Title</th>
                                            <th>Category</th>
                                            <!-- <th>Author</th> -->
                                            <th>Status</th>
                                            <th>Created At</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody id="blog-table-body">
                                        @foreach ($blogs as $blog)
                                            <!-- <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>
                                                <img src="{{ asset($blog->image) }}" alt="{{ $blog->title }}" width="100">

                                                </td>
                                                <td>{{ $blog->title }}</td>
                                                <td>{{ $blog->categorySlug }}</td>
                                                <td>
                                                    <span
                                                        class="badge badge-pill badge-status {{ $blog->is_published ? 'bg-success' : 'bg-danger' }}"
                                                        data-bs-toggle="modal" data-bs-target="#status-{{ $blog->id }}"
                                                        data-id="{{ $blog->id }}"
                                                        data-status="{{ $blog->is_published ? 'Published' : 'Draft' }}"
                                                        data-url="{{ route('blogs.index') }}">
                                                        {{ $blog->is_published ? 'Published' : 'Draft' }}
                                                    </span>
                                                </td>
                                                <td>{{ \Carbon\Carbon::parse($blog->created_at)->format('Y-m-d') }}</td>
                                                <td>
                                                    <div class="dropdown dropstart table-action" >
                                                        <a href="#" class="action-icon" data-bs-toggle="dropdown"
                                                            aria-expanded="false">
                                                            <i class="fa fa-ellipsis-v"></i>
                                                        </a>
                                                        <div class="dropdown-menu dropdown-menu-end">
                                                            <a class="dropdown-item" href="{{ route('blogs.tag', $blog->id) }}"
                                                                target="_blank">
                                                                <i class="ti ti-eye text-blue-light"></i> Tags
                                                            </a>
                                                            <a class="dropdown-item"
                                                            href="{{ route('blogs.public.show', $blog->id) }}"
                                                            target="_blank">
                                                            <i class="ti ti-eye text-blue-light"></i> Live Preview
                                                        </a>
                                                        <a class="dropdown-item" href="{{ route('blogs.show', $blog->id) }}">
                                                            <i class="ti ti-eye text-blue-light"></i> View
                                                        </a>
                                                        <a class="dropdown-item"
                                                            href="{{ route('blogs.edit', $blog->id) }}">
                                                            <i class="fa fa-edit text-blue"></i> Edit
                                                        </a>
                                                        <a class="dropdown-item delete-document-btn" href="#"
                                                            data-bs-toggle="modal"
                                                            data-bs-target="#delete_activity{{ $blog->id }}">
                                                            <i class="ti ti-trash text-danger"></i> Delete
                                                        </a>
                                                    
                                                        
                                                            <a class="dropdown-item"
                                                                href="{{ route('blogs.restore', $blog->id) }}">
                                                                <i class="fa fa-refresh text-success"></i> Restore
                                                            </a>
                                                        
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr> -->

                                            <!-- Status Modal -->
                                        
                                                    <div class="modal fade" id="status-{{ $blog->id }}" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
                                                        <div class="modal-dialog">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title" id="myModalLabel">Update Status</h5>
                                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                                        aria-label="Close"></button>
                                                                </div>

                                                                <div class="modal-body">
                                                                    <p>Are you sure you want to update the status to
                                                                    {{ $blog->is_published ? 'Draft' : 'Published' }}?</p></p>
                                                                <form method="POST"
                                                                    action="{{ route('blogs.toggle-status', $blog->id) }}"
                                                                    style="display:inline;">
                                                                    @csrf
                                                                    @method('PUT')
                                                                    <input type="hidden" name="is_published"
                                                                        value="{{ $blog->is_published ? 0 : 1 }}">
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-secondary btn-sm"
                                                                        data-bs-dismiss="modal">Close</button>
                                                                    <button type="submit"name="submit"
                                                                        class="btn btn-danger btn-sm deleteCampaign">Update</button>
                                                                        
                                                                </div>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                        
                                                    <div class="modal fade" id="delete_activity{{ $blog->id }}" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
                                                        <div class="modal-dialog">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
                                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                                        aria-label="Close"></button>
                                                                </div>

                                                                <div class="modal-body">
                                                                    <p>You are about to delete <b><i class="title"></i></b>Blog.</p>
                                                                    <p>Do you want to proceed?</p>
                                                                        <form method="POST"
                                                                            action="{{ route('blogs.destroy', $blog->id) }}"
                                                                            style="display:inline;">
                                                                            @csrf
                                                                            @method('DELETE')

                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-secondary btn-sm"
                                                                        data-bs-dismiss="modal">Close</button>
                                                                    <button type="submit"name="submit"
                                                                        class="btn btn-danger btn-sm deleteCampaign">Delete</button>
                                                                        
                                                                </div>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>


                                
                        </div>
                    </div>
                </div>
            </div>
        </section>

   


  <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM="
        crossorigin="anonymous"></script>
  <script>
$(function () {

    $('#blogs-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ route('blogs.index') }}",

        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },

            { data: 'image', name: 'image', orderable: false, searchable: false },

            { data: 'title', name: 'title' },

            { data: 'categorySlug', name: 'categorySlug' },

            { data: 'status', name: 'status', orderable: false },

            { data: 'created_at', name: 'created_at' },

            { data: 'actions', name: 'actions', orderable: false, searchable: false }
        ]
    });

});
</script>
@endsection


