@extends('layouts.app')
@section('title', 'Edit Blog')
@section('content')
<!-- Content Wrapper. Contains page content -->


    <!-- Main content -->
    <section class="content">
        <div class="row">
        <div class="col-lg-12 col-12">
                <div class="box">

                         
                             <div class="box-body"><!--bg-lightest-->
                             <h4 class="box-title text-info mb-0"><i class="fa fa-list"></i> {{ $blog->title }}</h4>
            <a href="{{url('/admin/blogs')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i> Blogs</a>
            <hr class="my-15">

                <div class="card-body">
                    @if ($blog->image)
                        <img src="{{ asset($blog->image) }}" alt="{{ $blog->title }}" class="img-fluid mb-3"
                            style="max-height: 400px; object-fit: cover;">
                    @endif
                    <div class="prose">
                        {!! $blog->content !!}
                    </div>
                    @auth
                        @if (auth()->user()->is_admin)
                            <div class="mt-4 d-flex align-items-center">
                                <a href="#" class="btn btn-primary me-2" data-bs-toggle="offcanvas"
                                    data-bs-target="#offcanvas_edit_{{ $blog->id }}">
                                    <i class="ti ti-edit"></i> Edit
                                </a>
                                <form action="{{ route('blogs.destroy', $blog->slug) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure?')">
                                        <i class="ti ti-trash"></i> Delete
                                    </button>
                                </form>
                            </div>
                        @endif
                    @endauth
                    <a href="{{ route('blogs.index') }}" class="btn btn-light mt-3">Back to Blogs</a>
                </div>
                <div class="row lead_status">
                </div>

                    </div><!-- /.box-body -->
                </div><!-- /.box -->

            </div><!-- /.col -->
        </div><!-- /.row -->
    </section><!-- /.content -->



   <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM="
        crossorigin="anonymous"></script>

    <script src="https://cdn.ckeditor.com/4.22.1/standard/ckeditor.js"></script>
<script>
    CKEDITOR.replace('editor2', {
         versionCheck: false, // prevent update/notification
        toolbar: [
            { name: 'basicstyles', items: ['Bold', 'Italic', 'Underline'] },
            { name: 'paragraph', items: ['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent'] },
            { name: 'links', items: ['Link', 'Unlink'] },
            { name: 'insert', items: ['Image', 'Table', 'HorizontalRule', 'SpecialChar'] },
            { name: 'document', items: ['Source'] },
            { name: 'styles', items: ['Format'] },
            { name: 'tools', items: ['Maximize'] }
        ],
        filebrowserUploadUrl: "{{ route('blogs.upload-image') }}?_token={{ csrf_token() }}",
        filebrowserUploadMethod: 'form'
    });
</script>
    <script>
        // Auto-generate slug from title
        $('#title').on('input', function() {
            let title = $(this).val();
            let slug = title.toLowerCase()
                .replace(/[^a-z0-9]+/g, '-')
                .replace(/(^-|-$)/g, '');
            $('#slug').val(slug);
        });

        // Allow manual slug editing without overwriting unless title changes
        $('#slug').on('input', function() {
            let slug = $(this).val();
            $(this).val(slug.toLowerCase()
                .replace(/[^a-z0-9-]+/g, '')
                .replace(/(^-|-$)/g, ''));
        });
    </script>
@endsection
